#include <metal_stdlib>
#include <simd/simd.h>
using namespace metal;
#ifdef alpha_channel
#undef alpha_channel
#endif
#ifdef red_channel
#undef red_channel
#endif
#ifdef green_channel
#undef green_channel
#endif
#ifdef blue_channel
#undef blue_channel
#endif
#ifdef envmap_preview
#undef envmap_preview
#endif
namespace SNAP_VS {
int sc_GetStereoViewIndex()
{
return 0;
}
}
#ifndef sc_TextureRenderingLayout_Regular
#define sc_TextureRenderingLayout_Regular 0
#define sc_TextureRenderingLayout_StereoInstancedClipped 1
#define sc_TextureRenderingLayout_StereoMultiview 2
#endif
#ifdef uv2
#undef uv2
#endif
#ifdef uv3
#undef uv3
#endif
// SCC_BACKEND_SHADER_FLAGS_BEGIN__
// SCC_BACKEND_SHADER_FLAGS_END__
//SG_REFLECTION_BEGIN(200)
//attribute vec4 boneData 5
//attribute vec3 blendShape0Pos 6
//attribute vec3 blendShape0Normal 12
//attribute vec3 blendShape1Pos 7
//attribute vec3 blendShape1Normal 13
//attribute vec3 blendShape2Pos 8
//attribute vec3 blendShape2Normal 14
//attribute vec3 blendShape3Pos 9
//attribute vec3 blendShape4Pos 10
//attribute vec3 blendShape5Pos 11
//attribute vec4 position 0
//attribute vec3 normal 1
//attribute vec4 tangent 2
//attribute vec2 texture0 3
//attribute vec2 texture1 4
//attribute vec4 color 18
//attribute vec3 positionNext 15
//attribute vec3 positionPrevious 16
//attribute vec4 strandProperties 17
//output vec4 FragColor0 0
//output vec4 FragColor1 1
//output vec4 FragColor2 2
//output vec4 FragColor3 3
//sampler sampler baseTexSmpSC 0:22
//sampler sampler intensityTextureSmpSC 0:23
//sampler sampler sc_ScreenTextureSmpSC 0:28
//sampler sampler z_hitIdAndBarycentricSmp 0:31
//sampler sampler z_rayDirectionsSmpSC 0:32
//texture texture2D baseTex 0:4:0:22
//texture texture2D intensityTexture 0:5:0:23
//texture texture2D sc_ScreenTexture 0:17:0:28
//texture utexture2D z_hitIdAndBarycentric 0:20:0:31
//texture texture2D z_rayDirections 0:21:0:32
//ubo float sc_BonesUBO 0:3:96 {
//sc_Bone_t sc_Bones 0:[1]:96
//float4 sc_Bones.boneMatrix 0:[3]:16
//float4 sc_Bones.normalMatrix 48:[3]:16
//}
//ubo int UserUniforms 0:33:4544 {
//float4 sc_Time 1376
//float4 sc_UniformConstants 1392
//float4x4 sc_ViewProjectionMatrixArray 1680:[2]:64
//float4x4 sc_ModelViewMatrixArray 1936:[2]:64
//float4x4 sc_ProjectionMatrixArray 2384:[2]:64
//float4x4 sc_ProjectionMatrixInverseArray 2512:[2]:64
//float4x4 sc_ViewMatrixArray 2640:[2]:64
//float4x4 sc_PrevFrameViewProjectionMatrixArray 2896:[2]:64
//float4x4 sc_ModelMatrix 3024
//float4x4 sc_ModelMatrixInverse 3088
//float3x3 sc_NormalMatrix 3152
//float4x4 sc_PrevFrameModelMatrix 3248
//float4 sc_CurrentRenderTargetDims 3456
//sc_Camera_t sc_Camera 3472
//float3 sc_Camera.position 0
//float sc_Camera.aspect 16
//float2 sc_Camera.clipPlanes 24
//float sc_ShadowDensity 3504
//float4 sc_ShadowColor 3520
//float4x4 sc_ProjectorMatrix 3536
//float4 weights0 3616
//float4 weights1 3632
//float4 sc_StereoClipPlanes 3664:[2]:16
//float2 sc_TAAJitterOffset 3704
//bool isProxyMode 3824
//int instance_id 3828
//int lray_triangles_last 3832
//bool noEarlyZ 3836
//bool has_animated_pn 3840
//int emitter_stride 3844
//int proxy_offset_position 3848
//int proxy_offset_normal 3852
//int proxy_offset_tangent 3856
//int proxy_offset_color 3860
//int proxy_offset_texture0 3864
//int proxy_offset_texture1 3868
//int proxy_offset_texture2 3872
//int proxy_offset_texture3 3876
//int proxy_format_position 3880
//int proxy_format_normal 3884
//int proxy_format_tangent 3888
//int proxy_format_color 3892
//int proxy_format_texture0 3896
//int proxy_format_texture1 3900
//int proxy_format_texture2 3904
//int proxy_format_texture3 3908
//float correctedIntensity 3968
//float3x3 intensityTextureTransform 4032
//float4 intensityTextureUvMinMax 4080
//float4 intensityTextureBorderColor 4096
//int PreviewEnabled 4260
//float alphaTestThreshold 4268
//bool alpha_channel 4272
//bool red_channel 4276
//bool green_channel 4280
//bool blue_channel 4284
//bool envmap_preview 4288
//float3x3 baseTexTransform 4352
//float4 baseTexUvMinMax 4400
//float4 baseTexBorderColor 4416
//float Port_Input1_N010 4432
//float2 Port_Input1_N057 4440
//float Port_Value2_N013 4448
//float Port_Input1_N009 4452
//float Port_Input1_N035 4456
//float Port_Value1_N036 4460
//float Port_Input1_N046 4464
//float Port_Input1_N051 4468
//float Port_Input1_N034 4472
//float Port_Value1_N043 4476
//float Port_Input1_N052 4480
//float Port_Input1_N053 4484
//float4 Port_Default_N055 4496
//float4 Port_Default_N050 4512
//float depthRef 4528
//}
//ssbo int layoutIndices 0:0:4 {
//uint _Triangles 0:[1]:4
//}
//ssbo float layoutVerticesPN 0:2:4 {
//float _VerticesPN 0:[1]:4
//}
//ssbo float layoutVertices 0:1:4 {
//float _Vertices 0:[1]:4
//}
//spec_const bool BLEND_MODE_AVERAGE 0 0
//spec_const bool BLEND_MODE_BRIGHT 1 0
//spec_const bool BLEND_MODE_COLOR_BURN 2 0
//spec_const bool BLEND_MODE_COLOR_DODGE 3 0
//spec_const bool BLEND_MODE_COLOR 4 0
//spec_const bool BLEND_MODE_DARKEN 5 0
//spec_const bool BLEND_MODE_DIFFERENCE 6 0
//spec_const bool BLEND_MODE_DIVIDE 7 0
//spec_const bool BLEND_MODE_DIVISION 8 0
//spec_const bool BLEND_MODE_EXCLUSION 9 0
//spec_const bool BLEND_MODE_FORGRAY 10 0
//spec_const bool BLEND_MODE_HARD_GLOW 11 0
//spec_const bool BLEND_MODE_HARD_LIGHT 12 0
//spec_const bool BLEND_MODE_HARD_MIX 13 0
//spec_const bool BLEND_MODE_HARD_PHOENIX 14 0
//spec_const bool BLEND_MODE_HARD_REFLECT 15 0
//spec_const bool BLEND_MODE_HUE 16 0
//spec_const bool BLEND_MODE_INTENSE 17 0
//spec_const bool BLEND_MODE_LIGHTEN 18 0
//spec_const bool BLEND_MODE_LINEAR_LIGHT 19 0
//spec_const bool BLEND_MODE_LUMINOSITY 20 0
//spec_const bool BLEND_MODE_NEGATION 21 0
//spec_const bool BLEND_MODE_NOTBRIGHT 22 0
//spec_const bool BLEND_MODE_OVERLAY 23 0
//spec_const bool BLEND_MODE_PIN_LIGHT 24 0
//spec_const bool BLEND_MODE_REALISTIC 25 0
//spec_const bool BLEND_MODE_SATURATION 26 0
//spec_const bool BLEND_MODE_SOFT_LIGHT 27 0
//spec_const bool BLEND_MODE_SUBTRACT 28 0
//spec_const bool BLEND_MODE_VIVID_LIGHT 29 0
//spec_const bool ENABLE_STIPPLE_PATTERN_TEST 30 0
//spec_const bool SC_USE_CLAMP_TO_BORDER_baseTex 31 0
//spec_const bool SC_USE_CLAMP_TO_BORDER_intensityTexture 32 0
//spec_const bool SC_USE_UV_MIN_MAX_baseTex 33 0
//spec_const bool SC_USE_UV_MIN_MAX_intensityTexture 34 0
//spec_const bool SC_USE_UV_TRANSFORM_baseTex 35 0
//spec_const bool SC_USE_UV_TRANSFORM_intensityTexture 36 0
//spec_const bool UseViewSpaceDepthVariant 37 1
//spec_const bool baseTexHasSwappedViews 38 0
//spec_const bool intensityTextureHasSwappedViews 39 0
//spec_const bool sc_BlendMode_AddWithAlphaFactor 40 0
//spec_const bool sc_BlendMode_Add 41 0
//spec_const bool sc_BlendMode_AlphaTest 42 0
//spec_const bool sc_BlendMode_AlphaToCoverage 43 0
//spec_const bool sc_BlendMode_ColoredGlass 44 0
//spec_const bool sc_BlendMode_Custom 45 0
//spec_const bool sc_BlendMode_Max 46 0
//spec_const bool sc_BlendMode_Min 47 0
//spec_const bool sc_BlendMode_MultiplyOriginal 48 0
//spec_const bool sc_BlendMode_Multiply 49 0
//spec_const bool sc_BlendMode_Normal 50 0
//spec_const bool sc_BlendMode_PremultipliedAlphaAuto 51 0
//spec_const bool sc_BlendMode_PremultipliedAlphaHardware 52 0
//spec_const bool sc_BlendMode_PremultipliedAlpha 53 0
//spec_const bool sc_BlendMode_Screen 54 0
//spec_const bool sc_DepthOnly 55 0
//spec_const bool sc_FramebufferFetch 56 0
//spec_const bool sc_MotionVectorsPass 57 0
//spec_const bool sc_OITCompositingPass 58 0
//spec_const bool sc_OITDepthBoundsPass 59 0
//spec_const bool sc_OITDepthGatherPass 60 0
//spec_const bool sc_ProjectiveShadowsCaster 61 0
//spec_const bool sc_ProjectiveShadowsReceiver 62 0
//spec_const bool sc_ProxyAlphaOne 63 0
//spec_const bool sc_RenderAlphaToColor 64 0
//spec_const bool sc_ScreenTextureHasSwappedViews 65 0
//spec_const bool sc_TAAEnabled 66 0
//spec_const bool sc_VertexBlendingUseNormals 67 0
//spec_const bool sc_VertexBlending 68 0
//spec_const int SC_DEVICE_CLASS 69 -1
//spec_const int SC_SOFTWARE_WRAP_MODE_U_baseTex 70 -1
//spec_const int SC_SOFTWARE_WRAP_MODE_U_intensityTexture 71 -1
//spec_const int SC_SOFTWARE_WRAP_MODE_V_baseTex 72 -1
//spec_const int SC_SOFTWARE_WRAP_MODE_V_intensityTexture 73 -1
//spec_const int baseTexLayout 74 0
//spec_const int intensityTextureLayout 75 0
//spec_const int sc_DepthBufferMode 76 0
//spec_const int sc_RenderingSpace 77 -1
//spec_const int sc_ScreenTextureLayout 78 0
//spec_const int sc_ShaderCacheConstant 79 0
//spec_const int sc_SkinBonesCount 80 0
//spec_const int sc_StereoRenderingMode 81 0
//spec_const int sc_StereoRendering_IsClipDistanceEnabled 82 0
//SG_REFLECTION_END
constant bool BLEND_MODE_AVERAGE [[function_constant(0)]];
constant bool BLEND_MODE_AVERAGE_tmp = is_function_constant_defined(BLEND_MODE_AVERAGE) ? BLEND_MODE_AVERAGE : false;
constant bool BLEND_MODE_BRIGHT [[function_constant(1)]];
constant bool BLEND_MODE_BRIGHT_tmp = is_function_constant_defined(BLEND_MODE_BRIGHT) ? BLEND_MODE_BRIGHT : false;
constant bool BLEND_MODE_COLOR_BURN [[function_constant(2)]];
constant bool BLEND_MODE_COLOR_BURN_tmp = is_function_constant_defined(BLEND_MODE_COLOR_BURN) ? BLEND_MODE_COLOR_BURN : false;
constant bool BLEND_MODE_COLOR_DODGE [[function_constant(3)]];
constant bool BLEND_MODE_COLOR_DODGE_tmp = is_function_constant_defined(BLEND_MODE_COLOR_DODGE) ? BLEND_MODE_COLOR_DODGE : false;
constant bool BLEND_MODE_COLOR [[function_constant(4)]];
constant bool BLEND_MODE_COLOR_tmp = is_function_constant_defined(BLEND_MODE_COLOR) ? BLEND_MODE_COLOR : false;
constant bool BLEND_MODE_DARKEN [[function_constant(5)]];
constant bool BLEND_MODE_DARKEN_tmp = is_function_constant_defined(BLEND_MODE_DARKEN) ? BLEND_MODE_DARKEN : false;
constant bool BLEND_MODE_DIFFERENCE [[function_constant(6)]];
constant bool BLEND_MODE_DIFFERENCE_tmp = is_function_constant_defined(BLEND_MODE_DIFFERENCE) ? BLEND_MODE_DIFFERENCE : false;
constant bool BLEND_MODE_DIVIDE [[function_constant(7)]];
constant bool BLEND_MODE_DIVIDE_tmp = is_function_constant_defined(BLEND_MODE_DIVIDE) ? BLEND_MODE_DIVIDE : false;
constant bool BLEND_MODE_DIVISION [[function_constant(8)]];
constant bool BLEND_MODE_DIVISION_tmp = is_function_constant_defined(BLEND_MODE_DIVISION) ? BLEND_MODE_DIVISION : false;
constant bool BLEND_MODE_EXCLUSION [[function_constant(9)]];
constant bool BLEND_MODE_EXCLUSION_tmp = is_function_constant_defined(BLEND_MODE_EXCLUSION) ? BLEND_MODE_EXCLUSION : false;
constant bool BLEND_MODE_FORGRAY [[function_constant(10)]];
constant bool BLEND_MODE_FORGRAY_tmp = is_function_constant_defined(BLEND_MODE_FORGRAY) ? BLEND_MODE_FORGRAY : false;
constant bool BLEND_MODE_HARD_GLOW [[function_constant(11)]];
constant bool BLEND_MODE_HARD_GLOW_tmp = is_function_constant_defined(BLEND_MODE_HARD_GLOW) ? BLEND_MODE_HARD_GLOW : false;
constant bool BLEND_MODE_HARD_LIGHT [[function_constant(12)]];
constant bool BLEND_MODE_HARD_LIGHT_tmp = is_function_constant_defined(BLEND_MODE_HARD_LIGHT) ? BLEND_MODE_HARD_LIGHT : false;
constant bool BLEND_MODE_HARD_MIX [[function_constant(13)]];
constant bool BLEND_MODE_HARD_MIX_tmp = is_function_constant_defined(BLEND_MODE_HARD_MIX) ? BLEND_MODE_HARD_MIX : false;
constant bool BLEND_MODE_HARD_PHOENIX [[function_constant(14)]];
constant bool BLEND_MODE_HARD_PHOENIX_tmp = is_function_constant_defined(BLEND_MODE_HARD_PHOENIX) ? BLEND_MODE_HARD_PHOENIX : false;
constant bool BLEND_MODE_HARD_REFLECT [[function_constant(15)]];
constant bool BLEND_MODE_HARD_REFLECT_tmp = is_function_constant_defined(BLEND_MODE_HARD_REFLECT) ? BLEND_MODE_HARD_REFLECT : false;
constant bool BLEND_MODE_HUE [[function_constant(16)]];
constant bool BLEND_MODE_HUE_tmp = is_function_constant_defined(BLEND_MODE_HUE) ? BLEND_MODE_HUE : false;
constant bool BLEND_MODE_INTENSE [[function_constant(17)]];
constant bool BLEND_MODE_INTENSE_tmp = is_function_constant_defined(BLEND_MODE_INTENSE) ? BLEND_MODE_INTENSE : false;
constant bool BLEND_MODE_LIGHTEN [[function_constant(18)]];
constant bool BLEND_MODE_LIGHTEN_tmp = is_function_constant_defined(BLEND_MODE_LIGHTEN) ? BLEND_MODE_LIGHTEN : false;
constant bool BLEND_MODE_LINEAR_LIGHT [[function_constant(19)]];
constant bool BLEND_MODE_LINEAR_LIGHT_tmp = is_function_constant_defined(BLEND_MODE_LINEAR_LIGHT) ? BLEND_MODE_LINEAR_LIGHT : false;
constant bool BLEND_MODE_LUMINOSITY [[function_constant(20)]];
constant bool BLEND_MODE_LUMINOSITY_tmp = is_function_constant_defined(BLEND_MODE_LUMINOSITY) ? BLEND_MODE_LUMINOSITY : false;
constant bool BLEND_MODE_NEGATION [[function_constant(21)]];
constant bool BLEND_MODE_NEGATION_tmp = is_function_constant_defined(BLEND_MODE_NEGATION) ? BLEND_MODE_NEGATION : false;
constant bool BLEND_MODE_NOTBRIGHT [[function_constant(22)]];
constant bool BLEND_MODE_NOTBRIGHT_tmp = is_function_constant_defined(BLEND_MODE_NOTBRIGHT) ? BLEND_MODE_NOTBRIGHT : false;
constant bool BLEND_MODE_OVERLAY [[function_constant(23)]];
constant bool BLEND_MODE_OVERLAY_tmp = is_function_constant_defined(BLEND_MODE_OVERLAY) ? BLEND_MODE_OVERLAY : false;
constant bool BLEND_MODE_PIN_LIGHT [[function_constant(24)]];
constant bool BLEND_MODE_PIN_LIGHT_tmp = is_function_constant_defined(BLEND_MODE_PIN_LIGHT) ? BLEND_MODE_PIN_LIGHT : false;
constant bool BLEND_MODE_REALISTIC [[function_constant(25)]];
constant bool BLEND_MODE_REALISTIC_tmp = is_function_constant_defined(BLEND_MODE_REALISTIC) ? BLEND_MODE_REALISTIC : false;
constant bool BLEND_MODE_SATURATION [[function_constant(26)]];
constant bool BLEND_MODE_SATURATION_tmp = is_function_constant_defined(BLEND_MODE_SATURATION) ? BLEND_MODE_SATURATION : false;
constant bool BLEND_MODE_SOFT_LIGHT [[function_constant(27)]];
constant bool BLEND_MODE_SOFT_LIGHT_tmp = is_function_constant_defined(BLEND_MODE_SOFT_LIGHT) ? BLEND_MODE_SOFT_LIGHT : false;
constant bool BLEND_MODE_SUBTRACT [[function_constant(28)]];
constant bool BLEND_MODE_SUBTRACT_tmp = is_function_constant_defined(BLEND_MODE_SUBTRACT) ? BLEND_MODE_SUBTRACT : false;
constant bool BLEND_MODE_VIVID_LIGHT [[function_constant(29)]];
constant bool BLEND_MODE_VIVID_LIGHT_tmp = is_function_constant_defined(BLEND_MODE_VIVID_LIGHT) ? BLEND_MODE_VIVID_LIGHT : false;
constant bool ENABLE_STIPPLE_PATTERN_TEST [[function_constant(30)]];
constant bool ENABLE_STIPPLE_PATTERN_TEST_tmp = is_function_constant_defined(ENABLE_STIPPLE_PATTERN_TEST) ? ENABLE_STIPPLE_PATTERN_TEST : false;
constant bool SC_USE_CLAMP_TO_BORDER_baseTex [[function_constant(31)]];
constant bool SC_USE_CLAMP_TO_BORDER_baseTex_tmp = is_function_constant_defined(SC_USE_CLAMP_TO_BORDER_baseTex) ? SC_USE_CLAMP_TO_BORDER_baseTex : false;
constant bool SC_USE_CLAMP_TO_BORDER_intensityTexture [[function_constant(32)]];
constant bool SC_USE_CLAMP_TO_BORDER_intensityTexture_tmp = is_function_constant_defined(SC_USE_CLAMP_TO_BORDER_intensityTexture) ? SC_USE_CLAMP_TO_BORDER_intensityTexture : false;
constant bool SC_USE_UV_MIN_MAX_baseTex [[function_constant(33)]];
constant bool SC_USE_UV_MIN_MAX_baseTex_tmp = is_function_constant_defined(SC_USE_UV_MIN_MAX_baseTex) ? SC_USE_UV_MIN_MAX_baseTex : false;
constant bool SC_USE_UV_MIN_MAX_intensityTexture [[function_constant(34)]];
constant bool SC_USE_UV_MIN_MAX_intensityTexture_tmp = is_function_constant_defined(SC_USE_UV_MIN_MAX_intensityTexture) ? SC_USE_UV_MIN_MAX_intensityTexture : false;
constant bool SC_USE_UV_TRANSFORM_baseTex [[function_constant(35)]];
constant bool SC_USE_UV_TRANSFORM_baseTex_tmp = is_function_constant_defined(SC_USE_UV_TRANSFORM_baseTex) ? SC_USE_UV_TRANSFORM_baseTex : false;
constant bool SC_USE_UV_TRANSFORM_intensityTexture [[function_constant(36)]];
constant bool SC_USE_UV_TRANSFORM_intensityTexture_tmp = is_function_constant_defined(SC_USE_UV_TRANSFORM_intensityTexture) ? SC_USE_UV_TRANSFORM_intensityTexture : false;
constant bool UseViewSpaceDepthVariant [[function_constant(37)]];
constant bool UseViewSpaceDepthVariant_tmp = is_function_constant_defined(UseViewSpaceDepthVariant) ? UseViewSpaceDepthVariant : true;
constant bool baseTexHasSwappedViews [[function_constant(38)]];
constant bool baseTexHasSwappedViews_tmp = is_function_constant_defined(baseTexHasSwappedViews) ? baseTexHasSwappedViews : false;
constant bool intensityTextureHasSwappedViews [[function_constant(39)]];
constant bool intensityTextureHasSwappedViews_tmp = is_function_constant_defined(intensityTextureHasSwappedViews) ? intensityTextureHasSwappedViews : false;
constant bool sc_BlendMode_AddWithAlphaFactor [[function_constant(40)]];
constant bool sc_BlendMode_AddWithAlphaFactor_tmp = is_function_constant_defined(sc_BlendMode_AddWithAlphaFactor) ? sc_BlendMode_AddWithAlphaFactor : false;
constant bool sc_BlendMode_Add [[function_constant(41)]];
constant bool sc_BlendMode_Add_tmp = is_function_constant_defined(sc_BlendMode_Add) ? sc_BlendMode_Add : false;
constant bool sc_BlendMode_AlphaTest [[function_constant(42)]];
constant bool sc_BlendMode_AlphaTest_tmp = is_function_constant_defined(sc_BlendMode_AlphaTest) ? sc_BlendMode_AlphaTest : false;
constant bool sc_BlendMode_AlphaToCoverage [[function_constant(43)]];
constant bool sc_BlendMode_AlphaToCoverage_tmp = is_function_constant_defined(sc_BlendMode_AlphaToCoverage) ? sc_BlendMode_AlphaToCoverage : false;
constant bool sc_BlendMode_ColoredGlass [[function_constant(44)]];
constant bool sc_BlendMode_ColoredGlass_tmp = is_function_constant_defined(sc_BlendMode_ColoredGlass) ? sc_BlendMode_ColoredGlass : false;
constant bool sc_BlendMode_Custom [[function_constant(45)]];
constant bool sc_BlendMode_Custom_tmp = is_function_constant_defined(sc_BlendMode_Custom) ? sc_BlendMode_Custom : false;
constant bool sc_BlendMode_Max [[function_constant(46)]];
constant bool sc_BlendMode_Max_tmp = is_function_constant_defined(sc_BlendMode_Max) ? sc_BlendMode_Max : false;
constant bool sc_BlendMode_Min [[function_constant(47)]];
constant bool sc_BlendMode_Min_tmp = is_function_constant_defined(sc_BlendMode_Min) ? sc_BlendMode_Min : false;
constant bool sc_BlendMode_MultiplyOriginal [[function_constant(48)]];
constant bool sc_BlendMode_MultiplyOriginal_tmp = is_function_constant_defined(sc_BlendMode_MultiplyOriginal) ? sc_BlendMode_MultiplyOriginal : false;
constant bool sc_BlendMode_Multiply [[function_constant(49)]];
constant bool sc_BlendMode_Multiply_tmp = is_function_constant_defined(sc_BlendMode_Multiply) ? sc_BlendMode_Multiply : false;
constant bool sc_BlendMode_Normal [[function_constant(50)]];
constant bool sc_BlendMode_Normal_tmp = is_function_constant_defined(sc_BlendMode_Normal) ? sc_BlendMode_Normal : false;
constant bool sc_BlendMode_PremultipliedAlphaAuto [[function_constant(51)]];
constant bool sc_BlendMode_PremultipliedAlphaAuto_tmp = is_function_constant_defined(sc_BlendMode_PremultipliedAlphaAuto) ? sc_BlendMode_PremultipliedAlphaAuto : false;
constant bool sc_BlendMode_PremultipliedAlphaHardware [[function_constant(52)]];
constant bool sc_BlendMode_PremultipliedAlphaHardware_tmp = is_function_constant_defined(sc_BlendMode_PremultipliedAlphaHardware) ? sc_BlendMode_PremultipliedAlphaHardware : false;
constant bool sc_BlendMode_PremultipliedAlpha [[function_constant(53)]];
constant bool sc_BlendMode_PremultipliedAlpha_tmp = is_function_constant_defined(sc_BlendMode_PremultipliedAlpha) ? sc_BlendMode_PremultipliedAlpha : false;
constant bool sc_BlendMode_Screen [[function_constant(54)]];
constant bool sc_BlendMode_Screen_tmp = is_function_constant_defined(sc_BlendMode_Screen) ? sc_BlendMode_Screen : false;
constant bool sc_DepthOnly [[function_constant(55)]];
constant bool sc_DepthOnly_tmp = is_function_constant_defined(sc_DepthOnly) ? sc_DepthOnly : false;
constant bool sc_FramebufferFetch [[function_constant(56)]];
constant bool sc_FramebufferFetch_tmp = is_function_constant_defined(sc_FramebufferFetch) ? sc_FramebufferFetch : false;
constant bool sc_MotionVectorsPass [[function_constant(57)]];
constant bool sc_MotionVectorsPass_tmp = is_function_constant_defined(sc_MotionVectorsPass) ? sc_MotionVectorsPass : false;
constant bool sc_OITCompositingPass [[function_constant(58)]];
constant bool sc_OITCompositingPass_tmp = is_function_constant_defined(sc_OITCompositingPass) ? sc_OITCompositingPass : false;
constant bool sc_OITDepthBoundsPass [[function_constant(59)]];
constant bool sc_OITDepthBoundsPass_tmp = is_function_constant_defined(sc_OITDepthBoundsPass) ? sc_OITDepthBoundsPass : false;
constant bool sc_OITDepthGatherPass [[function_constant(60)]];
constant bool sc_OITDepthGatherPass_tmp = is_function_constant_defined(sc_OITDepthGatherPass) ? sc_OITDepthGatherPass : false;
constant bool sc_ProjectiveShadowsCaster [[function_constant(61)]];
constant bool sc_ProjectiveShadowsCaster_tmp = is_function_constant_defined(sc_ProjectiveShadowsCaster) ? sc_ProjectiveShadowsCaster : false;
constant bool sc_ProjectiveShadowsReceiver [[function_constant(62)]];
constant bool sc_ProjectiveShadowsReceiver_tmp = is_function_constant_defined(sc_ProjectiveShadowsReceiver) ? sc_ProjectiveShadowsReceiver : false;
constant bool sc_ProxyAlphaOne [[function_constant(63)]];
constant bool sc_ProxyAlphaOne_tmp = is_function_constant_defined(sc_ProxyAlphaOne) ? sc_ProxyAlphaOne : false;
constant bool sc_RenderAlphaToColor [[function_constant(64)]];
constant bool sc_RenderAlphaToColor_tmp = is_function_constant_defined(sc_RenderAlphaToColor) ? sc_RenderAlphaToColor : false;
constant bool sc_ScreenTextureHasSwappedViews [[function_constant(65)]];
constant bool sc_ScreenTextureHasSwappedViews_tmp = is_function_constant_defined(sc_ScreenTextureHasSwappedViews) ? sc_ScreenTextureHasSwappedViews : false;
constant bool sc_TAAEnabled [[function_constant(66)]];
constant bool sc_TAAEnabled_tmp = is_function_constant_defined(sc_TAAEnabled) ? sc_TAAEnabled : false;
constant bool sc_VertexBlendingUseNormals [[function_constant(67)]];
constant bool sc_VertexBlendingUseNormals_tmp = is_function_constant_defined(sc_VertexBlendingUseNormals) ? sc_VertexBlendingUseNormals : false;
constant bool sc_VertexBlending [[function_constant(68)]];
constant bool sc_VertexBlending_tmp = is_function_constant_defined(sc_VertexBlending) ? sc_VertexBlending : false;
constant int SC_DEVICE_CLASS [[function_constant(69)]];
constant int SC_DEVICE_CLASS_tmp = is_function_constant_defined(SC_DEVICE_CLASS) ? SC_DEVICE_CLASS : -1;
constant int SC_SOFTWARE_WRAP_MODE_U_baseTex [[function_constant(70)]];
constant int SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp = is_function_constant_defined(SC_SOFTWARE_WRAP_MODE_U_baseTex) ? SC_SOFTWARE_WRAP_MODE_U_baseTex : -1;
constant int SC_SOFTWARE_WRAP_MODE_U_intensityTexture [[function_constant(71)]];
constant int SC_SOFTWARE_WRAP_MODE_U_intensityTexture_tmp = is_function_constant_defined(SC_SOFTWARE_WRAP_MODE_U_intensityTexture) ? SC_SOFTWARE_WRAP_MODE_U_intensityTexture : -1;
constant int SC_SOFTWARE_WRAP_MODE_V_baseTex [[function_constant(72)]];
constant int SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp = is_function_constant_defined(SC_SOFTWARE_WRAP_MODE_V_baseTex) ? SC_SOFTWARE_WRAP_MODE_V_baseTex : -1;
constant int SC_SOFTWARE_WRAP_MODE_V_intensityTexture [[function_constant(73)]];
constant int SC_SOFTWARE_WRAP_MODE_V_intensityTexture_tmp = is_function_constant_defined(SC_SOFTWARE_WRAP_MODE_V_intensityTexture) ? SC_SOFTWARE_WRAP_MODE_V_intensityTexture : -1;
constant int baseTexLayout [[function_constant(74)]];
constant int baseTexLayout_tmp = is_function_constant_defined(baseTexLayout) ? baseTexLayout : 0;
constant int intensityTextureLayout [[function_constant(75)]];
constant int intensityTextureLayout_tmp = is_function_constant_defined(intensityTextureLayout) ? intensityTextureLayout : 0;
constant int sc_DepthBufferMode [[function_constant(76)]];
constant int sc_DepthBufferMode_tmp = is_function_constant_defined(sc_DepthBufferMode) ? sc_DepthBufferMode : 0;
constant int sc_RenderingSpace [[function_constant(77)]];
constant int sc_RenderingSpace_tmp = is_function_constant_defined(sc_RenderingSpace) ? sc_RenderingSpace : -1;
constant int sc_ScreenTextureLayout [[function_constant(78)]];
constant int sc_ScreenTextureLayout_tmp = is_function_constant_defined(sc_ScreenTextureLayout) ? sc_ScreenTextureLayout : 0;
constant int sc_ShaderCacheConstant [[function_constant(79)]];
constant int sc_ShaderCacheConstant_tmp = is_function_constant_defined(sc_ShaderCacheConstant) ? sc_ShaderCacheConstant : 0;
constant int sc_SkinBonesCount [[function_constant(80)]];
constant int sc_SkinBonesCount_tmp = is_function_constant_defined(sc_SkinBonesCount) ? sc_SkinBonesCount : 0;
constant int sc_StereoRenderingMode [[function_constant(81)]];
constant int sc_StereoRenderingMode_tmp = is_function_constant_defined(sc_StereoRenderingMode) ? sc_StereoRenderingMode : 0;
constant int sc_StereoRendering_IsClipDistanceEnabled [[function_constant(82)]];
constant int sc_StereoRendering_IsClipDistanceEnabled_tmp = is_function_constant_defined(sc_StereoRendering_IsClipDistanceEnabled) ? sc_StereoRendering_IsClipDistanceEnabled : 0;

namespace SNAP_VS {
struct sc_Vertex_t
{
float4 position;
float3 normal;
float3 tangent;
float2 texture0;
float2 texture1;
};
struct sc_PointLight_t
{
int falloffEnabled;
float falloffEndDistance;
float negRcpFalloffEndDistance4;
float angleScale;
float angleOffset;
float3 direction;
float3 position;
float4 color;
};
struct sc_DirectionalLight_t
{
float3 direction;
float4 color;
};
struct sc_AmbientLight_t
{
float3 color;
float intensity;
};
struct sc_SphericalGaussianLight_t
{
float3 color;
float sharpness;
float3 axis;
};
struct sc_LightEstimationData_t
{
sc_SphericalGaussianLight_t sg[12];
float3 ambientLight;
};
struct sc_Camera_t
{
float3 position;
float aspect;
float2 clipPlanes;
};
struct userUniformsObj
{
sc_PointLight_t sc_PointLights[3];
sc_DirectionalLight_t sc_DirectionalLights[5];
sc_AmbientLight_t sc_AmbientLights[3];
sc_LightEstimationData_t sc_LightEstimationData;
float4 sc_EnvmapDiffuseSize;
float4 sc_EnvmapDiffuseDims;
float4 sc_EnvmapDiffuseView;
float4 sc_EnvmapSpecularSize;
float4 sc_EnvmapSpecularDims;
float4 sc_EnvmapSpecularView;
float3 sc_EnvmapRotation;
float sc_EnvmapExposure;
float3 sc_Sh[9];
float sc_ShIntensity;
float4 sc_Time;
float4 sc_UniformConstants;
float4 sc_GeometryInfo;
float4x4 sc_ModelViewProjectionMatrixArray[2];
float4x4 sc_ModelViewProjectionMatrixInverseArray[2];
float4x4 sc_ViewProjectionMatrixArray[2];
float4x4 sc_ViewProjectionMatrixInverseArray[2];
float4x4 sc_ModelViewMatrixArray[2];
float4x4 sc_ModelViewMatrixInverseArray[2];
float3x3 sc_ViewNormalMatrixArray[2];
float3x3 sc_ViewNormalMatrixInverseArray[2];
float4x4 sc_ProjectionMatrixArray[2];
float4x4 sc_ProjectionMatrixInverseArray[2];
float4x4 sc_ViewMatrixArray[2];
float4x4 sc_ViewMatrixInverseArray[2];
float4x4 sc_PrevFrameViewProjectionMatrixArray[2];
float4x4 sc_ModelMatrix;
float4x4 sc_ModelMatrixInverse;
float3x3 sc_NormalMatrix;
float3x3 sc_NormalMatrixInverse;
float4x4 sc_PrevFrameModelMatrix;
float4x4 sc_PrevFrameModelMatrixInverse;
float3 sc_LocalAabbMin;
float3 sc_LocalAabbMax;
float3 sc_WorldAabbMin;
float3 sc_WorldAabbMax;
float4 sc_WindowToViewportTransform;
float4 sc_CurrentRenderTargetDims;
sc_Camera_t sc_Camera;
float sc_ShadowDensity;
float4 sc_ShadowColor;
float4x4 sc_ProjectorMatrix;
float shaderComplexityValue;
float4 weights0;
float4 weights1;
float4 weights2;
float4 sc_StereoClipPlanes[2];
int sc_FallbackInstanceID;
float2 sc_TAAJitterOffset;
float strandWidth;
float strandTaper;
float4 sc_StrandDataMapTextureSize;
float clumpInstanceCount;
float clumpRadius;
float clumpTipScale;
float hairstyleInstanceCount;
float hairstyleNoise;
float4 sc_ScreenTextureSize;
float4 sc_ScreenTextureDims;
float4 sc_ScreenTextureView;
int isProxyMode;
int instance_id;
int lray_triangles_last;
int noEarlyZ;
int has_animated_pn;
int emitter_stride;
int proxy_offset_position;
int proxy_offset_normal;
int proxy_offset_tangent;
int proxy_offset_color;
int proxy_offset_texture0;
int proxy_offset_texture1;
int proxy_offset_texture2;
int proxy_offset_texture3;
int proxy_format_position;
int proxy_format_normal;
int proxy_format_tangent;
int proxy_format_color;
int proxy_format_texture0;
int proxy_format_texture1;
int proxy_format_texture2;
int proxy_format_texture3;
float4 z_rayDirectionsSize;
float4 z_rayDirectionsDims;
float4 z_rayDirectionsView;
float correctedIntensity;
float4 intensityTextureSize;
float4 intensityTextureDims;
float4 intensityTextureView;
float3x3 intensityTextureTransform;
float4 intensityTextureUvMinMax;
float4 intensityTextureBorderColor;
float reflBlurWidth;
float reflBlurMinRough;
float reflBlurMaxRough;
int overrideTimeEnabled;
float overrideTimeElapsed[32];
float overrideTimeDelta;
int PreviewEnabled;
int PreviewNodeID;
float alphaTestThreshold;
int alpha_channel;
int red_channel;
int green_channel;
int blue_channel;
int envmap_preview;
float4 baseTexSize;
float4 baseTexDims;
float4 baseTexView;
float3x3 baseTexTransform;
float4 baseTexUvMinMax;
float4 baseTexBorderColor;
float Port_Input1_N010;
float2 Port_Input1_N057;
float Port_Value2_N013;
float Port_Input1_N009;
float Port_Input1_N035;
float Port_Value1_N036;
float Port_Input1_N046;
float Port_Input1_N051;
float Port_Input1_N034;
float Port_Value1_N043;
float Port_Input1_N052;
float Port_Input1_N053;
float4 Port_Default_N055;
float4 Port_Default_N050;
float depthRef;
};
struct sc_Bone_t
{
float4 boneMatrix[3];
float4 normalMatrix[3];
};
struct sc_Bones_obj
{
sc_Bone_t sc_Bones[1];
};
struct ssPreviewInfo
{
float4 Color;
bool Saved;
};
struct layoutIndices_obj
{
uint _Triangles[1];
};
struct layoutVertices_obj
{
float _Vertices[1];
};
struct layoutVerticesPN_obj
{
float _VerticesPN[1];
};
struct sc_Set0
{
const device layoutIndices_obj* layoutIndices [[id(0)]];
const device layoutVertices_obj* layoutVertices [[id(1)]];
const device layoutVerticesPN_obj* layoutVerticesPN [[id(2)]];
constant sc_Bones_obj* sc_BonesUBO [[id(3)]];
texture2d<float> baseTex [[id(4)]];
texture2d<float> intensityTexture [[id(5)]];
texture2d<float> sc_ScreenTexture [[id(17)]];
texture2d<uint> z_hitIdAndBarycentric [[id(20)]];
texture2d<float> z_rayDirections [[id(21)]];
sampler baseTexSmpSC [[id(22)]];
sampler intensityTextureSmpSC [[id(23)]];
sampler sc_ScreenTextureSmpSC [[id(28)]];
sampler z_hitIdAndBarycentricSmp [[id(31)]];
sampler z_rayDirectionsSmpSC [[id(32)]];
constant userUniformsObj* UserUniforms [[id(33)]];
};
struct main_vert_out
{
float3 varPos [[user(locn0)]];
float3 varNormal [[user(locn1)]];
float4 varTangent [[user(locn2)]];
float4 varPackedTex [[user(locn3)]];
float4 varScreenPos [[user(locn4)]];
float2 varScreenTexturePos [[user(locn5)]];
float varViewSpaceDepth [[user(locn6)]];
float2 varShadowTex [[user(locn7)]];
int varStereoViewID [[user(locn8)]];
float varClipDistance [[user(locn9)]];
float4 varColor [[user(locn10)]];
float4 PreviewVertexColor [[user(locn11)]];
float PreviewVertexSaved [[user(locn12)]];
float4 gl_Position [[position]];
};
struct main_vert_in
{
float4 position [[attribute(0)]];
float3 normal [[attribute(1)]];
float4 tangent [[attribute(2)]];
float2 texture0 [[attribute(3)]];
float2 texture1 [[attribute(4)]];
float4 boneData [[attribute(5)]];
float3 blendShape0Pos [[attribute(6)]];
float3 blendShape1Pos [[attribute(7)]];
float3 blendShape2Pos [[attribute(8)]];
float3 blendShape3Pos [[attribute(9)]];
float3 blendShape4Pos [[attribute(10)]];
float3 blendShape5Pos [[attribute(11)]];
float3 blendShape0Normal [[attribute(12)]];
float3 blendShape1Normal [[attribute(13)]];
float3 blendShape2Normal [[attribute(14)]];
float3 positionNext [[attribute(15)]];
float3 positionPrevious [[attribute(16)]];
float4 strandProperties [[attribute(17)]];
float4 color [[attribute(18)]];
};
vertex main_vert_out main_vert(main_vert_in in [[stage_in]],constant sc_Set0& sc_set0 [[buffer(0)]],uint gl_InstanceIndex [[instance_id]])
{
main_vert_out out={};
bool l9_0=(*sc_set0.UserUniforms).isProxyMode!=0;
if (l9_0)
{
float4 param=float4(in.position.xy,(*sc_set0.UserUniforms).depthRef+(1e-10*in.position.z),1.0+(1e-10*in.position.w));
if (sc_ShaderCacheConstant_tmp!=0)
{
param.x+=((*sc_set0.UserUniforms).sc_UniformConstants.x*float(sc_ShaderCacheConstant_tmp));
}
if (sc_StereoRenderingMode_tmp>0)
{
out.varStereoViewID=gl_InstanceIndex%2;
}
float4 l9_1=param;
if (sc_StereoRenderingMode_tmp==1)
{
float l9_2=dot(l9_1,(*sc_set0.UserUniforms).sc_StereoClipPlanes[gl_InstanceIndex%2]);
float l9_3=l9_2;
if (sc_StereoRendering_IsClipDistanceEnabled_tmp==1)
{
}
else
{
out.varClipDistance=l9_3;
}
}
float4 l9_4=float4(param.x,-param.y,(param.z*0.5)+(param.w*0.5),param.w);
out.gl_Position=l9_4;
return out;
}
out.PreviewVertexColor=float4(0.5);
ssPreviewInfo PreviewInfo;
PreviewInfo.Color=float4(0.5);
PreviewInfo.Saved=false;
out.PreviewVertexSaved=0.0;
sc_Vertex_t l9_6;
l9_6.position=in.position;
l9_6.normal=in.normal;
l9_6.tangent=in.tangent.xyz;
l9_6.texture0=in.texture0;
l9_6.texture1=in.texture1;
sc_Vertex_t l9_7=l9_6;
sc_Vertex_t param_1=l9_7;
sc_Vertex_t l9_8=param_1;
if ((int(sc_VertexBlending_tmp)!=0))
{
if ((int(sc_VertexBlendingUseNormals_tmp)!=0))
{
sc_Vertex_t l9_9=l9_8;
float3 l9_10=in.blendShape0Pos;
float3 l9_11=in.blendShape0Normal;
float l9_12=(*sc_set0.UserUniforms).weights0.x;
sc_Vertex_t l9_13=l9_9;
float3 l9_14=l9_10;
float l9_15=l9_12;
float3 l9_16=l9_13.position.xyz+(l9_14*l9_15);
l9_13.position=float4(l9_16.x,l9_16.y,l9_16.z,l9_13.position.w);
l9_9=l9_13;
l9_9.normal+=(l9_11*l9_12);
l9_8=l9_9;
sc_Vertex_t l9_17=l9_8;
float3 l9_18=in.blendShape1Pos;
float3 l9_19=in.blendShape1Normal;
float l9_20=(*sc_set0.UserUniforms).weights0.y;
sc_Vertex_t l9_21=l9_17;
float3 l9_22=l9_18;
float l9_23=l9_20;
float3 l9_24=l9_21.position.xyz+(l9_22*l9_23);
l9_21.position=float4(l9_24.x,l9_24.y,l9_24.z,l9_21.position.w);
l9_17=l9_21;
l9_17.normal+=(l9_19*l9_20);
l9_8=l9_17;
sc_Vertex_t l9_25=l9_8;
float3 l9_26=in.blendShape2Pos;
float3 l9_27=in.blendShape2Normal;
float l9_28=(*sc_set0.UserUniforms).weights0.z;
sc_Vertex_t l9_29=l9_25;
float3 l9_30=l9_26;
float l9_31=l9_28;
float3 l9_32=l9_29.position.xyz+(l9_30*l9_31);
l9_29.position=float4(l9_32.x,l9_32.y,l9_32.z,l9_29.position.w);
l9_25=l9_29;
l9_25.normal+=(l9_27*l9_28);
l9_8=l9_25;
}
else
{
sc_Vertex_t l9_33=l9_8;
float3 l9_34=in.blendShape0Pos;
float l9_35=(*sc_set0.UserUniforms).weights0.x;
float3 l9_36=l9_33.position.xyz+(l9_34*l9_35);
l9_33.position=float4(l9_36.x,l9_36.y,l9_36.z,l9_33.position.w);
l9_8=l9_33;
sc_Vertex_t l9_37=l9_8;
float3 l9_38=in.blendShape1Pos;
float l9_39=(*sc_set0.UserUniforms).weights0.y;
float3 l9_40=l9_37.position.xyz+(l9_38*l9_39);
l9_37.position=float4(l9_40.x,l9_40.y,l9_40.z,l9_37.position.w);
l9_8=l9_37;
sc_Vertex_t l9_41=l9_8;
float3 l9_42=in.blendShape2Pos;
float l9_43=(*sc_set0.UserUniforms).weights0.z;
float3 l9_44=l9_41.position.xyz+(l9_42*l9_43);
l9_41.position=float4(l9_44.x,l9_44.y,l9_44.z,l9_41.position.w);
l9_8=l9_41;
sc_Vertex_t l9_45=l9_8;
float3 l9_46=in.blendShape3Pos;
float l9_47=(*sc_set0.UserUniforms).weights0.w;
float3 l9_48=l9_45.position.xyz+(l9_46*l9_47);
l9_45.position=float4(l9_48.x,l9_48.y,l9_48.z,l9_45.position.w);
l9_8=l9_45;
sc_Vertex_t l9_49=l9_8;
float3 l9_50=in.blendShape4Pos;
float l9_51=(*sc_set0.UserUniforms).weights1.x;
float3 l9_52=l9_49.position.xyz+(l9_50*l9_51);
l9_49.position=float4(l9_52.x,l9_52.y,l9_52.z,l9_49.position.w);
l9_8=l9_49;
sc_Vertex_t l9_53=l9_8;
float3 l9_54=in.blendShape5Pos;
float l9_55=(*sc_set0.UserUniforms).weights1.y;
float3 l9_56=l9_53.position.xyz+(l9_54*l9_55);
l9_53.position=float4(l9_56.x,l9_56.y,l9_56.z,l9_53.position.w);
l9_8=l9_53;
}
}
param_1=l9_8;
sc_Vertex_t l9_57=param_1;
if (sc_SkinBonesCount_tmp>0)
{
float4 l9_58=float4(0.0);
if (sc_SkinBonesCount_tmp>0)
{
l9_58=float4(1.0,fract(in.boneData.yzw));
l9_58.x-=dot(l9_58.yzw,float3(1.0));
}
float4 l9_59=l9_58;
float4 l9_60=l9_59;
int l9_61=int(in.boneData.x);
int l9_62=int(in.boneData.y);
int l9_63=int(in.boneData.z);
int l9_64=int(in.boneData.w);
int l9_65=l9_61;
float4 l9_66=l9_57.position;
float3 l9_67=float3(0.0);
if (sc_SkinBonesCount_tmp>0)
{
int l9_68=l9_65;
float4 l9_69=(*sc_set0.sc_BonesUBO).sc_Bones[l9_68].boneMatrix[0];
float4 l9_70=(*sc_set0.sc_BonesUBO).sc_Bones[l9_68].boneMatrix[1];
float4 l9_71=(*sc_set0.sc_BonesUBO).sc_Bones[l9_68].boneMatrix[2];
float4 l9_72[3];
l9_72[0]=l9_69;
l9_72[1]=l9_70;
l9_72[2]=l9_71;
l9_67=float3(dot(l9_66,l9_72[0]),dot(l9_66,l9_72[1]),dot(l9_66,l9_72[2]));
}
else
{
l9_67=l9_66.xyz;
}
float3 l9_73=l9_67;
float3 l9_74=l9_73;
float l9_75=l9_60.x;
int l9_76=l9_62;
float4 l9_77=l9_57.position;
float3 l9_78=float3(0.0);
if (sc_SkinBonesCount_tmp>0)
{
int l9_79=l9_76;
float4 l9_80=(*sc_set0.sc_BonesUBO).sc_Bones[l9_79].boneMatrix[0];
float4 l9_81=(*sc_set0.sc_BonesUBO).sc_Bones[l9_79].boneMatrix[1];
float4 l9_82=(*sc_set0.sc_BonesUBO).sc_Bones[l9_79].boneMatrix[2];
float4 l9_83[3];
l9_83[0]=l9_80;
l9_83[1]=l9_81;
l9_83[2]=l9_82;
l9_78=float3(dot(l9_77,l9_83[0]),dot(l9_77,l9_83[1]),dot(l9_77,l9_83[2]));
}
else
{
l9_78=l9_77.xyz;
}
float3 l9_84=l9_78;
float3 l9_85=l9_84;
float l9_86=l9_60.y;
int l9_87=l9_63;
float4 l9_88=l9_57.position;
float3 l9_89=float3(0.0);
if (sc_SkinBonesCount_tmp>0)
{
int l9_90=l9_87;
float4 l9_91=(*sc_set0.sc_BonesUBO).sc_Bones[l9_90].boneMatrix[0];
float4 l9_92=(*sc_set0.sc_BonesUBO).sc_Bones[l9_90].boneMatrix[1];
float4 l9_93=(*sc_set0.sc_BonesUBO).sc_Bones[l9_90].boneMatrix[2];
float4 l9_94[3];
l9_94[0]=l9_91;
l9_94[1]=l9_92;
l9_94[2]=l9_93;
l9_89=float3(dot(l9_88,l9_94[0]),dot(l9_88,l9_94[1]),dot(l9_88,l9_94[2]));
}
else
{
l9_89=l9_88.xyz;
}
float3 l9_95=l9_89;
float3 l9_96=l9_95;
float l9_97=l9_60.z;
int l9_98=l9_64;
float4 l9_99=l9_57.position;
float3 l9_100=float3(0.0);
if (sc_SkinBonesCount_tmp>0)
{
int l9_101=l9_98;
float4 l9_102=(*sc_set0.sc_BonesUBO).sc_Bones[l9_101].boneMatrix[0];
float4 l9_103=(*sc_set0.sc_BonesUBO).sc_Bones[l9_101].boneMatrix[1];
float4 l9_104=(*sc_set0.sc_BonesUBO).sc_Bones[l9_101].boneMatrix[2];
float4 l9_105[3];
l9_105[0]=l9_102;
l9_105[1]=l9_103;
l9_105[2]=l9_104;
l9_100=float3(dot(l9_99,l9_105[0]),dot(l9_99,l9_105[1]),dot(l9_99,l9_105[2]));
}
else
{
l9_100=l9_99.xyz;
}
float3 l9_106=l9_100;
float3 l9_107=(((l9_74*l9_75)+(l9_85*l9_86))+(l9_96*l9_97))+(l9_106*l9_60.w);
l9_57.position=float4(l9_107.x,l9_107.y,l9_107.z,l9_57.position.w);
int l9_108=l9_61;
float3x3 l9_109=float3x3(float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_108].normalMatrix[0].xyz),float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_108].normalMatrix[1].xyz),float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_108].normalMatrix[2].xyz));
float3x3 l9_110=l9_109;
float3x3 l9_111=l9_110;
int l9_112=l9_62;
float3x3 l9_113=float3x3(float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_112].normalMatrix[0].xyz),float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_112].normalMatrix[1].xyz),float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_112].normalMatrix[2].xyz));
float3x3 l9_114=l9_113;
float3x3 l9_115=l9_114;
int l9_116=l9_63;
float3x3 l9_117=float3x3(float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_116].normalMatrix[0].xyz),float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_116].normalMatrix[1].xyz),float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_116].normalMatrix[2].xyz));
float3x3 l9_118=l9_117;
float3x3 l9_119=l9_118;
int l9_120=l9_64;
float3x3 l9_121=float3x3(float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_120].normalMatrix[0].xyz),float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_120].normalMatrix[1].xyz),float3((*sc_set0.sc_BonesUBO).sc_Bones[l9_120].normalMatrix[2].xyz));
float3x3 l9_122=l9_121;
float3x3 l9_123=l9_122;
l9_57.normal=((((l9_111*l9_57.normal)*l9_60.x)+((l9_115*l9_57.normal)*l9_60.y))+((l9_119*l9_57.normal)*l9_60.z))+((l9_123*l9_57.normal)*l9_60.w);
l9_57.tangent=((((l9_111*l9_57.tangent)*l9_60.x)+((l9_115*l9_57.tangent)*l9_60.y))+((l9_119*l9_57.tangent)*l9_60.z))+((l9_123*l9_57.tangent)*l9_60.w);
}
param_1=l9_57;
if (sc_RenderingSpace_tmp==3)
{
out.varPos=float3(0.0);
out.varNormal=param_1.normal;
out.varTangent=float4(param_1.tangent.x,param_1.tangent.y,param_1.tangent.z,out.varTangent.w);
}
else
{
if (sc_RenderingSpace_tmp==4)
{
out.varPos=float3(0.0);
out.varNormal=param_1.normal;
out.varTangent=float4(param_1.tangent.x,param_1.tangent.y,param_1.tangent.z,out.varTangent.w);
}
else
{
if (sc_RenderingSpace_tmp==2)
{
out.varPos=param_1.position.xyz;
out.varNormal=param_1.normal;
out.varTangent=float4(param_1.tangent.x,param_1.tangent.y,param_1.tangent.z,out.varTangent.w);
}
else
{
if (sc_RenderingSpace_tmp==1)
{
out.varPos=((*sc_set0.UserUniforms).sc_ModelMatrix*param_1.position).xyz;
out.varNormal=(*sc_set0.UserUniforms).sc_NormalMatrix*param_1.normal;
float3 l9_124=(*sc_set0.UserUniforms).sc_NormalMatrix*param_1.tangent;
out.varTangent=float4(l9_124.x,l9_124.y,l9_124.z,out.varTangent.w);
}
}
}
}
if ((*sc_set0.UserUniforms).PreviewEnabled==1)
{
param_1.texture0.x=1.0-param_1.texture0.x;
}
out.varColor=in.color;
sc_Vertex_t v=param_1;
float3 WorldPosition=out.varPos;
float3 WorldNormal=out.varNormal;
float3 WorldTangent=out.varTangent.xyz;
if ((*sc_set0.UserUniforms).PreviewEnabled==1)
{
WorldPosition=out.varPos;
WorldNormal=out.varNormal;
WorldTangent=out.varTangent.xyz;
}
sc_Vertex_t param_2=v;
float3 param_3=WorldPosition;
float3 param_4=WorldNormal;
float3 param_5=WorldTangent;
float4 param_6=v.position;
out.varPos=param_3;
out.varNormal=normalize(param_4);
float3 l9_125=normalize(param_5);
out.varTangent=float4(l9_125.x,l9_125.y,l9_125.z,out.varTangent.w);
out.varTangent.w=in.tangent.w;
if ((int(UseViewSpaceDepthVariant_tmp)!=0)&&(((int(sc_OITDepthGatherPass_tmp)!=0)||(int(sc_OITCompositingPass_tmp)!=0))||(int(sc_OITDepthBoundsPass_tmp)!=0)))
{
float4 l9_126=param_2.position;
float4 l9_127=float4(0.0);
if (sc_RenderingSpace_tmp==3)
{
int l9_128=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_128=0;
}
else
{
l9_128=gl_InstanceIndex%2;
}
int l9_129=l9_128;
l9_127=(*sc_set0.UserUniforms).sc_ProjectionMatrixInverseArray[l9_129]*l9_126;
}
else
{
if (sc_RenderingSpace_tmp==2)
{
int l9_130=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_130=0;
}
else
{
l9_130=gl_InstanceIndex%2;
}
int l9_131=l9_130;
l9_127=(*sc_set0.UserUniforms).sc_ViewMatrixArray[l9_131]*l9_126;
}
else
{
if (sc_RenderingSpace_tmp==1)
{
int l9_132=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_132=0;
}
else
{
l9_132=gl_InstanceIndex%2;
}
int l9_133=l9_132;
l9_127=(*sc_set0.UserUniforms).sc_ModelViewMatrixArray[l9_133]*l9_126;
}
else
{
l9_127=l9_126;
}
}
}
float4 l9_134=l9_127;
out.varViewSpaceDepth=-l9_134.z;
}
float4 l9_135=float4(0.0);
if (sc_RenderingSpace_tmp==3)
{
l9_135=param_6;
}
else
{
if (sc_RenderingSpace_tmp==4)
{
int l9_136=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_136=0;
}
else
{
l9_136=gl_InstanceIndex%2;
}
int l9_137=l9_136;
l9_135=((*sc_set0.UserUniforms).sc_ModelViewMatrixArray[l9_137]*param_2.position)*float4(1.0/(*sc_set0.UserUniforms).sc_Camera.aspect,1.0,1.0,1.0);
}
else
{
if (sc_RenderingSpace_tmp==2)
{
int l9_138=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_138=0;
}
else
{
l9_138=gl_InstanceIndex%2;
}
int l9_139=l9_138;
l9_135=(*sc_set0.UserUniforms).sc_ViewProjectionMatrixArray[l9_139]*float4(out.varPos,1.0);
}
else
{
if (sc_RenderingSpace_tmp==1)
{
int l9_140=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_140=0;
}
else
{
l9_140=gl_InstanceIndex%2;
}
int l9_141=l9_140;
l9_135=(*sc_set0.UserUniforms).sc_ViewProjectionMatrixArray[l9_141]*float4(out.varPos,1.0);
}
}
}
}
out.varPackedTex=float4(param_2.texture0,param_2.texture1);
if ((int(sc_ProjectiveShadowsReceiver_tmp)!=0))
{
float4 l9_142=param_2.position;
float4 l9_143=l9_142;
if (sc_RenderingSpace_tmp==1)
{
l9_143=(*sc_set0.UserUniforms).sc_ModelMatrix*l9_142;
}
float4 l9_144=(*sc_set0.UserUniforms).sc_ProjectorMatrix*l9_143;
float2 l9_145=((l9_144.xy/float2(l9_144.w))*0.5)+float2(0.5);
out.varShadowTex=l9_145;
}
float4 l9_146=l9_135;
if (sc_DepthBufferMode_tmp==1)
{
int l9_147=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_147=0;
}
else
{
l9_147=gl_InstanceIndex%2;
}
int l9_148=l9_147;
if ((*sc_set0.UserUniforms).sc_ProjectionMatrixArray[l9_148][2].w!=0.0)
{
float l9_149=2.0/log2((*sc_set0.UserUniforms).sc_Camera.clipPlanes.y+1.0);
l9_146.z=((log2(fast::max((*sc_set0.UserUniforms).sc_Camera.clipPlanes.x,1.0+l9_146.w))*l9_149)-1.0)*l9_146.w;
}
}
float4 l9_150=l9_146;
l9_135=l9_150;
float4 l9_151=l9_135;
if ((int(sc_TAAEnabled_tmp)!=0))
{
float2 l9_152=l9_151.xy+((*sc_set0.UserUniforms).sc_TAAJitterOffset*l9_151.w);
l9_151=float4(l9_152.x,l9_152.y,l9_151.z,l9_151.w);
}
float4 l9_153=l9_151;
l9_135=l9_153;
float4 l9_154=l9_135;
if (sc_ShaderCacheConstant_tmp!=0)
{
l9_154.x+=((*sc_set0.UserUniforms).sc_UniformConstants.x*float(sc_ShaderCacheConstant_tmp));
}
if (sc_StereoRenderingMode_tmp>0)
{
out.varStereoViewID=gl_InstanceIndex%2;
}
float4 l9_155=l9_154;
if (sc_StereoRenderingMode_tmp==1)
{
float l9_156=dot(l9_155,(*sc_set0.UserUniforms).sc_StereoClipPlanes[gl_InstanceIndex%2]);
float l9_157=l9_156;
if (sc_StereoRendering_IsClipDistanceEnabled_tmp==1)
{
}
else
{
out.varClipDistance=l9_157;
}
}
float4 l9_158=float4(l9_154.x,-l9_154.y,(l9_154.z*0.5)+(l9_154.w*0.5),l9_154.w);
out.gl_Position=l9_158;
v=param_2;
if (PreviewInfo.Saved)
{
out.PreviewVertexColor=float4(PreviewInfo.Color.xyz,1.0);
out.PreviewVertexSaved=1.0;
}
return out;
}
} // VERTEX SHADER


namespace SNAP_FS {
struct RayHitPayload
{
float3 viewDirWS;
float3 positionWS;
float3 normalWS;
float4 tangentWS;
float4 color;
float2 uv0;
float2 uv1;
float2 uv2;
float2 uv3;
uint2 id;
};
struct ssGlobals
{
float gTimeElapsed;
float gTimeDelta;
float gTimeElapsedShifted;
float2 Surface_UVCoord0;
};
struct sc_PointLight_t
{
int falloffEnabled;
float falloffEndDistance;
float negRcpFalloffEndDistance4;
float angleScale;
float angleOffset;
float3 direction;
float3 position;
float4 color;
};
struct sc_DirectionalLight_t
{
float3 direction;
float4 color;
};
struct sc_AmbientLight_t
{
float3 color;
float intensity;
};
struct sc_SphericalGaussianLight_t
{
float3 color;
float sharpness;
float3 axis;
};
struct sc_LightEstimationData_t
{
sc_SphericalGaussianLight_t sg[12];
float3 ambientLight;
};
struct sc_Camera_t
{
float3 position;
float aspect;
float2 clipPlanes;
};
struct userUniformsObj
{
sc_PointLight_t sc_PointLights[3];
sc_DirectionalLight_t sc_DirectionalLights[5];
sc_AmbientLight_t sc_AmbientLights[3];
sc_LightEstimationData_t sc_LightEstimationData;
float4 sc_EnvmapDiffuseSize;
float4 sc_EnvmapDiffuseDims;
float4 sc_EnvmapDiffuseView;
float4 sc_EnvmapSpecularSize;
float4 sc_EnvmapSpecularDims;
float4 sc_EnvmapSpecularView;
float3 sc_EnvmapRotation;
float sc_EnvmapExposure;
float3 sc_Sh[9];
float sc_ShIntensity;
float4 sc_Time;
float4 sc_UniformConstants;
float4 sc_GeometryInfo;
float4x4 sc_ModelViewProjectionMatrixArray[2];
float4x4 sc_ModelViewProjectionMatrixInverseArray[2];
float4x4 sc_ViewProjectionMatrixArray[2];
float4x4 sc_ViewProjectionMatrixInverseArray[2];
float4x4 sc_ModelViewMatrixArray[2];
float4x4 sc_ModelViewMatrixInverseArray[2];
float3x3 sc_ViewNormalMatrixArray[2];
float3x3 sc_ViewNormalMatrixInverseArray[2];
float4x4 sc_ProjectionMatrixArray[2];
float4x4 sc_ProjectionMatrixInverseArray[2];
float4x4 sc_ViewMatrixArray[2];
float4x4 sc_ViewMatrixInverseArray[2];
float4x4 sc_PrevFrameViewProjectionMatrixArray[2];
float4x4 sc_ModelMatrix;
float4x4 sc_ModelMatrixInverse;
float3x3 sc_NormalMatrix;
float3x3 sc_NormalMatrixInverse;
float4x4 sc_PrevFrameModelMatrix;
float4x4 sc_PrevFrameModelMatrixInverse;
float3 sc_LocalAabbMin;
float3 sc_LocalAabbMax;
float3 sc_WorldAabbMin;
float3 sc_WorldAabbMax;
float4 sc_WindowToViewportTransform;
float4 sc_CurrentRenderTargetDims;
sc_Camera_t sc_Camera;
float sc_ShadowDensity;
float4 sc_ShadowColor;
float4x4 sc_ProjectorMatrix;
float shaderComplexityValue;
float4 weights0;
float4 weights1;
float4 weights2;
float4 sc_StereoClipPlanes[2];
int sc_FallbackInstanceID;
float2 sc_TAAJitterOffset;
float strandWidth;
float strandTaper;
float4 sc_StrandDataMapTextureSize;
float clumpInstanceCount;
float clumpRadius;
float clumpTipScale;
float hairstyleInstanceCount;
float hairstyleNoise;
float4 sc_ScreenTextureSize;
float4 sc_ScreenTextureDims;
float4 sc_ScreenTextureView;
int isProxyMode;
int instance_id;
int lray_triangles_last;
int noEarlyZ;
int has_animated_pn;
int emitter_stride;
int proxy_offset_position;
int proxy_offset_normal;
int proxy_offset_tangent;
int proxy_offset_color;
int proxy_offset_texture0;
int proxy_offset_texture1;
int proxy_offset_texture2;
int proxy_offset_texture3;
int proxy_format_position;
int proxy_format_normal;
int proxy_format_tangent;
int proxy_format_color;
int proxy_format_texture0;
int proxy_format_texture1;
int proxy_format_texture2;
int proxy_format_texture3;
float4 z_rayDirectionsSize;
float4 z_rayDirectionsDims;
float4 z_rayDirectionsView;
float correctedIntensity;
float4 intensityTextureSize;
float4 intensityTextureDims;
float4 intensityTextureView;
float3x3 intensityTextureTransform;
float4 intensityTextureUvMinMax;
float4 intensityTextureBorderColor;
float reflBlurWidth;
float reflBlurMinRough;
float reflBlurMaxRough;
int overrideTimeEnabled;
float overrideTimeElapsed[32];
float overrideTimeDelta;
int PreviewEnabled;
int PreviewNodeID;
float alphaTestThreshold;
int alpha_channel;
int red_channel;
int green_channel;
int blue_channel;
int envmap_preview;
float4 baseTexSize;
float4 baseTexDims;
float4 baseTexView;
float3x3 baseTexTransform;
float4 baseTexUvMinMax;
float4 baseTexBorderColor;
float Port_Input1_N010;
float2 Port_Input1_N057;
float Port_Value2_N013;
float Port_Input1_N009;
float Port_Input1_N035;
float Port_Value1_N036;
float Port_Input1_N046;
float Port_Input1_N051;
float Port_Input1_N034;
float Port_Value1_N043;
float Port_Input1_N052;
float Port_Input1_N053;
float4 Port_Default_N055;
float4 Port_Default_N050;
float depthRef;
};
struct layoutVertices_obj
{
float _Vertices[1];
};
struct layoutVerticesPN_obj
{
float _VerticesPN[1];
};
struct layoutIndices_obj
{
uint _Triangles[1];
};
struct ssPreviewInfo
{
float4 Color;
bool Saved;
};
struct sc_Bone_t
{
float4 boneMatrix[3];
float4 normalMatrix[3];
};
struct sc_Bones_obj
{
sc_Bone_t sc_Bones[1];
};
struct sc_Set0
{
const device layoutIndices_obj* layoutIndices [[id(0)]];
const device layoutVertices_obj* layoutVertices [[id(1)]];
const device layoutVerticesPN_obj* layoutVerticesPN [[id(2)]];
constant sc_Bones_obj* sc_BonesUBO [[id(3)]];
texture2d<float> baseTex [[id(4)]];
texture2d<float> intensityTexture [[id(5)]];
texture2d<float> sc_ScreenTexture [[id(17)]];
texture2d<uint> z_hitIdAndBarycentric [[id(20)]];
texture2d<float> z_rayDirections [[id(21)]];
sampler baseTexSmpSC [[id(22)]];
sampler intensityTextureSmpSC [[id(23)]];
sampler sc_ScreenTextureSmpSC [[id(28)]];
sampler z_hitIdAndBarycentricSmp [[id(31)]];
sampler z_rayDirectionsSmpSC [[id(32)]];
constant userUniformsObj* UserUniforms [[id(33)]];
};
struct main_frag_out
{
float4 FragColor0 [[color(0)]];
float4 FragColor1 [[color(1)]];
float4 FragColor2 [[color(2)]];
float4 FragColor3 [[color(3)]];
};
struct main_frag_in
{
float3 varPos [[user(locn0)]];
float3 varNormal [[user(locn1)]];
float4 varTangent [[user(locn2)]];
float4 varPackedTex [[user(locn3)]];
float4 varScreenPos [[user(locn4)]];
float2 varScreenTexturePos [[user(locn5)]];
float varViewSpaceDepth [[user(locn6)]];
float2 varShadowTex [[user(locn7)]];
int varStereoViewID [[user(locn8)]];
float varClipDistance [[user(locn9)]];
float4 varColor [[user(locn10)]];
float4 PreviewVertexColor [[user(locn11)]];
float PreviewVertexSaved [[user(locn12)]];
};
// Implementation of the GLSL mod() function,which is slightly different than Metal fmod()
template<typename Tx,typename Ty>
Tx mod(Tx x,Ty y)
{
return x-y*floor(x/y);
}
RayHitPayload GetHitData(thread const int2& screenPos,constant userUniformsObj& UserUniforms,thread texture2d<float> z_rayDirections,thread sampler z_rayDirectionsSmpSC,thread texture2d<uint> z_hitIdAndBarycentric,thread sampler z_hitIdAndBarycentricSmp,const device layoutVertices_obj& layoutVertices,const device layoutVerticesPN_obj& layoutVerticesPN,const device layoutIndices_obj& layoutIndices)
{
int2 param=screenPos;
uint4 l9_0=z_hitIdAndBarycentric.read(uint2(param),0);
uint4 id_and_barycentric=l9_0;
RayHitPayload rhp;
rhp.id=id_and_barycentric.xy;
if (rhp.id.x!=uint(UserUniforms.instance_id))
{
return rhp;
}
float2 brc_vw=float2(as_type<half2>(id_and_barycentric.z|(id_and_barycentric.w<<uint(16))));
float3 brc=float3((1.0-brc_vw.x)-brc_vw.y,brc_vw);
float2 param_1=z_rayDirections.read(uint2(screenPos),0).xy;
float3 l9_1=float3(param_1.x,param_1.y,(1.0-abs(param_1.x))-abs(param_1.y));
float l9_2=fast::clamp(-l9_1.z,0.0,1.0);
float l9_3;
if (l9_1.x>=0.0)
{
l9_3=-l9_2;
}
else
{
l9_3=l9_2;
}
float l9_4=l9_3;
float l9_5;
if (l9_1.y>=0.0)
{
l9_5=-l9_2;
}
else
{
l9_5=l9_2;
}
float2 l9_6=l9_1.xy+float2(l9_4,l9_5);
l9_1=float3(l9_6.x,l9_6.y,l9_1.z);
float3 l9_7=normalize(l9_1);
float3 rayDir=l9_7;
rhp.viewDirWS=-rayDir;
uint param_2=rhp.id.y;
uint l9_8=min(param_2,uint(UserUniforms.lray_triangles_last));
uint l9_9=l9_8*6u;
uint l9_10=l9_9&4294967292u;
uint4 l9_11=(uint4(uint2(layoutIndices._Triangles[l9_10/4u]),uint2(layoutIndices._Triangles[(l9_10/4u)+1u]))&uint4(65535u,4294967295u,65535u,4294967295u))>>uint4(0u,16u,0u,16u);
int3 l9_12;
if (l9_9==l9_10)
{
l9_12=int3(l9_11.xyz);
}
else
{
l9_12=int3(l9_11.yzw);
}
int3 l9_13=l9_12;
int3 i=l9_13;
if (UserUniforms.has_animated_pn!=0)
{
float3 param_3=brc;
int3 param_4=i;
int param_5=0;
int3 l9_14=(param_4*int3(6))+int3(param_5);
int l9_15=l9_14.x;
float3 l9_16=float3(layoutVerticesPN._VerticesPN[l9_15],layoutVerticesPN._VerticesPN[l9_15+1],layoutVerticesPN._VerticesPN[l9_15+2]);
int l9_17=l9_14.y;
float3 l9_18=float3(layoutVerticesPN._VerticesPN[l9_17],layoutVerticesPN._VerticesPN[l9_17+1],layoutVerticesPN._VerticesPN[l9_17+2]);
int l9_19=l9_14.z;
float3 l9_20=float3(layoutVerticesPN._VerticesPN[l9_19],layoutVerticesPN._VerticesPN[l9_19+1],layoutVerticesPN._VerticesPN[l9_19+2]);
float3 l9_21=((l9_16*param_3.x)+(l9_18*param_3.y))+(l9_20*param_3.z);
rhp.positionWS=l9_21;
}
else
{
float3 param_6=brc;
int3 param_7=i;
int3 l9_22=int3((param_7.x*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_position,(param_7.y*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_position,(param_7.z*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_position);
float3 l9_23=float3(0.0);
if (UserUniforms.proxy_format_position==5)
{
int l9_24=l9_22.x;
float3 l9_25=float3(layoutVertices._Vertices[l9_24],layoutVertices._Vertices[l9_24+1],layoutVertices._Vertices[l9_24+2]);
int l9_26=l9_22.y;
float3 l9_27=float3(layoutVertices._Vertices[l9_26],layoutVertices._Vertices[l9_26+1],layoutVertices._Vertices[l9_26+2]);
int l9_28=l9_22.z;
float3 l9_29=float3(layoutVertices._Vertices[l9_28],layoutVertices._Vertices[l9_28+1],layoutVertices._Vertices[l9_28+2]);
l9_23=((l9_25*param_6.x)+(l9_27*param_6.y))+(l9_29*param_6.z);
}
else
{
if (UserUniforms.proxy_format_position==6)
{
int l9_30=l9_22.x;
float3 l9_31=float3(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_30]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_30+1]))).x);
int l9_32=l9_22.y;
float3 l9_33=float3(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_32]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_32+1]))).x);
int l9_34=l9_22.z;
float3 l9_35=float3(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_34]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_34+1]))).x);
l9_23=((l9_31*param_6.x)+(l9_33*param_6.y))+(l9_35*param_6.z);
}
else
{
l9_23=float3(1.0,0.0,0.0);
}
}
float3 l9_36=l9_23;
float3 positionOS=l9_36;
rhp.positionWS=(UserUniforms.sc_ModelMatrix*float4(positionOS,1.0)).xyz;
}
if (UserUniforms.proxy_offset_normal>0)
{
if (UserUniforms.has_animated_pn!=0)
{
float3 param_8=brc;
int3 param_9=i;
int param_10=3;
int3 l9_37=(param_9*int3(6))+int3(param_10);
int l9_38=l9_37.x;
float3 l9_39=float3(layoutVerticesPN._VerticesPN[l9_38],layoutVerticesPN._VerticesPN[l9_38+1],layoutVerticesPN._VerticesPN[l9_38+2]);
int l9_40=l9_37.y;
float3 l9_41=float3(layoutVerticesPN._VerticesPN[l9_40],layoutVerticesPN._VerticesPN[l9_40+1],layoutVerticesPN._VerticesPN[l9_40+2]);
int l9_42=l9_37.z;
float3 l9_43=float3(layoutVerticesPN._VerticesPN[l9_42],layoutVerticesPN._VerticesPN[l9_42+1],layoutVerticesPN._VerticesPN[l9_42+2]);
float3 l9_44=((l9_39*param_8.x)+(l9_41*param_8.y))+(l9_43*param_8.z);
rhp.normalWS=l9_44;
}
else
{
float3 param_11=brc;
int3 param_12=i;
int3 l9_45=int3((param_12.x*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_normal,(param_12.y*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_normal,(param_12.z*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_normal);
float3 l9_46=float3(0.0);
if (UserUniforms.proxy_format_normal==5)
{
int l9_47=l9_45.x;
float3 l9_48=float3(layoutVertices._Vertices[l9_47],layoutVertices._Vertices[l9_47+1],layoutVertices._Vertices[l9_47+2]);
int l9_49=l9_45.y;
float3 l9_50=float3(layoutVertices._Vertices[l9_49],layoutVertices._Vertices[l9_49+1],layoutVertices._Vertices[l9_49+2]);
int l9_51=l9_45.z;
float3 l9_52=float3(layoutVertices._Vertices[l9_51],layoutVertices._Vertices[l9_51+1],layoutVertices._Vertices[l9_51+2]);
l9_46=((l9_48*param_11.x)+(l9_50*param_11.y))+(l9_52*param_11.z);
}
else
{
if (UserUniforms.proxy_format_normal==6)
{
int l9_53=l9_45.x;
float3 l9_54=float3(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_53]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_53+1]))).x);
int l9_55=l9_45.y;
float3 l9_56=float3(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_55]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_55+1]))).x);
int l9_57=l9_45.z;
float3 l9_58=float3(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_57]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_57+1]))).x);
l9_46=((l9_54*param_11.x)+(l9_56*param_11.y))+(l9_58*param_11.z);
}
else
{
l9_46=float3(1.0,0.0,0.0);
}
}
float3 l9_59=l9_46;
float3 normalOS=l9_59;
rhp.normalWS=normalize(UserUniforms.sc_NormalMatrix*normalOS);
}
}
else
{
rhp.normalWS=float3(1.0,0.0,0.0);
}
bool l9_60=!(UserUniforms.has_animated_pn!=0);
bool l9_61;
if (l9_60)
{
l9_61=UserUniforms.proxy_offset_tangent>0;
}
else
{
l9_61=l9_60;
}
if (l9_61)
{
float3 param_13=brc;
int3 param_14=i;
int3 l9_62=int3((param_14.x*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_tangent,(param_14.y*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_tangent,(param_14.z*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_tangent);
float4 l9_63=float4(0.0);
if (UserUniforms.proxy_format_tangent==5)
{
int l9_64=l9_62.x;
float4 l9_65=float4(layoutVertices._Vertices[l9_64],layoutVertices._Vertices[l9_64+1],layoutVertices._Vertices[l9_64+2],layoutVertices._Vertices[l9_64+3]);
int l9_66=l9_62.y;
float4 l9_67=float4(layoutVertices._Vertices[l9_66],layoutVertices._Vertices[l9_66+1],layoutVertices._Vertices[l9_66+2],layoutVertices._Vertices[l9_66+3]);
int l9_68=l9_62.z;
float4 l9_69=float4(layoutVertices._Vertices[l9_68],layoutVertices._Vertices[l9_68+1],layoutVertices._Vertices[l9_68+2],layoutVertices._Vertices[l9_68+3]);
l9_63=((l9_65*param_13.x)+(l9_67*param_13.y))+(l9_69*param_13.z);
}
else
{
if (UserUniforms.proxy_format_tangent==6)
{
int l9_70=l9_62.x;
float4 l9_71=float4(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_70]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_70+1]))));
int l9_72=l9_62.y;
float4 l9_73=float4(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_72]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_72+1]))));
int l9_74=l9_62.z;
float4 l9_75=float4(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_74]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_74+1]))));
l9_63=((l9_71*param_13.x)+(l9_73*param_13.y))+(l9_75*param_13.z);
}
else
{
if (UserUniforms.proxy_format_tangent==2)
{
int l9_76=l9_62.x;
uint l9_77=as_type<uint>(layoutVertices._Vertices[l9_76]);
uint l9_78=l9_77&255u;
uint l9_79=(l9_77>>uint(8))&255u;
uint l9_80=(l9_77>>uint(16))&255u;
uint l9_81=(l9_77>>uint(24))&255u;
float4 l9_82=float4(float(l9_78),float(l9_79),float(l9_80),float(l9_81))/float4(255.0);
int l9_83=l9_62.y;
uint l9_84=as_type<uint>(layoutVertices._Vertices[l9_83]);
uint l9_85=l9_84&255u;
uint l9_86=(l9_84>>uint(8))&255u;
uint l9_87=(l9_84>>uint(16))&255u;
uint l9_88=(l9_84>>uint(24))&255u;
float4 l9_89=float4(float(l9_85),float(l9_86),float(l9_87),float(l9_88))/float4(255.0);
int l9_90=l9_62.z;
uint l9_91=as_type<uint>(layoutVertices._Vertices[l9_90]);
uint l9_92=l9_91&255u;
uint l9_93=(l9_91>>uint(8))&255u;
uint l9_94=(l9_91>>uint(16))&255u;
uint l9_95=(l9_91>>uint(24))&255u;
float4 l9_96=float4(float(l9_92),float(l9_93),float(l9_94),float(l9_95))/float4(255.0);
l9_63=((l9_82*param_13.x)+(l9_89*param_13.y))+(l9_96*param_13.z);
}
else
{
l9_63=float4(1.0,0.0,0.0,0.0);
}
}
}
float4 l9_97=l9_63;
float4 tangentOS=l9_97;
float3 tangentWS=normalize(UserUniforms.sc_NormalMatrix*tangentOS.xyz);
rhp.tangentWS=float4(tangentWS,tangentOS.w);
}
else
{
rhp.tangentWS=float4(1.0,0.0,0.0,1.0);
}
if (UserUniforms.proxy_format_color>0)
{
float3 param_15=brc;
int3 param_16=i;
int3 l9_98=int3((param_16.x*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_color,(param_16.y*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_color,(param_16.z*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_color);
float4 l9_99=float4(0.0);
if (UserUniforms.proxy_format_color==5)
{
int l9_100=l9_98.x;
float4 l9_101=float4(layoutVertices._Vertices[l9_100],layoutVertices._Vertices[l9_100+1],layoutVertices._Vertices[l9_100+2],layoutVertices._Vertices[l9_100+3]);
int l9_102=l9_98.y;
float4 l9_103=float4(layoutVertices._Vertices[l9_102],layoutVertices._Vertices[l9_102+1],layoutVertices._Vertices[l9_102+2],layoutVertices._Vertices[l9_102+3]);
int l9_104=l9_98.z;
float4 l9_105=float4(layoutVertices._Vertices[l9_104],layoutVertices._Vertices[l9_104+1],layoutVertices._Vertices[l9_104+2],layoutVertices._Vertices[l9_104+3]);
l9_99=((l9_101*param_15.x)+(l9_103*param_15.y))+(l9_105*param_15.z);
}
else
{
if (UserUniforms.proxy_format_color==6)
{
int l9_106=l9_98.x;
float4 l9_107=float4(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_106]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_106+1]))));
int l9_108=l9_98.y;
float4 l9_109=float4(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_108]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_108+1]))));
int l9_110=l9_98.z;
float4 l9_111=float4(float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_110]))),float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_110+1]))));
l9_99=((l9_107*param_15.x)+(l9_109*param_15.y))+(l9_111*param_15.z);
}
else
{
if (UserUniforms.proxy_format_color==2)
{
int l9_112=l9_98.x;
uint l9_113=as_type<uint>(layoutVertices._Vertices[l9_112]);
uint l9_114=l9_113&255u;
uint l9_115=(l9_113>>uint(8))&255u;
uint l9_116=(l9_113>>uint(16))&255u;
uint l9_117=(l9_113>>uint(24))&255u;
float4 l9_118=float4(float(l9_114),float(l9_115),float(l9_116),float(l9_117))/float4(255.0);
int l9_119=l9_98.y;
uint l9_120=as_type<uint>(layoutVertices._Vertices[l9_119]);
uint l9_121=l9_120&255u;
uint l9_122=(l9_120>>uint(8))&255u;
uint l9_123=(l9_120>>uint(16))&255u;
uint l9_124=(l9_120>>uint(24))&255u;
float4 l9_125=float4(float(l9_121),float(l9_122),float(l9_123),float(l9_124))/float4(255.0);
int l9_126=l9_98.z;
uint l9_127=as_type<uint>(layoutVertices._Vertices[l9_126]);
uint l9_128=l9_127&255u;
uint l9_129=(l9_127>>uint(8))&255u;
uint l9_130=(l9_127>>uint(16))&255u;
uint l9_131=(l9_127>>uint(24))&255u;
float4 l9_132=float4(float(l9_128),float(l9_129),float(l9_130),float(l9_131))/float4(255.0);
l9_99=((l9_118*param_15.x)+(l9_125*param_15.y))+(l9_132*param_15.z);
}
else
{
l9_99=float4(1.0,0.0,0.0,0.0);
}
}
}
float4 l9_133=l9_99;
rhp.color=l9_133;
}
float2 dummy_red_black=float2(dot(brc,float3(int3(1)-(i%int3(2)))),0.0);
if (UserUniforms.proxy_format_texture0>0)
{
float3 param_17=brc;
int3 param_18=i;
int3 l9_134=int3((param_18.x*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture0,(param_18.y*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture0,(param_18.z*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture0);
float2 l9_135=float2(0.0);
if (UserUniforms.proxy_format_texture0==5)
{
int l9_136=l9_134.x;
float2 l9_137=float2(layoutVertices._Vertices[l9_136],layoutVertices._Vertices[l9_136+1]);
int l9_138=l9_134.y;
float2 l9_139=float2(layoutVertices._Vertices[l9_138],layoutVertices._Vertices[l9_138+1]);
int l9_140=l9_134.z;
float2 l9_141=float2(layoutVertices._Vertices[l9_140],layoutVertices._Vertices[l9_140+1]);
l9_135=((l9_137*param_17.x)+(l9_139*param_17.y))+(l9_141*param_17.z);
}
else
{
if (UserUniforms.proxy_format_texture0==6)
{
int l9_142=l9_134.x;
float2 l9_143=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_142])));
int l9_144=l9_134.y;
float2 l9_145=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_144])));
int l9_146=l9_134.z;
float2 l9_147=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_146])));
l9_135=((l9_143*param_17.x)+(l9_145*param_17.y))+(l9_147*param_17.z);
}
else
{
l9_135=float2(1.0,0.0);
}
}
float2 l9_148=l9_135;
rhp.uv0=l9_148;
}
else
{
rhp.uv0=dummy_red_black;
}
if (UserUniforms.proxy_format_texture1>0)
{
float3 param_19=brc;
int3 param_20=i;
int3 l9_149=int3((param_20.x*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture1,(param_20.y*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture1,(param_20.z*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture1);
float2 l9_150=float2(0.0);
if (UserUniforms.proxy_format_texture1==5)
{
int l9_151=l9_149.x;
float2 l9_152=float2(layoutVertices._Vertices[l9_151],layoutVertices._Vertices[l9_151+1]);
int l9_153=l9_149.y;
float2 l9_154=float2(layoutVertices._Vertices[l9_153],layoutVertices._Vertices[l9_153+1]);
int l9_155=l9_149.z;
float2 l9_156=float2(layoutVertices._Vertices[l9_155],layoutVertices._Vertices[l9_155+1]);
l9_150=((l9_152*param_19.x)+(l9_154*param_19.y))+(l9_156*param_19.z);
}
else
{
if (UserUniforms.proxy_format_texture1==6)
{
int l9_157=l9_149.x;
float2 l9_158=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_157])));
int l9_159=l9_149.y;
float2 l9_160=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_159])));
int l9_161=l9_149.z;
float2 l9_162=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_161])));
l9_150=((l9_158*param_19.x)+(l9_160*param_19.y))+(l9_162*param_19.z);
}
else
{
l9_150=float2(1.0,0.0);
}
}
float2 l9_163=l9_150;
rhp.uv1=l9_163;
}
else
{
rhp.uv1=dummy_red_black;
}
if (UserUniforms.proxy_format_texture2>0)
{
float3 param_21=brc;
int3 param_22=i;
int3 l9_164=int3((param_22.x*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture2,(param_22.y*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture2,(param_22.z*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture2);
float2 l9_165=float2(0.0);
if (UserUniforms.proxy_format_texture2==5)
{
int l9_166=l9_164.x;
float2 l9_167=float2(layoutVertices._Vertices[l9_166],layoutVertices._Vertices[l9_166+1]);
int l9_168=l9_164.y;
float2 l9_169=float2(layoutVertices._Vertices[l9_168],layoutVertices._Vertices[l9_168+1]);
int l9_170=l9_164.z;
float2 l9_171=float2(layoutVertices._Vertices[l9_170],layoutVertices._Vertices[l9_170+1]);
l9_165=((l9_167*param_21.x)+(l9_169*param_21.y))+(l9_171*param_21.z);
}
else
{
if (UserUniforms.proxy_format_texture2==6)
{
int l9_172=l9_164.x;
float2 l9_173=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_172])));
int l9_174=l9_164.y;
float2 l9_175=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_174])));
int l9_176=l9_164.z;
float2 l9_177=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_176])));
l9_165=((l9_173*param_21.x)+(l9_175*param_21.y))+(l9_177*param_21.z);
}
else
{
l9_165=float2(1.0,0.0);
}
}
float2 l9_178=l9_165;
rhp.uv2=l9_178;
}
else
{
rhp.uv2=dummy_red_black;
}
if (UserUniforms.proxy_format_texture3>0)
{
float3 param_23=brc;
int3 param_24=i;
int3 l9_179=int3((param_24.x*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture3,(param_24.y*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture3,(param_24.z*UserUniforms.emitter_stride)+UserUniforms.proxy_offset_texture3);
float2 l9_180=float2(0.0);
if (UserUniforms.proxy_format_texture3==5)
{
int l9_181=l9_179.x;
float2 l9_182=float2(layoutVertices._Vertices[l9_181],layoutVertices._Vertices[l9_181+1]);
int l9_183=l9_179.y;
float2 l9_184=float2(layoutVertices._Vertices[l9_183],layoutVertices._Vertices[l9_183+1]);
int l9_185=l9_179.z;
float2 l9_186=float2(layoutVertices._Vertices[l9_185],layoutVertices._Vertices[l9_185+1]);
l9_180=((l9_182*param_23.x)+(l9_184*param_23.y))+(l9_186*param_23.z);
}
else
{
if (UserUniforms.proxy_format_texture3==6)
{
int l9_187=l9_179.x;
float2 l9_188=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_187])));
int l9_189=l9_179.y;
float2 l9_190=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_189])));
int l9_191=l9_179.z;
float2 l9_192=float2(as_type<half2>(as_type<uint>(layoutVertices._Vertices[l9_191])));
l9_180=((l9_188*param_23.x)+(l9_190*param_23.y))+(l9_192*param_23.z);
}
else
{
l9_180=float2(1.0,0.0);
}
}
float2 l9_193=l9_180;
rhp.uv3=l9_193;
}
else
{
rhp.uv3=dummy_red_black;
}
return rhp;
}
float transformSingleColor(thread const float& original,thread const float& intMap,thread const float& target)
{
if (((int(BLEND_MODE_REALISTIC_tmp)!=0)||(int(BLEND_MODE_FORGRAY_tmp)!=0))||(int(BLEND_MODE_NOTBRIGHT_tmp)!=0))
{
return original/pow(1.0-target,intMap);
}
else
{
if ((int(BLEND_MODE_DIVISION_tmp)!=0))
{
return original/(1.0-target);
}
else
{
if ((int(BLEND_MODE_BRIGHT_tmp)!=0))
{
return original/pow(1.0-target,2.0-(2.0*original));
}
}
}
return 0.0;
}
float3 transformColor(thread const float& yValue,thread const float3& original,thread const float3& target,thread const float& weight,thread const float& intMap)
{
if ((int(BLEND_MODE_INTENSE_tmp)!=0))
{
float3 param=original;
float3 l9_0=param;
float4 l9_1;
if (l9_0.y<l9_0.z)
{
l9_1=float4(l9_0.zy,-1.0,0.66666669);
}
else
{
l9_1=float4(l9_0.yz,0.0,-0.33333334);
}
float4 l9_2=l9_1;
float4 l9_3;
if (l9_0.x<l9_2.x)
{
l9_3=float4(l9_2.xyw,l9_0.x);
}
else
{
l9_3=float4(l9_0.x,l9_2.yzx);
}
float4 l9_4=l9_3;
float l9_5=l9_4.x-fast::min(l9_4.w,l9_4.y);
float l9_6=abs(((l9_4.w-l9_4.y)/((6.0*l9_5)+1e-07))+l9_4.z);
float l9_7=l9_4.x;
float3 l9_8=float3(l9_6,l9_5,l9_7);
float3 l9_9=l9_8;
float l9_10=l9_9.z-(l9_9.y*0.5);
float l9_11=l9_9.y/((1.0-abs((2.0*l9_10)-1.0))+1e-07);
float3 l9_12=float3(l9_9.x,l9_11,l9_10);
float3 hslOrig=l9_12;
float3 res=float3(0.0);
res.x=target.x;
res.y=target.y;
res.z=hslOrig.z;
float3 param_1=res;
float l9_13=param_1.x;
float l9_14=abs((6.0*l9_13)-3.0)-1.0;
float l9_15=2.0-abs((6.0*l9_13)-2.0);
float l9_16=2.0-abs((6.0*l9_13)-4.0);
float3 l9_17=fast::clamp(float3(l9_14,l9_15,l9_16),float3(0.0),float3(1.0));
float3 l9_18=l9_17;
float l9_19=(1.0-abs((2.0*param_1.z)-1.0))*param_1.y;
l9_18=((l9_18-float3(0.5))*l9_19)+float3(param_1.z);
float3 l9_20=l9_18;
res=l9_20;
float3 resColor=mix(original,res,float3(weight));
return resColor;
}
else
{
float3 tmpColor=float3(0.0);
float param_2=yValue;
float param_3=intMap;
float param_4=target.x;
tmpColor.x=transformSingleColor(param_2,param_3,param_4);
float param_5=yValue;
float param_6=intMap;
float param_7=target.y;
tmpColor.y=transformSingleColor(param_5,param_6,param_7);
float param_8=yValue;
float param_9=intMap;
float param_10=target.z;
tmpColor.z=transformSingleColor(param_8,param_9,param_10);
tmpColor=fast::clamp(tmpColor,float3(0.0),float3(1.0));
float3 resColor_1=mix(original,tmpColor,float3(weight));
return resColor_1;
}
}
float3 definedBlend(thread const float3& a,thread const float3& b,thread int& varStereoViewID,constant userUniformsObj& UserUniforms,thread texture2d<float> intensityTexture,thread sampler intensityTextureSmpSC)
{
if ((int(BLEND_MODE_LIGHTEN_tmp)!=0))
{
return fast::max(a,b);
}
else
{
if ((int(BLEND_MODE_DARKEN_tmp)!=0))
{
return fast::min(a,b);
}
else
{
if ((int(BLEND_MODE_DIVIDE_tmp)!=0))
{
return b/a;
}
else
{
if ((int(BLEND_MODE_AVERAGE_tmp)!=0))
{
return (a+b)*0.5;
}
else
{
if ((int(BLEND_MODE_SUBTRACT_tmp)!=0))
{
return fast::max((a+b)-float3(1.0),float3(0.0));
}
else
{
if ((int(BLEND_MODE_DIFFERENCE_tmp)!=0))
{
return abs(a-b);
}
else
{
if ((int(BLEND_MODE_NEGATION_tmp)!=0))
{
return float3(1.0)-abs((float3(1.0)-a)-b);
}
else
{
if ((int(BLEND_MODE_EXCLUSION_tmp)!=0))
{
return (a+b)-((a*2.0)*b);
}
else
{
if ((int(BLEND_MODE_OVERLAY_tmp)!=0))
{
float l9_0;
if (a.x<0.5)
{
l9_0=(2.0*a.x)*b.x;
}
else
{
l9_0=1.0-((2.0*(1.0-a.x))*(1.0-b.x));
}
float l9_1=l9_0;
float l9_2;
if (a.y<0.5)
{
l9_2=(2.0*a.y)*b.y;
}
else
{
l9_2=1.0-((2.0*(1.0-a.y))*(1.0-b.y));
}
float l9_3=l9_2;
float l9_4;
if (a.z<0.5)
{
l9_4=(2.0*a.z)*b.z;
}
else
{
l9_4=1.0-((2.0*(1.0-a.z))*(1.0-b.z));
}
return float3(l9_1,l9_3,l9_4);
}
else
{
if ((int(BLEND_MODE_SOFT_LIGHT_tmp)!=0))
{
return (((float3(1.0)-(b*2.0))*a)*a)+((a*2.0)*b);
}
else
{
if ((int(BLEND_MODE_HARD_LIGHT_tmp)!=0))
{
float l9_5;
if (b.x<0.5)
{
l9_5=(2.0*b.x)*a.x;
}
else
{
l9_5=1.0-((2.0*(1.0-b.x))*(1.0-a.x));
}
float l9_6=l9_5;
float l9_7;
if (b.y<0.5)
{
l9_7=(2.0*b.y)*a.y;
}
else
{
l9_7=1.0-((2.0*(1.0-b.y))*(1.0-a.y));
}
float l9_8=l9_7;
float l9_9;
if (b.z<0.5)
{
l9_9=(2.0*b.z)*a.z;
}
else
{
l9_9=1.0-((2.0*(1.0-b.z))*(1.0-a.z));
}
return float3(l9_6,l9_8,l9_9);
}
else
{
if ((int(BLEND_MODE_COLOR_DODGE_tmp)!=0))
{
float l9_10;
if (b.x==1.0)
{
l9_10=b.x;
}
else
{
l9_10=fast::min(a.x/(1.0-b.x),1.0);
}
float l9_11=l9_10;
float l9_12;
if (b.y==1.0)
{
l9_12=b.y;
}
else
{
l9_12=fast::min(a.y/(1.0-b.y),1.0);
}
float l9_13=l9_12;
float l9_14;
if (b.z==1.0)
{
l9_14=b.z;
}
else
{
l9_14=fast::min(a.z/(1.0-b.z),1.0);
}
return float3(l9_11,l9_13,l9_14);
}
else
{
if ((int(BLEND_MODE_COLOR_BURN_tmp)!=0))
{
float l9_15;
if (b.x==0.0)
{
l9_15=b.x;
}
else
{
l9_15=fast::max(1.0-((1.0-a.x)/b.x),0.0);
}
float l9_16=l9_15;
float l9_17;
if (b.y==0.0)
{
l9_17=b.y;
}
else
{
l9_17=fast::max(1.0-((1.0-a.y)/b.y),0.0);
}
float l9_18=l9_17;
float l9_19;
if (b.z==0.0)
{
l9_19=b.z;
}
else
{
l9_19=fast::max(1.0-((1.0-a.z)/b.z),0.0);
}
return float3(l9_16,l9_18,l9_19);
}
else
{
if ((int(BLEND_MODE_LINEAR_LIGHT_tmp)!=0))
{
float l9_20;
if (b.x<0.5)
{
l9_20=fast::max((a.x+(2.0*b.x))-1.0,0.0);
}
else
{
l9_20=fast::min(a.x+(2.0*(b.x-0.5)),1.0);
}
float l9_21=l9_20;
float l9_22;
if (b.y<0.5)
{
l9_22=fast::max((a.y+(2.0*b.y))-1.0,0.0);
}
else
{
l9_22=fast::min(a.y+(2.0*(b.y-0.5)),1.0);
}
float l9_23=l9_22;
float l9_24;
if (b.z<0.5)
{
l9_24=fast::max((a.z+(2.0*b.z))-1.0,0.0);
}
else
{
l9_24=fast::min(a.z+(2.0*(b.z-0.5)),1.0);
}
return float3(l9_21,l9_23,l9_24);
}
else
{
if ((int(BLEND_MODE_VIVID_LIGHT_tmp)!=0))
{
float l9_25;
if (b.x<0.5)
{
float l9_26;
if ((2.0*b.x)==0.0)
{
l9_26=2.0*b.x;
}
else
{
l9_26=fast::max(1.0-((1.0-a.x)/(2.0*b.x)),0.0);
}
l9_25=l9_26;
}
else
{
float l9_27;
if ((2.0*(b.x-0.5))==1.0)
{
l9_27=2.0*(b.x-0.5);
}
else
{
l9_27=fast::min(a.x/(1.0-(2.0*(b.x-0.5))),1.0);
}
l9_25=l9_27;
}
float l9_28=l9_25;
float l9_29;
if (b.y<0.5)
{
float l9_30;
if ((2.0*b.y)==0.0)
{
l9_30=2.0*b.y;
}
else
{
l9_30=fast::max(1.0-((1.0-a.y)/(2.0*b.y)),0.0);
}
l9_29=l9_30;
}
else
{
float l9_31;
if ((2.0*(b.y-0.5))==1.0)
{
l9_31=2.0*(b.y-0.5);
}
else
{
l9_31=fast::min(a.y/(1.0-(2.0*(b.y-0.5))),1.0);
}
l9_29=l9_31;
}
float l9_32=l9_29;
float l9_33;
if (b.z<0.5)
{
float l9_34;
if ((2.0*b.z)==0.0)
{
l9_34=2.0*b.z;
}
else
{
l9_34=fast::max(1.0-((1.0-a.z)/(2.0*b.z)),0.0);
}
l9_33=l9_34;
}
else
{
float l9_35;
if ((2.0*(b.z-0.5))==1.0)
{
l9_35=2.0*(b.z-0.5);
}
else
{
l9_35=fast::min(a.z/(1.0-(2.0*(b.z-0.5))),1.0);
}
l9_33=l9_35;
}
return float3(l9_28,l9_32,l9_33);
}
else
{
if ((int(BLEND_MODE_PIN_LIGHT_tmp)!=0))
{
float l9_36;
if (b.x<0.5)
{
l9_36=fast::min(a.x,2.0*b.x);
}
else
{
l9_36=fast::max(a.x,2.0*(b.x-0.5));
}
float l9_37=l9_36;
float l9_38;
if (b.y<0.5)
{
l9_38=fast::min(a.y,2.0*b.y);
}
else
{
l9_38=fast::max(a.y,2.0*(b.y-0.5));
}
float l9_39=l9_38;
float l9_40;
if (b.z<0.5)
{
l9_40=fast::min(a.z,2.0*b.z);
}
else
{
l9_40=fast::max(a.z,2.0*(b.z-0.5));
}
return float3(l9_37,l9_39,l9_40);
}
else
{
if ((int(BLEND_MODE_HARD_MIX_tmp)!=0))
{
float l9_41;
if (b.x<0.5)
{
float l9_42;
if ((2.0*b.x)==0.0)
{
l9_42=2.0*b.x;
}
else
{
l9_42=fast::max(1.0-((1.0-a.x)/(2.0*b.x)),0.0);
}
l9_41=l9_42;
}
else
{
float l9_43;
if ((2.0*(b.x-0.5))==1.0)
{
l9_43=2.0*(b.x-0.5);
}
else
{
l9_43=fast::min(a.x/(1.0-(2.0*(b.x-0.5))),1.0);
}
l9_41=l9_43;
}
float l9_44=l9_41;
float l9_45;
if (b.y<0.5)
{
float l9_46;
if ((2.0*b.y)==0.0)
{
l9_46=2.0*b.y;
}
else
{
l9_46=fast::max(1.0-((1.0-a.y)/(2.0*b.y)),0.0);
}
l9_45=l9_46;
}
else
{
float l9_47;
if ((2.0*(b.y-0.5))==1.0)
{
l9_47=2.0*(b.y-0.5);
}
else
{
l9_47=fast::min(a.y/(1.0-(2.0*(b.y-0.5))),1.0);
}
l9_45=l9_47;
}
float l9_48=l9_45;
float l9_49;
if (b.z<0.5)
{
float l9_50;
if ((2.0*b.z)==0.0)
{
l9_50=2.0*b.z;
}
else
{
l9_50=fast::max(1.0-((1.0-a.z)/(2.0*b.z)),0.0);
}
l9_49=l9_50;
}
else
{
float l9_51;
if ((2.0*(b.z-0.5))==1.0)
{
l9_51=2.0*(b.z-0.5);
}
else
{
l9_51=fast::min(a.z/(1.0-(2.0*(b.z-0.5))),1.0);
}
l9_49=l9_51;
}
return float3((l9_44<0.5) ? 0.0 : 1.0,(l9_48<0.5) ? 0.0 : 1.0,(l9_49<0.5) ? 0.0 : 1.0);
}
else
{
if ((int(BLEND_MODE_HARD_REFLECT_tmp)!=0))
{
float l9_52;
if (b.x==1.0)
{
l9_52=b.x;
}
else
{
l9_52=fast::min((a.x*a.x)/(1.0-b.x),1.0);
}
float l9_53=l9_52;
float l9_54;
if (b.y==1.0)
{
l9_54=b.y;
}
else
{
l9_54=fast::min((a.y*a.y)/(1.0-b.y),1.0);
}
float l9_55=l9_54;
float l9_56;
if (b.z==1.0)
{
l9_56=b.z;
}
else
{
l9_56=fast::min((a.z*a.z)/(1.0-b.z),1.0);
}
return float3(l9_53,l9_55,l9_56);
}
else
{
if ((int(BLEND_MODE_HARD_GLOW_tmp)!=0))
{
float l9_57;
if (a.x==1.0)
{
l9_57=a.x;
}
else
{
l9_57=fast::min((b.x*b.x)/(1.0-a.x),1.0);
}
float l9_58=l9_57;
float l9_59;
if (a.y==1.0)
{
l9_59=a.y;
}
else
{
l9_59=fast::min((b.y*b.y)/(1.0-a.y),1.0);
}
float l9_60=l9_59;
float l9_61;
if (a.z==1.0)
{
l9_61=a.z;
}
else
{
l9_61=fast::min((b.z*b.z)/(1.0-a.z),1.0);
}
return float3(l9_58,l9_60,l9_61);
}
else
{
if ((int(BLEND_MODE_HARD_PHOENIX_tmp)!=0))
{
return (fast::min(a,b)-fast::max(a,b))+float3(1.0);
}
else
{
if ((int(BLEND_MODE_HUE_tmp)!=0))
{
float3 param=a;
float3 param_1=b;
float3 l9_62=param;
float3 l9_63=l9_62;
float4 l9_64;
if (l9_63.y<l9_63.z)
{
l9_64=float4(l9_63.zy,-1.0,0.66666669);
}
else
{
l9_64=float4(l9_63.yz,0.0,-0.33333334);
}
float4 l9_65=l9_64;
float4 l9_66;
if (l9_63.x<l9_65.x)
{
l9_66=float4(l9_65.xyw,l9_63.x);
}
else
{
l9_66=float4(l9_63.x,l9_65.yzx);
}
float4 l9_67=l9_66;
float l9_68=l9_67.x-fast::min(l9_67.w,l9_67.y);
float l9_69=abs(((l9_67.w-l9_67.y)/((6.0*l9_68)+1e-07))+l9_67.z);
float l9_70=l9_67.x;
float3 l9_71=float3(l9_69,l9_68,l9_70);
float3 l9_72=l9_71;
float l9_73=l9_72.z-(l9_72.y*0.5);
float l9_74=l9_72.y/((1.0-abs((2.0*l9_73)-1.0))+1e-07);
float3 l9_75=float3(l9_72.x,l9_74,l9_73);
float3 l9_76=l9_75;
float3 l9_77=param_1;
float3 l9_78=l9_77;
float4 l9_79;
if (l9_78.y<l9_78.z)
{
l9_79=float4(l9_78.zy,-1.0,0.66666669);
}
else
{
l9_79=float4(l9_78.yz,0.0,-0.33333334);
}
float4 l9_80=l9_79;
float4 l9_81;
if (l9_78.x<l9_80.x)
{
l9_81=float4(l9_80.xyw,l9_78.x);
}
else
{
l9_81=float4(l9_78.x,l9_80.yzx);
}
float4 l9_82=l9_81;
float l9_83=l9_82.x-fast::min(l9_82.w,l9_82.y);
float l9_84=abs(((l9_82.w-l9_82.y)/((6.0*l9_83)+1e-07))+l9_82.z);
float l9_85=l9_82.x;
float3 l9_86=float3(l9_84,l9_83,l9_85);
float3 l9_87=l9_86;
float l9_88=l9_87.z-(l9_87.y*0.5);
float l9_89=l9_87.y/((1.0-abs((2.0*l9_88)-1.0))+1e-07);
float3 l9_90=float3(l9_87.x,l9_89,l9_88);
float3 l9_91=float3(l9_90.x,l9_76.y,l9_76.z);
float l9_92=l9_91.x;
float l9_93=abs((6.0*l9_92)-3.0)-1.0;
float l9_94=2.0-abs((6.0*l9_92)-2.0);
float l9_95=2.0-abs((6.0*l9_92)-4.0);
float3 l9_96=fast::clamp(float3(l9_93,l9_94,l9_95),float3(0.0),float3(1.0));
float3 l9_97=l9_96;
float l9_98=(1.0-abs((2.0*l9_91.z)-1.0))*l9_91.y;
l9_97=((l9_97-float3(0.5))*l9_98)+float3(l9_91.z);
float3 l9_99=l9_97;
float3 l9_100=l9_99;
return l9_100;
}
else
{
if ((int(BLEND_MODE_SATURATION_tmp)!=0))
{
float3 param_2=a;
float3 param_3=b;
float3 l9_101=param_2;
float3 l9_102=l9_101;
float4 l9_103;
if (l9_102.y<l9_102.z)
{
l9_103=float4(l9_102.zy,-1.0,0.66666669);
}
else
{
l9_103=float4(l9_102.yz,0.0,-0.33333334);
}
float4 l9_104=l9_103;
float4 l9_105;
if (l9_102.x<l9_104.x)
{
l9_105=float4(l9_104.xyw,l9_102.x);
}
else
{
l9_105=float4(l9_102.x,l9_104.yzx);
}
float4 l9_106=l9_105;
float l9_107=l9_106.x-fast::min(l9_106.w,l9_106.y);
float l9_108=abs(((l9_106.w-l9_106.y)/((6.0*l9_107)+1e-07))+l9_106.z);
float l9_109=l9_106.x;
float3 l9_110=float3(l9_108,l9_107,l9_109);
float3 l9_111=l9_110;
float l9_112=l9_111.z-(l9_111.y*0.5);
float l9_113=l9_111.y/((1.0-abs((2.0*l9_112)-1.0))+1e-07);
float3 l9_114=float3(l9_111.x,l9_113,l9_112);
float3 l9_115=l9_114;
float l9_116=l9_115.x;
float3 l9_117=param_3;
float3 l9_118=l9_117;
float4 l9_119;
if (l9_118.y<l9_118.z)
{
l9_119=float4(l9_118.zy,-1.0,0.66666669);
}
else
{
l9_119=float4(l9_118.yz,0.0,-0.33333334);
}
float4 l9_120=l9_119;
float4 l9_121;
if (l9_118.x<l9_120.x)
{
l9_121=float4(l9_120.xyw,l9_118.x);
}
else
{
l9_121=float4(l9_118.x,l9_120.yzx);
}
float4 l9_122=l9_121;
float l9_123=l9_122.x-fast::min(l9_122.w,l9_122.y);
float l9_124=abs(((l9_122.w-l9_122.y)/((6.0*l9_123)+1e-07))+l9_122.z);
float l9_125=l9_122.x;
float3 l9_126=float3(l9_124,l9_123,l9_125);
float3 l9_127=l9_126;
float l9_128=l9_127.z-(l9_127.y*0.5);
float l9_129=l9_127.y/((1.0-abs((2.0*l9_128)-1.0))+1e-07);
float3 l9_130=float3(l9_127.x,l9_129,l9_128);
float3 l9_131=float3(l9_116,l9_130.y,l9_115.z);
float l9_132=l9_131.x;
float l9_133=abs((6.0*l9_132)-3.0)-1.0;
float l9_134=2.0-abs((6.0*l9_132)-2.0);
float l9_135=2.0-abs((6.0*l9_132)-4.0);
float3 l9_136=fast::clamp(float3(l9_133,l9_134,l9_135),float3(0.0),float3(1.0));
float3 l9_137=l9_136;
float l9_138=(1.0-abs((2.0*l9_131.z)-1.0))*l9_131.y;
l9_137=((l9_137-float3(0.5))*l9_138)+float3(l9_131.z);
float3 l9_139=l9_137;
float3 l9_140=l9_139;
return l9_140;
}
else
{
if ((int(BLEND_MODE_COLOR_tmp)!=0))
{
float3 param_4=a;
float3 param_5=b;
float3 l9_141=param_5;
float3 l9_142=l9_141;
float4 l9_143;
if (l9_142.y<l9_142.z)
{
l9_143=float4(l9_142.zy,-1.0,0.66666669);
}
else
{
l9_143=float4(l9_142.yz,0.0,-0.33333334);
}
float4 l9_144=l9_143;
float4 l9_145;
if (l9_142.x<l9_144.x)
{
l9_145=float4(l9_144.xyw,l9_142.x);
}
else
{
l9_145=float4(l9_142.x,l9_144.yzx);
}
float4 l9_146=l9_145;
float l9_147=l9_146.x-fast::min(l9_146.w,l9_146.y);
float l9_148=abs(((l9_146.w-l9_146.y)/((6.0*l9_147)+1e-07))+l9_146.z);
float l9_149=l9_146.x;
float3 l9_150=float3(l9_148,l9_147,l9_149);
float3 l9_151=l9_150;
float l9_152=l9_151.z-(l9_151.y*0.5);
float l9_153=l9_151.y/((1.0-abs((2.0*l9_152)-1.0))+1e-07);
float3 l9_154=float3(l9_151.x,l9_153,l9_152);
float3 l9_155=l9_154;
float l9_156=l9_155.x;
float l9_157=l9_155.y;
float3 l9_158=param_4;
float3 l9_159=l9_158;
float4 l9_160;
if (l9_159.y<l9_159.z)
{
l9_160=float4(l9_159.zy,-1.0,0.66666669);
}
else
{
l9_160=float4(l9_159.yz,0.0,-0.33333334);
}
float4 l9_161=l9_160;
float4 l9_162;
if (l9_159.x<l9_161.x)
{
l9_162=float4(l9_161.xyw,l9_159.x);
}
else
{
l9_162=float4(l9_159.x,l9_161.yzx);
}
float4 l9_163=l9_162;
float l9_164=l9_163.x-fast::min(l9_163.w,l9_163.y);
float l9_165=abs(((l9_163.w-l9_163.y)/((6.0*l9_164)+1e-07))+l9_163.z);
float l9_166=l9_163.x;
float3 l9_167=float3(l9_165,l9_164,l9_166);
float3 l9_168=l9_167;
float l9_169=l9_168.z-(l9_168.y*0.5);
float l9_170=l9_168.y/((1.0-abs((2.0*l9_169)-1.0))+1e-07);
float3 l9_171=float3(l9_168.x,l9_170,l9_169);
float3 l9_172=float3(l9_156,l9_157,l9_171.z);
float l9_173=l9_172.x;
float l9_174=abs((6.0*l9_173)-3.0)-1.0;
float l9_175=2.0-abs((6.0*l9_173)-2.0);
float l9_176=2.0-abs((6.0*l9_173)-4.0);
float3 l9_177=fast::clamp(float3(l9_174,l9_175,l9_176),float3(0.0),float3(1.0));
float3 l9_178=l9_177;
float l9_179=(1.0-abs((2.0*l9_172.z)-1.0))*l9_172.y;
l9_178=((l9_178-float3(0.5))*l9_179)+float3(l9_172.z);
float3 l9_180=l9_178;
float3 l9_181=l9_180;
return l9_181;
}
else
{
if ((int(BLEND_MODE_LUMINOSITY_tmp)!=0))
{
float3 param_6=a;
float3 param_7=b;
float3 l9_182=param_6;
float3 l9_183=l9_182;
float4 l9_184;
if (l9_183.y<l9_183.z)
{
l9_184=float4(l9_183.zy,-1.0,0.66666669);
}
else
{
l9_184=float4(l9_183.yz,0.0,-0.33333334);
}
float4 l9_185=l9_184;
float4 l9_186;
if (l9_183.x<l9_185.x)
{
l9_186=float4(l9_185.xyw,l9_183.x);
}
else
{
l9_186=float4(l9_183.x,l9_185.yzx);
}
float4 l9_187=l9_186;
float l9_188=l9_187.x-fast::min(l9_187.w,l9_187.y);
float l9_189=abs(((l9_187.w-l9_187.y)/((6.0*l9_188)+1e-07))+l9_187.z);
float l9_190=l9_187.x;
float3 l9_191=float3(l9_189,l9_188,l9_190);
float3 l9_192=l9_191;
float l9_193=l9_192.z-(l9_192.y*0.5);
float l9_194=l9_192.y/((1.0-abs((2.0*l9_193)-1.0))+1e-07);
float3 l9_195=float3(l9_192.x,l9_194,l9_193);
float3 l9_196=l9_195;
float l9_197=l9_196.x;
float l9_198=l9_196.y;
float3 l9_199=param_7;
float3 l9_200=l9_199;
float4 l9_201;
if (l9_200.y<l9_200.z)
{
l9_201=float4(l9_200.zy,-1.0,0.66666669);
}
else
{
l9_201=float4(l9_200.yz,0.0,-0.33333334);
}
float4 l9_202=l9_201;
float4 l9_203;
if (l9_200.x<l9_202.x)
{
l9_203=float4(l9_202.xyw,l9_200.x);
}
else
{
l9_203=float4(l9_200.x,l9_202.yzx);
}
float4 l9_204=l9_203;
float l9_205=l9_204.x-fast::min(l9_204.w,l9_204.y);
float l9_206=abs(((l9_204.w-l9_204.y)/((6.0*l9_205)+1e-07))+l9_204.z);
float l9_207=l9_204.x;
float3 l9_208=float3(l9_206,l9_205,l9_207);
float3 l9_209=l9_208;
float l9_210=l9_209.z-(l9_209.y*0.5);
float l9_211=l9_209.y/((1.0-abs((2.0*l9_210)-1.0))+1e-07);
float3 l9_212=float3(l9_209.x,l9_211,l9_210);
float3 l9_213=float3(l9_197,l9_198,l9_212.z);
float l9_214=l9_213.x;
float l9_215=abs((6.0*l9_214)-3.0)-1.0;
float l9_216=2.0-abs((6.0*l9_214)-2.0);
float l9_217=2.0-abs((6.0*l9_214)-4.0);
float3 l9_218=fast::clamp(float3(l9_215,l9_216,l9_217),float3(0.0),float3(1.0));
float3 l9_219=l9_218;
float l9_220=(1.0-abs((2.0*l9_213.z)-1.0))*l9_213.y;
l9_219=((l9_219-float3(0.5))*l9_220)+float3(l9_213.z);
float3 l9_221=l9_219;
float3 l9_222=l9_221;
return l9_222;
}
else
{
float3 param_8=a;
float3 param_9=b;
float3 l9_223=param_8;
float l9_224=((0.29899999*l9_223.x)+(0.58700001*l9_223.y))+(0.114*l9_223.z);
float l9_225=l9_224;
float l9_226=1.0;
float l9_227=pow(l9_225,1.0/UserUniforms.correctedIntensity);
int l9_228;
if ((int(intensityTextureHasSwappedViews_tmp)!=0))
{
int l9_229=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_229=0;
}
else
{
l9_229=varStereoViewID;
}
int l9_230=l9_229;
l9_228=1-l9_230;
}
else
{
int l9_231=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_231=0;
}
else
{
l9_231=varStereoViewID;
}
int l9_232=l9_231;
l9_228=l9_232;
}
int l9_233=l9_228;
int l9_234=intensityTextureLayout_tmp;
int l9_235=l9_233;
float2 l9_236=float2(l9_227,0.5);
bool l9_237=(int(SC_USE_UV_TRANSFORM_intensityTexture_tmp)!=0);
float3x3 l9_238=UserUniforms.intensityTextureTransform;
int2 l9_239=int2(SC_SOFTWARE_WRAP_MODE_U_intensityTexture_tmp,SC_SOFTWARE_WRAP_MODE_V_intensityTexture_tmp);
bool l9_240=(int(SC_USE_UV_MIN_MAX_intensityTexture_tmp)!=0);
float4 l9_241=UserUniforms.intensityTextureUvMinMax;
bool l9_242=(int(SC_USE_CLAMP_TO_BORDER_intensityTexture_tmp)!=0);
float4 l9_243=UserUniforms.intensityTextureBorderColor;
float l9_244=0.0;
bool l9_245=l9_242&&(!l9_240);
float l9_246=1.0;
float l9_247=l9_236.x;
int l9_248=l9_239.x;
if (l9_248==1)
{
l9_247=fract(l9_247);
}
else
{
if (l9_248==2)
{
float l9_249=fract(l9_247);
float l9_250=l9_247-l9_249;
float l9_251=step(0.25,fract(l9_250*0.5));
l9_247=mix(l9_249,1.0-l9_249,fast::clamp(l9_251,0.0,1.0));
}
}
l9_236.x=l9_247;
float l9_252=l9_236.y;
int l9_253=l9_239.y;
if (l9_253==1)
{
l9_252=fract(l9_252);
}
else
{
if (l9_253==2)
{
float l9_254=fract(l9_252);
float l9_255=l9_252-l9_254;
float l9_256=step(0.25,fract(l9_255*0.5));
l9_252=mix(l9_254,1.0-l9_254,fast::clamp(l9_256,0.0,1.0));
}
}
l9_236.y=l9_252;
if (l9_240)
{
bool l9_257=l9_242;
bool l9_258;
if (l9_257)
{
l9_258=l9_239.x==3;
}
else
{
l9_258=l9_257;
}
float l9_259=l9_236.x;
float l9_260=l9_241.x;
float l9_261=l9_241.z;
bool l9_262=l9_258;
float l9_263=l9_246;
float l9_264=fast::clamp(l9_259,l9_260,l9_261);
float l9_265=step(abs(l9_259-l9_264),9.9999997e-06);
l9_263*=(l9_265+((1.0-float(l9_262))*(1.0-l9_265)));
l9_259=l9_264;
l9_236.x=l9_259;
l9_246=l9_263;
bool l9_266=l9_242;
bool l9_267;
if (l9_266)
{
l9_267=l9_239.y==3;
}
else
{
l9_267=l9_266;
}
float l9_268=l9_236.y;
float l9_269=l9_241.y;
float l9_270=l9_241.w;
bool l9_271=l9_267;
float l9_272=l9_246;
float l9_273=fast::clamp(l9_268,l9_269,l9_270);
float l9_274=step(abs(l9_268-l9_273),9.9999997e-06);
l9_272*=(l9_274+((1.0-float(l9_271))*(1.0-l9_274)));
l9_268=l9_273;
l9_236.y=l9_268;
l9_246=l9_272;
}
float2 l9_275=l9_236;
bool l9_276=l9_237;
float3x3 l9_277=l9_238;
if (l9_276)
{
l9_275=float2((l9_277*float3(l9_275,1.0)).xy);
}
float2 l9_278=l9_275;
l9_236=l9_278;
float l9_279=l9_236.x;
int l9_280=l9_239.x;
bool l9_281=l9_245;
float l9_282=l9_246;
if ((l9_280==0)||(l9_280==3))
{
float l9_283=l9_279;
float l9_284=0.0;
float l9_285=1.0;
bool l9_286=l9_281;
float l9_287=l9_282;
float l9_288=fast::clamp(l9_283,l9_284,l9_285);
float l9_289=step(abs(l9_283-l9_288),9.9999997e-06);
l9_287*=(l9_289+((1.0-float(l9_286))*(1.0-l9_289)));
l9_283=l9_288;
l9_279=l9_283;
l9_282=l9_287;
}
l9_236.x=l9_279;
l9_246=l9_282;
float l9_290=l9_236.y;
int l9_291=l9_239.y;
bool l9_292=l9_245;
float l9_293=l9_246;
if ((l9_291==0)||(l9_291==3))
{
float l9_294=l9_290;
float l9_295=0.0;
float l9_296=1.0;
bool l9_297=l9_292;
float l9_298=l9_293;
float l9_299=fast::clamp(l9_294,l9_295,l9_296);
float l9_300=step(abs(l9_294-l9_299),9.9999997e-06);
l9_298*=(l9_300+((1.0-float(l9_297))*(1.0-l9_300)));
l9_294=l9_299;
l9_290=l9_294;
l9_293=l9_298;
}
l9_236.y=l9_290;
l9_246=l9_293;
float2 l9_301=l9_236;
int l9_302=l9_234;
int l9_303=l9_235;
float l9_304=l9_244;
float2 l9_305=l9_301;
int l9_306=l9_302;
int l9_307=l9_303;
float3 l9_308=float3(0.0);
if (l9_306==0)
{
l9_308=float3(l9_305,0.0);
}
else
{
if (l9_306==1)
{
l9_308=float3(l9_305.x,(l9_305.y*0.5)+(0.5-(float(l9_307)*0.5)),0.0);
}
else
{
l9_308=float3(l9_305,float(l9_307));
}
}
float3 l9_309=l9_308;
float3 l9_310=l9_309;
float4 l9_311=intensityTexture.sample(intensityTextureSmpSC,l9_310.xy,bias(l9_304));
float4 l9_312=l9_311;
if (l9_242)
{
l9_312=mix(l9_243,l9_312,float4(l9_246));
}
float4 l9_313=l9_312;
float3 l9_314=l9_313.xyz;
float3 l9_315=l9_314;
float l9_316=16.0;
float l9_317=((((l9_315.x*256.0)+l9_315.y)+(l9_315.z/256.0))/257.00391)*l9_316;
float l9_318=l9_317;
if ((int(BLEND_MODE_FORGRAY_tmp)!=0))
{
l9_318=fast::max(l9_318,1.0);
}
if ((int(BLEND_MODE_NOTBRIGHT_tmp)!=0))
{
l9_318=fast::min(l9_318,1.0);
}
float l9_319=l9_225;
float3 l9_320=param_8;
float3 l9_321=param_9;
float l9_322=l9_226;
float l9_323=l9_318;
float3 l9_324=transformColor(l9_319,l9_320,l9_321,l9_322,l9_323);
return l9_324;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
float4 sc_OutputMotionVectorsIfNeeded(thread const float3& surfacePosWorldSpace,thread const float4& finalColor,thread int& varStereoViewID,constant userUniformsObj& UserUniforms)
{
if ((int(sc_MotionVectorsPass_tmp)!=0))
{
float3 param=surfacePosWorldSpace;
int l9_0=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_0=0;
}
else
{
l9_0=varStereoViewID;
}
int l9_1=l9_0;
float4 l9_2=UserUniforms.sc_ViewProjectionMatrixArray[l9_1]*float4(param,1.0);
float2 l9_3=l9_2.xy/float2(l9_2.w);
l9_2=float4(l9_3.x,l9_3.y,l9_2.z,l9_2.w);
int l9_4=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_4=0;
}
else
{
l9_4=varStereoViewID;
}
int l9_5=l9_4;
float4 l9_6=((UserUniforms.sc_PrevFrameViewProjectionMatrixArray[l9_5]*UserUniforms.sc_PrevFrameModelMatrix)*UserUniforms.sc_ModelMatrixInverse)*float4(param,1.0);
float2 l9_7=l9_6.xy/float2(l9_6.w);
l9_6=float4(l9_7.x,l9_7.y,l9_6.z,l9_6.w);
float2 l9_8=(l9_2.xy-l9_6.xy)*0.5;
float2 l9_9=l9_8;
float l9_10=(l9_9.x*5.0)+0.5;
float l9_11=floor(l9_10*65535.0);
float l9_12=floor(l9_11*0.00390625);
float2 l9_13=float2(l9_12/255.0,(l9_11-(l9_12*256.0))/255.0);
float l9_14=(l9_9.y*5.0)+0.5;
float l9_15=floor(l9_14*65535.0);
float l9_16=floor(l9_15*0.00390625);
float2 l9_17=float2(l9_16/255.0,(l9_15-(l9_16*256.0))/255.0);
float4 l9_18=float4(l9_13,l9_17);
float4 l9_19=l9_18;
return l9_19;
}
else
{
return finalColor;
}
}
fragment main_frag_out main_frag(main_frag_in in [[stage_in]],constant sc_Set0& sc_set0 [[buffer(0)]],float4 gl_FragCoord [[position]])
{
main_frag_out out={};
float4 N16_Value1=float4(0.0);
float4 N16_Result=float4(0.0);
if ((int(sc_DepthOnly_tmp)!=0))
{
return out;
}
if ((sc_StereoRenderingMode_tmp==1)&&(sc_StereoRendering_IsClipDistanceEnabled_tmp==0))
{
if (in.varClipDistance<0.0)
{
discard_fragment();
}
}
ssPreviewInfo PreviewInfo;
PreviewInfo.Color=in.PreviewVertexColor;
PreviewInfo.Saved=((in.PreviewVertexSaved*1.0)!=0.0) ? true : false;
float4 FinalColor=float4(1.0);
ssGlobals Globals;
Globals.gTimeElapsed=(*sc_set0.UserUniforms).sc_Time.x;
Globals.gTimeDelta=(*sc_set0.UserUniforms).sc_Time.y;
bool l9_0=(*sc_set0.UserUniforms).isProxyMode!=0;
if (l9_0)
{
float4 l9_1=gl_FragCoord;
int2 l9_2=int2(l9_1.xy);
RayHitPayload l9_3=GetHitData(l9_2,(*sc_set0.UserUniforms),sc_set0.z_rayDirections,sc_set0.z_rayDirectionsSmpSC,sc_set0.z_hitIdAndBarycentric,sc_set0.z_hitIdAndBarycentricSmp,(*sc_set0.layoutVertices),(*sc_set0.layoutVerticesPN),(*sc_set0.layoutIndices));
RayHitPayload rhp=l9_3;
bool l9_4=(*sc_set0.UserUniforms).noEarlyZ!=0;
if (l9_4)
{
if (rhp.id.x!=uint((*sc_set0.UserUniforms).instance_id))
{
return out;
}
}
Globals.Surface_UVCoord0=rhp.uv0;
}
else
{
Globals.Surface_UVCoord0=in.varPackedTex.xy;
}
float4 Result_N11=float4(0.0);
float param=0.0;
float4 param_1=float4(0.0);
float4 param_2=float4(0.68215501,0.39855,0.51477802,0.0);
ssGlobals param_4=Globals;
float l9_5=0.0;
float l9_6=float((*sc_set0.UserUniforms).alpha_channel!=0);
l9_5=l9_6;
float l9_7=0.0;
float l9_8=float((*sc_set0.UserUniforms).red_channel!=0);
l9_7=l9_8;
float l9_9=0.0;
float l9_10=float((*sc_set0.UserUniforms).green_channel!=0);
l9_9=l9_10;
float l9_11=0.0;
float l9_12=float((*sc_set0.UserUniforms).blue_channel!=0);
l9_11=l9_12;
float l9_13=0.0;
l9_13=(l9_7+l9_9)+l9_11;
float l9_14=0.0;
l9_14=float(l9_13<(*sc_set0.UserUniforms).Port_Input1_N010);
float l9_15=0.0;
float l9_16=l9_5;
bool l9_17=(l9_16*1.0)!=0.0;
bool l9_18;
if (l9_17)
{
l9_18=(l9_14*1.0)!=0.0;
}
else
{
l9_18=l9_17;
}
l9_15=float(l9_18);
param=l9_15;
float4 param_3;
if ((param*1.0)!=0.0)
{
float4 l9_19=float4(0.0);
float l9_20=0.0;
float4 l9_21=float4(0.0);
float4 l9_22=float4(0.0);
ssGlobals l9_23=param_4;
float l9_24=0.0;
float l9_25=float((*sc_set0.UserUniforms).envmap_preview!=0);
l9_24=l9_25;
l9_20=l9_24;
float4 l9_26;
if ((l9_20*1.0)!=0.0)
{
float2 l9_27=float2(0.0);
l9_27=l9_23.Surface_UVCoord0;
float2 l9_28=float2(0.0);
l9_28=l9_27*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_29=float4(0.0);
int l9_30;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_31=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_31=0;
}
else
{
l9_31=in.varStereoViewID;
}
int l9_32=l9_31;
l9_30=1-l9_32;
}
else
{
int l9_33=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_33=0;
}
else
{
l9_33=in.varStereoViewID;
}
int l9_34=l9_33;
l9_30=l9_34;
}
int l9_35=l9_30;
int l9_36=baseTexLayout_tmp;
int l9_37=l9_35;
float2 l9_38=l9_28;
bool l9_39=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_40=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_41=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_42=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_43=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_44=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_45=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_46=0.0;
bool l9_47=l9_44&&(!l9_42);
float l9_48=1.0;
float l9_49=l9_38.x;
int l9_50=l9_41.x;
if (l9_50==1)
{
l9_49=fract(l9_49);
}
else
{
if (l9_50==2)
{
float l9_51=fract(l9_49);
float l9_52=l9_49-l9_51;
float l9_53=step(0.25,fract(l9_52*0.5));
l9_49=mix(l9_51,1.0-l9_51,fast::clamp(l9_53,0.0,1.0));
}
}
l9_38.x=l9_49;
float l9_54=l9_38.y;
int l9_55=l9_41.y;
if (l9_55==1)
{
l9_54=fract(l9_54);
}
else
{
if (l9_55==2)
{
float l9_56=fract(l9_54);
float l9_57=l9_54-l9_56;
float l9_58=step(0.25,fract(l9_57*0.5));
l9_54=mix(l9_56,1.0-l9_56,fast::clamp(l9_58,0.0,1.0));
}
}
l9_38.y=l9_54;
if (l9_42)
{
bool l9_59=l9_44;
bool l9_60;
if (l9_59)
{
l9_60=l9_41.x==3;
}
else
{
l9_60=l9_59;
}
float l9_61=l9_38.x;
float l9_62=l9_43.x;
float l9_63=l9_43.z;
bool l9_64=l9_60;
float l9_65=l9_48;
float l9_66=fast::clamp(l9_61,l9_62,l9_63);
float l9_67=step(abs(l9_61-l9_66),9.9999997e-06);
l9_65*=(l9_67+((1.0-float(l9_64))*(1.0-l9_67)));
l9_61=l9_66;
l9_38.x=l9_61;
l9_48=l9_65;
bool l9_68=l9_44;
bool l9_69;
if (l9_68)
{
l9_69=l9_41.y==3;
}
else
{
l9_69=l9_68;
}
float l9_70=l9_38.y;
float l9_71=l9_43.y;
float l9_72=l9_43.w;
bool l9_73=l9_69;
float l9_74=l9_48;
float l9_75=fast::clamp(l9_70,l9_71,l9_72);
float l9_76=step(abs(l9_70-l9_75),9.9999997e-06);
l9_74*=(l9_76+((1.0-float(l9_73))*(1.0-l9_76)));
l9_70=l9_75;
l9_38.y=l9_70;
l9_48=l9_74;
}
float2 l9_77=l9_38;
bool l9_78=l9_39;
float3x3 l9_79=l9_40;
if (l9_78)
{
l9_77=float2((l9_79*float3(l9_77,1.0)).xy);
}
float2 l9_80=l9_77;
l9_38=l9_80;
float l9_81=l9_38.x;
int l9_82=l9_41.x;
bool l9_83=l9_47;
float l9_84=l9_48;
if ((l9_82==0)||(l9_82==3))
{
float l9_85=l9_81;
float l9_86=0.0;
float l9_87=1.0;
bool l9_88=l9_83;
float l9_89=l9_84;
float l9_90=fast::clamp(l9_85,l9_86,l9_87);
float l9_91=step(abs(l9_85-l9_90),9.9999997e-06);
l9_89*=(l9_91+((1.0-float(l9_88))*(1.0-l9_91)));
l9_85=l9_90;
l9_81=l9_85;
l9_84=l9_89;
}
l9_38.x=l9_81;
l9_48=l9_84;
float l9_92=l9_38.y;
int l9_93=l9_41.y;
bool l9_94=l9_47;
float l9_95=l9_48;
if ((l9_93==0)||(l9_93==3))
{
float l9_96=l9_92;
float l9_97=0.0;
float l9_98=1.0;
bool l9_99=l9_94;
float l9_100=l9_95;
float l9_101=fast::clamp(l9_96,l9_97,l9_98);
float l9_102=step(abs(l9_96-l9_101),9.9999997e-06);
l9_100*=(l9_102+((1.0-float(l9_99))*(1.0-l9_102)));
l9_96=l9_101;
l9_92=l9_96;
l9_95=l9_100;
}
l9_38.y=l9_92;
l9_48=l9_95;
float2 l9_103=l9_38;
int l9_104=l9_36;
int l9_105=l9_37;
float l9_106=l9_46;
float2 l9_107=l9_103;
int l9_108=l9_104;
int l9_109=l9_105;
float3 l9_110=float3(0.0);
if (l9_108==0)
{
l9_110=float3(l9_107,0.0);
}
else
{
if (l9_108==1)
{
l9_110=float3(l9_107.x,(l9_107.y*0.5)+(0.5-(float(l9_109)*0.5)),0.0);
}
else
{
l9_110=float3(l9_107,float(l9_109));
}
}
float3 l9_111=l9_110;
float3 l9_112=l9_111;
float4 l9_113=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_112.xy,bias(l9_106));
float4 l9_114=l9_113;
if (l9_44)
{
l9_114=mix(l9_45,l9_114,float4(l9_48));
}
float4 l9_115=l9_114;
l9_29=l9_115;
float4 l9_116=float4(0.0);
float4 l9_117=l9_29;
float4 l9_118=float4(0.0);
N16_Value1=l9_117;
float3 l9_119=N16_Value1.xyz/float3(N16_Value1.w);
N16_Result=float4(l9_119.x,l9_119.y,l9_119.z,N16_Result.w);
N16_Result.w=1.0;
l9_118=N16_Result;
l9_116=l9_118;
float4 l9_120=float4(0.0);
float3 l9_121=l9_116.xyz;
float l9_122=1.8;
float l9_123=1.4;
float l9_124=0.5;
float l9_125=1.5;
float3 l9_126=(l9_121*((l9_121*l9_122)+float3(l9_123)))/((l9_121*((l9_121*l9_122)+float3(l9_124)))+float3(l9_125));
l9_120=float4(l9_126,l9_116.w);
float4 l9_127=float4(0.0);
float4 l9_128=l9_120;
float4 l9_129;
if (SC_DEVICE_CLASS_tmp>=2)
{
l9_129=float4(pow(l9_128.x,0.45454544),pow(l9_128.y,0.45454544),pow(l9_128.z,0.45454544),pow(l9_128.w,0.45454544));
}
else
{
l9_129=sqrt(l9_128);
}
float4 l9_130=l9_129;
l9_127=l9_130;
l9_21=l9_127;
l9_26=l9_21;
}
else
{
float2 l9_131=float2(0.0);
l9_131=l9_23.Surface_UVCoord0;
float2 l9_132=float2(0.0);
l9_132=l9_131*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_133=float4(0.0);
int l9_134;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_135=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_135=0;
}
else
{
l9_135=in.varStereoViewID;
}
int l9_136=l9_135;
l9_134=1-l9_136;
}
else
{
int l9_137=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_137=0;
}
else
{
l9_137=in.varStereoViewID;
}
int l9_138=l9_137;
l9_134=l9_138;
}
int l9_139=l9_134;
int l9_140=baseTexLayout_tmp;
int l9_141=l9_139;
float2 l9_142=l9_132;
bool l9_143=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_144=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_145=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_146=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_147=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_148=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_149=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_150=0.0;
bool l9_151=l9_148&&(!l9_146);
float l9_152=1.0;
float l9_153=l9_142.x;
int l9_154=l9_145.x;
if (l9_154==1)
{
l9_153=fract(l9_153);
}
else
{
if (l9_154==2)
{
float l9_155=fract(l9_153);
float l9_156=l9_153-l9_155;
float l9_157=step(0.25,fract(l9_156*0.5));
l9_153=mix(l9_155,1.0-l9_155,fast::clamp(l9_157,0.0,1.0));
}
}
l9_142.x=l9_153;
float l9_158=l9_142.y;
int l9_159=l9_145.y;
if (l9_159==1)
{
l9_158=fract(l9_158);
}
else
{
if (l9_159==2)
{
float l9_160=fract(l9_158);
float l9_161=l9_158-l9_160;
float l9_162=step(0.25,fract(l9_161*0.5));
l9_158=mix(l9_160,1.0-l9_160,fast::clamp(l9_162,0.0,1.0));
}
}
l9_142.y=l9_158;
if (l9_146)
{
bool l9_163=l9_148;
bool l9_164;
if (l9_163)
{
l9_164=l9_145.x==3;
}
else
{
l9_164=l9_163;
}
float l9_165=l9_142.x;
float l9_166=l9_147.x;
float l9_167=l9_147.z;
bool l9_168=l9_164;
float l9_169=l9_152;
float l9_170=fast::clamp(l9_165,l9_166,l9_167);
float l9_171=step(abs(l9_165-l9_170),9.9999997e-06);
l9_169*=(l9_171+((1.0-float(l9_168))*(1.0-l9_171)));
l9_165=l9_170;
l9_142.x=l9_165;
l9_152=l9_169;
bool l9_172=l9_148;
bool l9_173;
if (l9_172)
{
l9_173=l9_145.y==3;
}
else
{
l9_173=l9_172;
}
float l9_174=l9_142.y;
float l9_175=l9_147.y;
float l9_176=l9_147.w;
bool l9_177=l9_173;
float l9_178=l9_152;
float l9_179=fast::clamp(l9_174,l9_175,l9_176);
float l9_180=step(abs(l9_174-l9_179),9.9999997e-06);
l9_178*=(l9_180+((1.0-float(l9_177))*(1.0-l9_180)));
l9_174=l9_179;
l9_142.y=l9_174;
l9_152=l9_178;
}
float2 l9_181=l9_142;
bool l9_182=l9_143;
float3x3 l9_183=l9_144;
if (l9_182)
{
l9_181=float2((l9_183*float3(l9_181,1.0)).xy);
}
float2 l9_184=l9_181;
l9_142=l9_184;
float l9_185=l9_142.x;
int l9_186=l9_145.x;
bool l9_187=l9_151;
float l9_188=l9_152;
if ((l9_186==0)||(l9_186==3))
{
float l9_189=l9_185;
float l9_190=0.0;
float l9_191=1.0;
bool l9_192=l9_187;
float l9_193=l9_188;
float l9_194=fast::clamp(l9_189,l9_190,l9_191);
float l9_195=step(abs(l9_189-l9_194),9.9999997e-06);
l9_193*=(l9_195+((1.0-float(l9_192))*(1.0-l9_195)));
l9_189=l9_194;
l9_185=l9_189;
l9_188=l9_193;
}
l9_142.x=l9_185;
l9_152=l9_188;
float l9_196=l9_142.y;
int l9_197=l9_145.y;
bool l9_198=l9_151;
float l9_199=l9_152;
if ((l9_197==0)||(l9_197==3))
{
float l9_200=l9_196;
float l9_201=0.0;
float l9_202=1.0;
bool l9_203=l9_198;
float l9_204=l9_199;
float l9_205=fast::clamp(l9_200,l9_201,l9_202);
float l9_206=step(abs(l9_200-l9_205),9.9999997e-06);
l9_204*=(l9_206+((1.0-float(l9_203))*(1.0-l9_206)));
l9_200=l9_205;
l9_196=l9_200;
l9_199=l9_204;
}
l9_142.y=l9_196;
l9_152=l9_199;
float2 l9_207=l9_142;
int l9_208=l9_140;
int l9_209=l9_141;
float l9_210=l9_150;
float2 l9_211=l9_207;
int l9_212=l9_208;
int l9_213=l9_209;
float3 l9_214=float3(0.0);
if (l9_212==0)
{
l9_214=float3(l9_211,0.0);
}
else
{
if (l9_212==1)
{
l9_214=float3(l9_211.x,(l9_211.y*0.5)+(0.5-(float(l9_213)*0.5)),0.0);
}
else
{
l9_214=float3(l9_211,float(l9_213));
}
}
float3 l9_215=l9_214;
float3 l9_216=l9_215;
float4 l9_217=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_216.xy,bias(l9_210));
float4 l9_218=l9_217;
if (l9_148)
{
l9_218=mix(l9_149,l9_218,float4(l9_152));
}
float4 l9_219=l9_218;
l9_133=l9_219;
l9_22=l9_133;
l9_26=l9_22;
}
l9_19=l9_26;
float l9_220=0.0;
l9_220=l9_19.w;
float4 l9_221=float4(0.0);
float3 l9_222=float3(l9_220);
l9_221=float4(l9_222.x,l9_222.y,l9_222.z,l9_221.w);
l9_221.w=(*sc_set0.UserUniforms).Port_Value2_N013;
param_1=l9_221;
param_3=param_1;
}
else
{
float4 l9_223=float4(0.0);
float l9_224=0.0;
float4 l9_225=float4(0.0);
float4 l9_226=float4(0.68215501,0.39855,0.51477802,0.0);
ssGlobals l9_227=param_4;
float l9_228=0.0;
float l9_229=float((*sc_set0.UserUniforms).red_channel!=0);
l9_228=l9_229;
float l9_230=0.0;
float l9_231=float((*sc_set0.UserUniforms).green_channel!=0);
l9_230=l9_231;
float l9_232=0.0;
float l9_233=float((*sc_set0.UserUniforms).blue_channel!=0);
l9_232=l9_233;
float l9_234=0.0;
l9_234=(l9_228+l9_230)+l9_232;
float l9_235=0.0;
l9_235=float(l9_234>(*sc_set0.UserUniforms).Port_Input1_N009);
l9_224=l9_235;
float4 l9_236;
if ((l9_224*1.0)!=0.0)
{
float l9_237=0.0;
float l9_238=float((*sc_set0.UserUniforms).red_channel!=0);
l9_237=l9_238;
float4 l9_239=float4(0.0);
float l9_240=0.0;
float4 l9_241=float4(0.0);
float4 l9_242=float4(0.0);
ssGlobals l9_243=l9_227;
float l9_244=0.0;
float l9_245=float((*sc_set0.UserUniforms).envmap_preview!=0);
l9_244=l9_245;
l9_240=l9_244;
float4 l9_246;
if ((l9_240*1.0)!=0.0)
{
float2 l9_247=float2(0.0);
l9_247=l9_243.Surface_UVCoord0;
float2 l9_248=float2(0.0);
l9_248=l9_247*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_249=float4(0.0);
int l9_250;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_251=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_251=0;
}
else
{
l9_251=in.varStereoViewID;
}
int l9_252=l9_251;
l9_250=1-l9_252;
}
else
{
int l9_253=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_253=0;
}
else
{
l9_253=in.varStereoViewID;
}
int l9_254=l9_253;
l9_250=l9_254;
}
int l9_255=l9_250;
int l9_256=baseTexLayout_tmp;
int l9_257=l9_255;
float2 l9_258=l9_248;
bool l9_259=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_260=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_261=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_262=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_263=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_264=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_265=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_266=0.0;
bool l9_267=l9_264&&(!l9_262);
float l9_268=1.0;
float l9_269=l9_258.x;
int l9_270=l9_261.x;
if (l9_270==1)
{
l9_269=fract(l9_269);
}
else
{
if (l9_270==2)
{
float l9_271=fract(l9_269);
float l9_272=l9_269-l9_271;
float l9_273=step(0.25,fract(l9_272*0.5));
l9_269=mix(l9_271,1.0-l9_271,fast::clamp(l9_273,0.0,1.0));
}
}
l9_258.x=l9_269;
float l9_274=l9_258.y;
int l9_275=l9_261.y;
if (l9_275==1)
{
l9_274=fract(l9_274);
}
else
{
if (l9_275==2)
{
float l9_276=fract(l9_274);
float l9_277=l9_274-l9_276;
float l9_278=step(0.25,fract(l9_277*0.5));
l9_274=mix(l9_276,1.0-l9_276,fast::clamp(l9_278,0.0,1.0));
}
}
l9_258.y=l9_274;
if (l9_262)
{
bool l9_279=l9_264;
bool l9_280;
if (l9_279)
{
l9_280=l9_261.x==3;
}
else
{
l9_280=l9_279;
}
float l9_281=l9_258.x;
float l9_282=l9_263.x;
float l9_283=l9_263.z;
bool l9_284=l9_280;
float l9_285=l9_268;
float l9_286=fast::clamp(l9_281,l9_282,l9_283);
float l9_287=step(abs(l9_281-l9_286),9.9999997e-06);
l9_285*=(l9_287+((1.0-float(l9_284))*(1.0-l9_287)));
l9_281=l9_286;
l9_258.x=l9_281;
l9_268=l9_285;
bool l9_288=l9_264;
bool l9_289;
if (l9_288)
{
l9_289=l9_261.y==3;
}
else
{
l9_289=l9_288;
}
float l9_290=l9_258.y;
float l9_291=l9_263.y;
float l9_292=l9_263.w;
bool l9_293=l9_289;
float l9_294=l9_268;
float l9_295=fast::clamp(l9_290,l9_291,l9_292);
float l9_296=step(abs(l9_290-l9_295),9.9999997e-06);
l9_294*=(l9_296+((1.0-float(l9_293))*(1.0-l9_296)));
l9_290=l9_295;
l9_258.y=l9_290;
l9_268=l9_294;
}
float2 l9_297=l9_258;
bool l9_298=l9_259;
float3x3 l9_299=l9_260;
if (l9_298)
{
l9_297=float2((l9_299*float3(l9_297,1.0)).xy);
}
float2 l9_300=l9_297;
l9_258=l9_300;
float l9_301=l9_258.x;
int l9_302=l9_261.x;
bool l9_303=l9_267;
float l9_304=l9_268;
if ((l9_302==0)||(l9_302==3))
{
float l9_305=l9_301;
float l9_306=0.0;
float l9_307=1.0;
bool l9_308=l9_303;
float l9_309=l9_304;
float l9_310=fast::clamp(l9_305,l9_306,l9_307);
float l9_311=step(abs(l9_305-l9_310),9.9999997e-06);
l9_309*=(l9_311+((1.0-float(l9_308))*(1.0-l9_311)));
l9_305=l9_310;
l9_301=l9_305;
l9_304=l9_309;
}
l9_258.x=l9_301;
l9_268=l9_304;
float l9_312=l9_258.y;
int l9_313=l9_261.y;
bool l9_314=l9_267;
float l9_315=l9_268;
if ((l9_313==0)||(l9_313==3))
{
float l9_316=l9_312;
float l9_317=0.0;
float l9_318=1.0;
bool l9_319=l9_314;
float l9_320=l9_315;
float l9_321=fast::clamp(l9_316,l9_317,l9_318);
float l9_322=step(abs(l9_316-l9_321),9.9999997e-06);
l9_320*=(l9_322+((1.0-float(l9_319))*(1.0-l9_322)));
l9_316=l9_321;
l9_312=l9_316;
l9_315=l9_320;
}
l9_258.y=l9_312;
l9_268=l9_315;
float2 l9_323=l9_258;
int l9_324=l9_256;
int l9_325=l9_257;
float l9_326=l9_266;
float2 l9_327=l9_323;
int l9_328=l9_324;
int l9_329=l9_325;
float3 l9_330=float3(0.0);
if (l9_328==0)
{
l9_330=float3(l9_327,0.0);
}
else
{
if (l9_328==1)
{
l9_330=float3(l9_327.x,(l9_327.y*0.5)+(0.5-(float(l9_329)*0.5)),0.0);
}
else
{
l9_330=float3(l9_327,float(l9_329));
}
}
float3 l9_331=l9_330;
float3 l9_332=l9_331;
float4 l9_333=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_332.xy,bias(l9_326));
float4 l9_334=l9_333;
if (l9_264)
{
l9_334=mix(l9_265,l9_334,float4(l9_268));
}
float4 l9_335=l9_334;
l9_249=l9_335;
float4 l9_336=float4(0.0);
float4 l9_337=l9_249;
float4 l9_338=float4(0.0);
N16_Value1=l9_337;
float3 l9_339=N16_Value1.xyz/float3(N16_Value1.w);
N16_Result=float4(l9_339.x,l9_339.y,l9_339.z,N16_Result.w);
N16_Result.w=1.0;
l9_338=N16_Result;
l9_336=l9_338;
float4 l9_340=float4(0.0);
float3 l9_341=l9_336.xyz;
float l9_342=1.8;
float l9_343=1.4;
float l9_344=0.5;
float l9_345=1.5;
float3 l9_346=(l9_341*((l9_341*l9_342)+float3(l9_343)))/((l9_341*((l9_341*l9_342)+float3(l9_344)))+float3(l9_345));
l9_340=float4(l9_346,l9_336.w);
float4 l9_347=float4(0.0);
float4 l9_348=l9_340;
float4 l9_349;
if (SC_DEVICE_CLASS_tmp>=2)
{
l9_349=float4(pow(l9_348.x,0.45454544),pow(l9_348.y,0.45454544),pow(l9_348.z,0.45454544),pow(l9_348.w,0.45454544));
}
else
{
l9_349=sqrt(l9_348);
}
float4 l9_350=l9_349;
l9_347=l9_350;
l9_241=l9_347;
l9_246=l9_241;
}
else
{
float2 l9_351=float2(0.0);
l9_351=l9_243.Surface_UVCoord0;
float2 l9_352=float2(0.0);
l9_352=l9_351*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_353=float4(0.0);
int l9_354;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_355=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_355=0;
}
else
{
l9_355=in.varStereoViewID;
}
int l9_356=l9_355;
l9_354=1-l9_356;
}
else
{
int l9_357=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_357=0;
}
else
{
l9_357=in.varStereoViewID;
}
int l9_358=l9_357;
l9_354=l9_358;
}
int l9_359=l9_354;
int l9_360=baseTexLayout_tmp;
int l9_361=l9_359;
float2 l9_362=l9_352;
bool l9_363=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_364=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_365=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_366=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_367=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_368=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_369=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_370=0.0;
bool l9_371=l9_368&&(!l9_366);
float l9_372=1.0;
float l9_373=l9_362.x;
int l9_374=l9_365.x;
if (l9_374==1)
{
l9_373=fract(l9_373);
}
else
{
if (l9_374==2)
{
float l9_375=fract(l9_373);
float l9_376=l9_373-l9_375;
float l9_377=step(0.25,fract(l9_376*0.5));
l9_373=mix(l9_375,1.0-l9_375,fast::clamp(l9_377,0.0,1.0));
}
}
l9_362.x=l9_373;
float l9_378=l9_362.y;
int l9_379=l9_365.y;
if (l9_379==1)
{
l9_378=fract(l9_378);
}
else
{
if (l9_379==2)
{
float l9_380=fract(l9_378);
float l9_381=l9_378-l9_380;
float l9_382=step(0.25,fract(l9_381*0.5));
l9_378=mix(l9_380,1.0-l9_380,fast::clamp(l9_382,0.0,1.0));
}
}
l9_362.y=l9_378;
if (l9_366)
{
bool l9_383=l9_368;
bool l9_384;
if (l9_383)
{
l9_384=l9_365.x==3;
}
else
{
l9_384=l9_383;
}
float l9_385=l9_362.x;
float l9_386=l9_367.x;
float l9_387=l9_367.z;
bool l9_388=l9_384;
float l9_389=l9_372;
float l9_390=fast::clamp(l9_385,l9_386,l9_387);
float l9_391=step(abs(l9_385-l9_390),9.9999997e-06);
l9_389*=(l9_391+((1.0-float(l9_388))*(1.0-l9_391)));
l9_385=l9_390;
l9_362.x=l9_385;
l9_372=l9_389;
bool l9_392=l9_368;
bool l9_393;
if (l9_392)
{
l9_393=l9_365.y==3;
}
else
{
l9_393=l9_392;
}
float l9_394=l9_362.y;
float l9_395=l9_367.y;
float l9_396=l9_367.w;
bool l9_397=l9_393;
float l9_398=l9_372;
float l9_399=fast::clamp(l9_394,l9_395,l9_396);
float l9_400=step(abs(l9_394-l9_399),9.9999997e-06);
l9_398*=(l9_400+((1.0-float(l9_397))*(1.0-l9_400)));
l9_394=l9_399;
l9_362.y=l9_394;
l9_372=l9_398;
}
float2 l9_401=l9_362;
bool l9_402=l9_363;
float3x3 l9_403=l9_364;
if (l9_402)
{
l9_401=float2((l9_403*float3(l9_401,1.0)).xy);
}
float2 l9_404=l9_401;
l9_362=l9_404;
float l9_405=l9_362.x;
int l9_406=l9_365.x;
bool l9_407=l9_371;
float l9_408=l9_372;
if ((l9_406==0)||(l9_406==3))
{
float l9_409=l9_405;
float l9_410=0.0;
float l9_411=1.0;
bool l9_412=l9_407;
float l9_413=l9_408;
float l9_414=fast::clamp(l9_409,l9_410,l9_411);
float l9_415=step(abs(l9_409-l9_414),9.9999997e-06);
l9_413*=(l9_415+((1.0-float(l9_412))*(1.0-l9_415)));
l9_409=l9_414;
l9_405=l9_409;
l9_408=l9_413;
}
l9_362.x=l9_405;
l9_372=l9_408;
float l9_416=l9_362.y;
int l9_417=l9_365.y;
bool l9_418=l9_371;
float l9_419=l9_372;
if ((l9_417==0)||(l9_417==3))
{
float l9_420=l9_416;
float l9_421=0.0;
float l9_422=1.0;
bool l9_423=l9_418;
float l9_424=l9_419;
float l9_425=fast::clamp(l9_420,l9_421,l9_422);
float l9_426=step(abs(l9_420-l9_425),9.9999997e-06);
l9_424*=(l9_426+((1.0-float(l9_423))*(1.0-l9_426)));
l9_420=l9_425;
l9_416=l9_420;
l9_419=l9_424;
}
l9_362.y=l9_416;
l9_372=l9_419;
float2 l9_427=l9_362;
int l9_428=l9_360;
int l9_429=l9_361;
float l9_430=l9_370;
float2 l9_431=l9_427;
int l9_432=l9_428;
int l9_433=l9_429;
float3 l9_434=float3(0.0);
if (l9_432==0)
{
l9_434=float3(l9_431,0.0);
}
else
{
if (l9_432==1)
{
l9_434=float3(l9_431.x,(l9_431.y*0.5)+(0.5-(float(l9_433)*0.5)),0.0);
}
else
{
l9_434=float3(l9_431,float(l9_433));
}
}
float3 l9_435=l9_434;
float3 l9_436=l9_435;
float4 l9_437=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_436.xy,bias(l9_430));
float4 l9_438=l9_437;
if (l9_368)
{
l9_438=mix(l9_369,l9_438,float4(l9_372));
}
float4 l9_439=l9_438;
l9_353=l9_439;
l9_242=l9_353;
l9_246=l9_242;
}
l9_239=l9_246;
float l9_440=0.0;
float l9_441=0.0;
float l9_442=0.0;
float4 l9_443=l9_239;
float l9_444=l9_443.x;
float l9_445=l9_443.y;
float l9_446=l9_443.z;
l9_440=l9_444;
l9_441=l9_445;
l9_442=l9_446;
float l9_447=0.0;
l9_447=l9_237*l9_440;
float l9_448=0.0;
float l9_449=float((*sc_set0.UserUniforms).green_channel!=0);
l9_448=l9_449;
float l9_450=0.0;
l9_450=l9_448*l9_441;
float l9_451=0.0;
float l9_452=float((*sc_set0.UserUniforms).blue_channel!=0);
l9_451=l9_452;
float l9_453=0.0;
l9_453=l9_442*l9_451;
float l9_454=0.0;
float l9_455=0.0;
float l9_456=(*sc_set0.UserUniforms).Port_Value1_N036;
float l9_457=0.0;
ssGlobals l9_458=l9_227;
float l9_459=0.0;
float l9_460=float((*sc_set0.UserUniforms).alpha_channel!=0);
l9_459=l9_460;
float l9_461=0.0;
l9_461=float(l9_459==(*sc_set0.UserUniforms).Port_Input1_N035);
l9_455=l9_461;
float l9_462;
if ((l9_455*1.0)!=0.0)
{
l9_462=l9_456;
}
else
{
float4 l9_463=float4(0.0);
float l9_464=0.0;
float4 l9_465=float4(0.0);
float4 l9_466=float4(0.0);
ssGlobals l9_467=l9_458;
float l9_468=0.0;
float l9_469=float((*sc_set0.UserUniforms).envmap_preview!=0);
l9_468=l9_469;
l9_464=l9_468;
float4 l9_470;
if ((l9_464*1.0)!=0.0)
{
float2 l9_471=float2(0.0);
l9_471=l9_467.Surface_UVCoord0;
float2 l9_472=float2(0.0);
l9_472=l9_471*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_473=float4(0.0);
int l9_474;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_475=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_475=0;
}
else
{
l9_475=in.varStereoViewID;
}
int l9_476=l9_475;
l9_474=1-l9_476;
}
else
{
int l9_477=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_477=0;
}
else
{
l9_477=in.varStereoViewID;
}
int l9_478=l9_477;
l9_474=l9_478;
}
int l9_479=l9_474;
int l9_480=baseTexLayout_tmp;
int l9_481=l9_479;
float2 l9_482=l9_472;
bool l9_483=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_484=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_485=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_486=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_487=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_488=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_489=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_490=0.0;
bool l9_491=l9_488&&(!l9_486);
float l9_492=1.0;
float l9_493=l9_482.x;
int l9_494=l9_485.x;
if (l9_494==1)
{
l9_493=fract(l9_493);
}
else
{
if (l9_494==2)
{
float l9_495=fract(l9_493);
float l9_496=l9_493-l9_495;
float l9_497=step(0.25,fract(l9_496*0.5));
l9_493=mix(l9_495,1.0-l9_495,fast::clamp(l9_497,0.0,1.0));
}
}
l9_482.x=l9_493;
float l9_498=l9_482.y;
int l9_499=l9_485.y;
if (l9_499==1)
{
l9_498=fract(l9_498);
}
else
{
if (l9_499==2)
{
float l9_500=fract(l9_498);
float l9_501=l9_498-l9_500;
float l9_502=step(0.25,fract(l9_501*0.5));
l9_498=mix(l9_500,1.0-l9_500,fast::clamp(l9_502,0.0,1.0));
}
}
l9_482.y=l9_498;
if (l9_486)
{
bool l9_503=l9_488;
bool l9_504;
if (l9_503)
{
l9_504=l9_485.x==3;
}
else
{
l9_504=l9_503;
}
float l9_505=l9_482.x;
float l9_506=l9_487.x;
float l9_507=l9_487.z;
bool l9_508=l9_504;
float l9_509=l9_492;
float l9_510=fast::clamp(l9_505,l9_506,l9_507);
float l9_511=step(abs(l9_505-l9_510),9.9999997e-06);
l9_509*=(l9_511+((1.0-float(l9_508))*(1.0-l9_511)));
l9_505=l9_510;
l9_482.x=l9_505;
l9_492=l9_509;
bool l9_512=l9_488;
bool l9_513;
if (l9_512)
{
l9_513=l9_485.y==3;
}
else
{
l9_513=l9_512;
}
float l9_514=l9_482.y;
float l9_515=l9_487.y;
float l9_516=l9_487.w;
bool l9_517=l9_513;
float l9_518=l9_492;
float l9_519=fast::clamp(l9_514,l9_515,l9_516);
float l9_520=step(abs(l9_514-l9_519),9.9999997e-06);
l9_518*=(l9_520+((1.0-float(l9_517))*(1.0-l9_520)));
l9_514=l9_519;
l9_482.y=l9_514;
l9_492=l9_518;
}
float2 l9_521=l9_482;
bool l9_522=l9_483;
float3x3 l9_523=l9_484;
if (l9_522)
{
l9_521=float2((l9_523*float3(l9_521,1.0)).xy);
}
float2 l9_524=l9_521;
l9_482=l9_524;
float l9_525=l9_482.x;
int l9_526=l9_485.x;
bool l9_527=l9_491;
float l9_528=l9_492;
if ((l9_526==0)||(l9_526==3))
{
float l9_529=l9_525;
float l9_530=0.0;
float l9_531=1.0;
bool l9_532=l9_527;
float l9_533=l9_528;
float l9_534=fast::clamp(l9_529,l9_530,l9_531);
float l9_535=step(abs(l9_529-l9_534),9.9999997e-06);
l9_533*=(l9_535+((1.0-float(l9_532))*(1.0-l9_535)));
l9_529=l9_534;
l9_525=l9_529;
l9_528=l9_533;
}
l9_482.x=l9_525;
l9_492=l9_528;
float l9_536=l9_482.y;
int l9_537=l9_485.y;
bool l9_538=l9_491;
float l9_539=l9_492;
if ((l9_537==0)||(l9_537==3))
{
float l9_540=l9_536;
float l9_541=0.0;
float l9_542=1.0;
bool l9_543=l9_538;
float l9_544=l9_539;
float l9_545=fast::clamp(l9_540,l9_541,l9_542);
float l9_546=step(abs(l9_540-l9_545),9.9999997e-06);
l9_544*=(l9_546+((1.0-float(l9_543))*(1.0-l9_546)));
l9_540=l9_545;
l9_536=l9_540;
l9_539=l9_544;
}
l9_482.y=l9_536;
l9_492=l9_539;
float2 l9_547=l9_482;
int l9_548=l9_480;
int l9_549=l9_481;
float l9_550=l9_490;
float2 l9_551=l9_547;
int l9_552=l9_548;
int l9_553=l9_549;
float3 l9_554=float3(0.0);
if (l9_552==0)
{
l9_554=float3(l9_551,0.0);
}
else
{
if (l9_552==1)
{
l9_554=float3(l9_551.x,(l9_551.y*0.5)+(0.5-(float(l9_553)*0.5)),0.0);
}
else
{
l9_554=float3(l9_551,float(l9_553));
}
}
float3 l9_555=l9_554;
float3 l9_556=l9_555;
float4 l9_557=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_556.xy,bias(l9_550));
float4 l9_558=l9_557;
if (l9_488)
{
l9_558=mix(l9_489,l9_558,float4(l9_492));
}
float4 l9_559=l9_558;
l9_473=l9_559;
float4 l9_560=float4(0.0);
float4 l9_561=l9_473;
float4 l9_562=float4(0.0);
N16_Value1=l9_561;
float3 l9_563=N16_Value1.xyz/float3(N16_Value1.w);
N16_Result=float4(l9_563.x,l9_563.y,l9_563.z,N16_Result.w);
N16_Result.w=1.0;
l9_562=N16_Result;
l9_560=l9_562;
float4 l9_564=float4(0.0);
float3 l9_565=l9_560.xyz;
float l9_566=1.8;
float l9_567=1.4;
float l9_568=0.5;
float l9_569=1.5;
float3 l9_570=(l9_565*((l9_565*l9_566)+float3(l9_567)))/((l9_565*((l9_565*l9_566)+float3(l9_568)))+float3(l9_569));
l9_564=float4(l9_570,l9_560.w);
float4 l9_571=float4(0.0);
float4 l9_572=l9_564;
float4 l9_573;
if (SC_DEVICE_CLASS_tmp>=2)
{
l9_573=float4(pow(l9_572.x,0.45454544),pow(l9_572.y,0.45454544),pow(l9_572.z,0.45454544),pow(l9_572.w,0.45454544));
}
else
{
l9_573=sqrt(l9_572);
}
float4 l9_574=l9_573;
l9_571=l9_574;
l9_465=l9_571;
l9_470=l9_465;
}
else
{
float2 l9_575=float2(0.0);
l9_575=l9_467.Surface_UVCoord0;
float2 l9_576=float2(0.0);
l9_576=l9_575*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_577=float4(0.0);
int l9_578;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_579=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_579=0;
}
else
{
l9_579=in.varStereoViewID;
}
int l9_580=l9_579;
l9_578=1-l9_580;
}
else
{
int l9_581=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_581=0;
}
else
{
l9_581=in.varStereoViewID;
}
int l9_582=l9_581;
l9_578=l9_582;
}
int l9_583=l9_578;
int l9_584=baseTexLayout_tmp;
int l9_585=l9_583;
float2 l9_586=l9_576;
bool l9_587=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_588=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_589=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_590=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_591=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_592=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_593=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_594=0.0;
bool l9_595=l9_592&&(!l9_590);
float l9_596=1.0;
float l9_597=l9_586.x;
int l9_598=l9_589.x;
if (l9_598==1)
{
l9_597=fract(l9_597);
}
else
{
if (l9_598==2)
{
float l9_599=fract(l9_597);
float l9_600=l9_597-l9_599;
float l9_601=step(0.25,fract(l9_600*0.5));
l9_597=mix(l9_599,1.0-l9_599,fast::clamp(l9_601,0.0,1.0));
}
}
l9_586.x=l9_597;
float l9_602=l9_586.y;
int l9_603=l9_589.y;
if (l9_603==1)
{
l9_602=fract(l9_602);
}
else
{
if (l9_603==2)
{
float l9_604=fract(l9_602);
float l9_605=l9_602-l9_604;
float l9_606=step(0.25,fract(l9_605*0.5));
l9_602=mix(l9_604,1.0-l9_604,fast::clamp(l9_606,0.0,1.0));
}
}
l9_586.y=l9_602;
if (l9_590)
{
bool l9_607=l9_592;
bool l9_608;
if (l9_607)
{
l9_608=l9_589.x==3;
}
else
{
l9_608=l9_607;
}
float l9_609=l9_586.x;
float l9_610=l9_591.x;
float l9_611=l9_591.z;
bool l9_612=l9_608;
float l9_613=l9_596;
float l9_614=fast::clamp(l9_609,l9_610,l9_611);
float l9_615=step(abs(l9_609-l9_614),9.9999997e-06);
l9_613*=(l9_615+((1.0-float(l9_612))*(1.0-l9_615)));
l9_609=l9_614;
l9_586.x=l9_609;
l9_596=l9_613;
bool l9_616=l9_592;
bool l9_617;
if (l9_616)
{
l9_617=l9_589.y==3;
}
else
{
l9_617=l9_616;
}
float l9_618=l9_586.y;
float l9_619=l9_591.y;
float l9_620=l9_591.w;
bool l9_621=l9_617;
float l9_622=l9_596;
float l9_623=fast::clamp(l9_618,l9_619,l9_620);
float l9_624=step(abs(l9_618-l9_623),9.9999997e-06);
l9_622*=(l9_624+((1.0-float(l9_621))*(1.0-l9_624)));
l9_618=l9_623;
l9_586.y=l9_618;
l9_596=l9_622;
}
float2 l9_625=l9_586;
bool l9_626=l9_587;
float3x3 l9_627=l9_588;
if (l9_626)
{
l9_625=float2((l9_627*float3(l9_625,1.0)).xy);
}
float2 l9_628=l9_625;
l9_586=l9_628;
float l9_629=l9_586.x;
int l9_630=l9_589.x;
bool l9_631=l9_595;
float l9_632=l9_596;
if ((l9_630==0)||(l9_630==3))
{
float l9_633=l9_629;
float l9_634=0.0;
float l9_635=1.0;
bool l9_636=l9_631;
float l9_637=l9_632;
float l9_638=fast::clamp(l9_633,l9_634,l9_635);
float l9_639=step(abs(l9_633-l9_638),9.9999997e-06);
l9_637*=(l9_639+((1.0-float(l9_636))*(1.0-l9_639)));
l9_633=l9_638;
l9_629=l9_633;
l9_632=l9_637;
}
l9_586.x=l9_629;
l9_596=l9_632;
float l9_640=l9_586.y;
int l9_641=l9_589.y;
bool l9_642=l9_595;
float l9_643=l9_596;
if ((l9_641==0)||(l9_641==3))
{
float l9_644=l9_640;
float l9_645=0.0;
float l9_646=1.0;
bool l9_647=l9_642;
float l9_648=l9_643;
float l9_649=fast::clamp(l9_644,l9_645,l9_646);
float l9_650=step(abs(l9_644-l9_649),9.9999997e-06);
l9_648*=(l9_650+((1.0-float(l9_647))*(1.0-l9_650)));
l9_644=l9_649;
l9_640=l9_644;
l9_643=l9_648;
}
l9_586.y=l9_640;
l9_596=l9_643;
float2 l9_651=l9_586;
int l9_652=l9_584;
int l9_653=l9_585;
float l9_654=l9_594;
float2 l9_655=l9_651;
int l9_656=l9_652;
int l9_657=l9_653;
float3 l9_658=float3(0.0);
if (l9_656==0)
{
l9_658=float3(l9_655,0.0);
}
else
{
if (l9_656==1)
{
l9_658=float3(l9_655.x,(l9_655.y*0.5)+(0.5-(float(l9_657)*0.5)),0.0);
}
else
{
l9_658=float3(l9_655,float(l9_657));
}
}
float3 l9_659=l9_658;
float3 l9_660=l9_659;
float4 l9_661=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_660.xy,bias(l9_654));
float4 l9_662=l9_661;
if (l9_592)
{
l9_662=mix(l9_593,l9_662,float4(l9_596));
}
float4 l9_663=l9_662;
l9_577=l9_663;
l9_466=l9_577;
l9_470=l9_466;
}
l9_463=l9_470;
float l9_664=0.0;
float4 l9_665=l9_463;
float l9_666=l9_665.w;
l9_664=l9_666;
l9_457=l9_664;
l9_462=l9_457;
}
l9_454=l9_462;
float4 l9_667=float4(0.0);
l9_667.x=l9_447;
l9_667.y=l9_450;
l9_667.z=l9_453;
l9_667.w=l9_454;
l9_225=l9_667;
l9_236=l9_225;
}
else
{
float4 l9_668=float4(0.0);
float l9_669=0.0;
float4 l9_670=float4(0.0);
float4 l9_671=(*sc_set0.UserUniforms).Port_Default_N050;
ssGlobals l9_672=l9_227;
float l9_673=0.0;
float l9_674=float((*sc_set0.UserUniforms).red_channel!=0);
l9_673=l9_674;
float l9_675=0.0;
float l9_676=float((*sc_set0.UserUniforms).green_channel!=0);
l9_675=l9_676;
float l9_677=0.0;
float l9_678=float((*sc_set0.UserUniforms).blue_channel!=0);
l9_677=l9_678;
float l9_679=0.0;
l9_679=(l9_673+l9_675)+l9_677;
float l9_680=0.0;
l9_680=float(l9_679==(*sc_set0.UserUniforms).Port_Input1_N046);
l9_669=l9_680;
float4 l9_681;
if ((l9_669*1.0)!=0.0)
{
float4 l9_682=float4(0.0);
float l9_683=0.0;
float4 l9_684=float4(0.0);
float4 l9_685=float4(0.0);
ssGlobals l9_686=l9_672;
float l9_687=0.0;
float l9_688=float((*sc_set0.UserUniforms).red_channel!=0);
l9_687=l9_688;
float l9_689=0.0;
l9_689=float(l9_687==(*sc_set0.UserUniforms).Port_Input1_N051);
l9_683=l9_689;
float4 l9_690;
if ((l9_683*1.0)!=0.0)
{
float4 l9_691=float4(0.0);
float l9_692=0.0;
float4 l9_693=float4(0.0);
float4 l9_694=float4(0.0);
ssGlobals l9_695=l9_686;
float l9_696=0.0;
float l9_697=float((*sc_set0.UserUniforms).envmap_preview!=0);
l9_696=l9_697;
l9_692=l9_696;
float4 l9_698;
if ((l9_692*1.0)!=0.0)
{
float2 l9_699=float2(0.0);
l9_699=l9_695.Surface_UVCoord0;
float2 l9_700=float2(0.0);
l9_700=l9_699*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_701=float4(0.0);
int l9_702;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_703=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_703=0;
}
else
{
l9_703=in.varStereoViewID;
}
int l9_704=l9_703;
l9_702=1-l9_704;
}
else
{
int l9_705=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_705=0;
}
else
{
l9_705=in.varStereoViewID;
}
int l9_706=l9_705;
l9_702=l9_706;
}
int l9_707=l9_702;
int l9_708=baseTexLayout_tmp;
int l9_709=l9_707;
float2 l9_710=l9_700;
bool l9_711=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_712=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_713=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_714=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_715=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_716=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_717=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_718=0.0;
bool l9_719=l9_716&&(!l9_714);
float l9_720=1.0;
float l9_721=l9_710.x;
int l9_722=l9_713.x;
if (l9_722==1)
{
l9_721=fract(l9_721);
}
else
{
if (l9_722==2)
{
float l9_723=fract(l9_721);
float l9_724=l9_721-l9_723;
float l9_725=step(0.25,fract(l9_724*0.5));
l9_721=mix(l9_723,1.0-l9_723,fast::clamp(l9_725,0.0,1.0));
}
}
l9_710.x=l9_721;
float l9_726=l9_710.y;
int l9_727=l9_713.y;
if (l9_727==1)
{
l9_726=fract(l9_726);
}
else
{
if (l9_727==2)
{
float l9_728=fract(l9_726);
float l9_729=l9_726-l9_728;
float l9_730=step(0.25,fract(l9_729*0.5));
l9_726=mix(l9_728,1.0-l9_728,fast::clamp(l9_730,0.0,1.0));
}
}
l9_710.y=l9_726;
if (l9_714)
{
bool l9_731=l9_716;
bool l9_732;
if (l9_731)
{
l9_732=l9_713.x==3;
}
else
{
l9_732=l9_731;
}
float l9_733=l9_710.x;
float l9_734=l9_715.x;
float l9_735=l9_715.z;
bool l9_736=l9_732;
float l9_737=l9_720;
float l9_738=fast::clamp(l9_733,l9_734,l9_735);
float l9_739=step(abs(l9_733-l9_738),9.9999997e-06);
l9_737*=(l9_739+((1.0-float(l9_736))*(1.0-l9_739)));
l9_733=l9_738;
l9_710.x=l9_733;
l9_720=l9_737;
bool l9_740=l9_716;
bool l9_741;
if (l9_740)
{
l9_741=l9_713.y==3;
}
else
{
l9_741=l9_740;
}
float l9_742=l9_710.y;
float l9_743=l9_715.y;
float l9_744=l9_715.w;
bool l9_745=l9_741;
float l9_746=l9_720;
float l9_747=fast::clamp(l9_742,l9_743,l9_744);
float l9_748=step(abs(l9_742-l9_747),9.9999997e-06);
l9_746*=(l9_748+((1.0-float(l9_745))*(1.0-l9_748)));
l9_742=l9_747;
l9_710.y=l9_742;
l9_720=l9_746;
}
float2 l9_749=l9_710;
bool l9_750=l9_711;
float3x3 l9_751=l9_712;
if (l9_750)
{
l9_749=float2((l9_751*float3(l9_749,1.0)).xy);
}
float2 l9_752=l9_749;
l9_710=l9_752;
float l9_753=l9_710.x;
int l9_754=l9_713.x;
bool l9_755=l9_719;
float l9_756=l9_720;
if ((l9_754==0)||(l9_754==3))
{
float l9_757=l9_753;
float l9_758=0.0;
float l9_759=1.0;
bool l9_760=l9_755;
float l9_761=l9_756;
float l9_762=fast::clamp(l9_757,l9_758,l9_759);
float l9_763=step(abs(l9_757-l9_762),9.9999997e-06);
l9_761*=(l9_763+((1.0-float(l9_760))*(1.0-l9_763)));
l9_757=l9_762;
l9_753=l9_757;
l9_756=l9_761;
}
l9_710.x=l9_753;
l9_720=l9_756;
float l9_764=l9_710.y;
int l9_765=l9_713.y;
bool l9_766=l9_719;
float l9_767=l9_720;
if ((l9_765==0)||(l9_765==3))
{
float l9_768=l9_764;
float l9_769=0.0;
float l9_770=1.0;
bool l9_771=l9_766;
float l9_772=l9_767;
float l9_773=fast::clamp(l9_768,l9_769,l9_770);
float l9_774=step(abs(l9_768-l9_773),9.9999997e-06);
l9_772*=(l9_774+((1.0-float(l9_771))*(1.0-l9_774)));
l9_768=l9_773;
l9_764=l9_768;
l9_767=l9_772;
}
l9_710.y=l9_764;
l9_720=l9_767;
float2 l9_775=l9_710;
int l9_776=l9_708;
int l9_777=l9_709;
float l9_778=l9_718;
float2 l9_779=l9_775;
int l9_780=l9_776;
int l9_781=l9_777;
float3 l9_782=float3(0.0);
if (l9_780==0)
{
l9_782=float3(l9_779,0.0);
}
else
{
if (l9_780==1)
{
l9_782=float3(l9_779.x,(l9_779.y*0.5)+(0.5-(float(l9_781)*0.5)),0.0);
}
else
{
l9_782=float3(l9_779,float(l9_781));
}
}
float3 l9_783=l9_782;
float3 l9_784=l9_783;
float4 l9_785=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_784.xy,bias(l9_778));
float4 l9_786=l9_785;
if (l9_716)
{
l9_786=mix(l9_717,l9_786,float4(l9_720));
}
float4 l9_787=l9_786;
l9_701=l9_787;
float4 l9_788=float4(0.0);
float4 l9_789=l9_701;
float4 l9_790=float4(0.0);
N16_Value1=l9_789;
float3 l9_791=N16_Value1.xyz/float3(N16_Value1.w);
N16_Result=float4(l9_791.x,l9_791.y,l9_791.z,N16_Result.w);
N16_Result.w=1.0;
l9_790=N16_Result;
l9_788=l9_790;
float4 l9_792=float4(0.0);
float3 l9_793=l9_788.xyz;
float l9_794=1.8;
float l9_795=1.4;
float l9_796=0.5;
float l9_797=1.5;
float3 l9_798=(l9_793*((l9_793*l9_794)+float3(l9_795)))/((l9_793*((l9_793*l9_794)+float3(l9_796)))+float3(l9_797));
l9_792=float4(l9_798,l9_788.w);
float4 l9_799=float4(0.0);
float4 l9_800=l9_792;
float4 l9_801;
if (SC_DEVICE_CLASS_tmp>=2)
{
l9_801=float4(pow(l9_800.x,0.45454544),pow(l9_800.y,0.45454544),pow(l9_800.z,0.45454544),pow(l9_800.w,0.45454544));
}
else
{
l9_801=sqrt(l9_800);
}
float4 l9_802=l9_801;
l9_799=l9_802;
l9_693=l9_799;
l9_698=l9_693;
}
else
{
float2 l9_803=float2(0.0);
l9_803=l9_695.Surface_UVCoord0;
float2 l9_804=float2(0.0);
l9_804=l9_803*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_805=float4(0.0);
int l9_806;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_807=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_807=0;
}
else
{
l9_807=in.varStereoViewID;
}
int l9_808=l9_807;
l9_806=1-l9_808;
}
else
{
int l9_809=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_809=0;
}
else
{
l9_809=in.varStereoViewID;
}
int l9_810=l9_809;
l9_806=l9_810;
}
int l9_811=l9_806;
int l9_812=baseTexLayout_tmp;
int l9_813=l9_811;
float2 l9_814=l9_804;
bool l9_815=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_816=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_817=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_818=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_819=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_820=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_821=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_822=0.0;
bool l9_823=l9_820&&(!l9_818);
float l9_824=1.0;
float l9_825=l9_814.x;
int l9_826=l9_817.x;
if (l9_826==1)
{
l9_825=fract(l9_825);
}
else
{
if (l9_826==2)
{
float l9_827=fract(l9_825);
float l9_828=l9_825-l9_827;
float l9_829=step(0.25,fract(l9_828*0.5));
l9_825=mix(l9_827,1.0-l9_827,fast::clamp(l9_829,0.0,1.0));
}
}
l9_814.x=l9_825;
float l9_830=l9_814.y;
int l9_831=l9_817.y;
if (l9_831==1)
{
l9_830=fract(l9_830);
}
else
{
if (l9_831==2)
{
float l9_832=fract(l9_830);
float l9_833=l9_830-l9_832;
float l9_834=step(0.25,fract(l9_833*0.5));
l9_830=mix(l9_832,1.0-l9_832,fast::clamp(l9_834,0.0,1.0));
}
}
l9_814.y=l9_830;
if (l9_818)
{
bool l9_835=l9_820;
bool l9_836;
if (l9_835)
{
l9_836=l9_817.x==3;
}
else
{
l9_836=l9_835;
}
float l9_837=l9_814.x;
float l9_838=l9_819.x;
float l9_839=l9_819.z;
bool l9_840=l9_836;
float l9_841=l9_824;
float l9_842=fast::clamp(l9_837,l9_838,l9_839);
float l9_843=step(abs(l9_837-l9_842),9.9999997e-06);
l9_841*=(l9_843+((1.0-float(l9_840))*(1.0-l9_843)));
l9_837=l9_842;
l9_814.x=l9_837;
l9_824=l9_841;
bool l9_844=l9_820;
bool l9_845;
if (l9_844)
{
l9_845=l9_817.y==3;
}
else
{
l9_845=l9_844;
}
float l9_846=l9_814.y;
float l9_847=l9_819.y;
float l9_848=l9_819.w;
bool l9_849=l9_845;
float l9_850=l9_824;
float l9_851=fast::clamp(l9_846,l9_847,l9_848);
float l9_852=step(abs(l9_846-l9_851),9.9999997e-06);
l9_850*=(l9_852+((1.0-float(l9_849))*(1.0-l9_852)));
l9_846=l9_851;
l9_814.y=l9_846;
l9_824=l9_850;
}
float2 l9_853=l9_814;
bool l9_854=l9_815;
float3x3 l9_855=l9_816;
if (l9_854)
{
l9_853=float2((l9_855*float3(l9_853,1.0)).xy);
}
float2 l9_856=l9_853;
l9_814=l9_856;
float l9_857=l9_814.x;
int l9_858=l9_817.x;
bool l9_859=l9_823;
float l9_860=l9_824;
if ((l9_858==0)||(l9_858==3))
{
float l9_861=l9_857;
float l9_862=0.0;
float l9_863=1.0;
bool l9_864=l9_859;
float l9_865=l9_860;
float l9_866=fast::clamp(l9_861,l9_862,l9_863);
float l9_867=step(abs(l9_861-l9_866),9.9999997e-06);
l9_865*=(l9_867+((1.0-float(l9_864))*(1.0-l9_867)));
l9_861=l9_866;
l9_857=l9_861;
l9_860=l9_865;
}
l9_814.x=l9_857;
l9_824=l9_860;
float l9_868=l9_814.y;
int l9_869=l9_817.y;
bool l9_870=l9_823;
float l9_871=l9_824;
if ((l9_869==0)||(l9_869==3))
{
float l9_872=l9_868;
float l9_873=0.0;
float l9_874=1.0;
bool l9_875=l9_870;
float l9_876=l9_871;
float l9_877=fast::clamp(l9_872,l9_873,l9_874);
float l9_878=step(abs(l9_872-l9_877),9.9999997e-06);
l9_876*=(l9_878+((1.0-float(l9_875))*(1.0-l9_878)));
l9_872=l9_877;
l9_868=l9_872;
l9_871=l9_876;
}
l9_814.y=l9_868;
l9_824=l9_871;
float2 l9_879=l9_814;
int l9_880=l9_812;
int l9_881=l9_813;
float l9_882=l9_822;
float2 l9_883=l9_879;
int l9_884=l9_880;
int l9_885=l9_881;
float3 l9_886=float3(0.0);
if (l9_884==0)
{
l9_886=float3(l9_883,0.0);
}
else
{
if (l9_884==1)
{
l9_886=float3(l9_883.x,(l9_883.y*0.5)+(0.5-(float(l9_885)*0.5)),0.0);
}
else
{
l9_886=float3(l9_883,float(l9_885));
}
}
float3 l9_887=l9_886;
float3 l9_888=l9_887;
float4 l9_889=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_888.xy,bias(l9_882));
float4 l9_890=l9_889;
if (l9_820)
{
l9_890=mix(l9_821,l9_890,float4(l9_824));
}
float4 l9_891=l9_890;
l9_805=l9_891;
l9_694=l9_805;
l9_698=l9_694;
}
l9_691=l9_698;
float l9_892=0.0;
float4 l9_893=l9_691;
float l9_894=l9_893.x;
l9_892=l9_894;
float l9_895=0.0;
float l9_896=0.0;
float l9_897=(*sc_set0.UserUniforms).Port_Value1_N043;
float l9_898=0.0;
ssGlobals l9_899=l9_686;
float l9_900=0.0;
float l9_901=float((*sc_set0.UserUniforms).alpha_channel!=0);
l9_900=l9_901;
float l9_902=0.0;
l9_902=float(l9_900==(*sc_set0.UserUniforms).Port_Input1_N034);
l9_896=l9_902;
float l9_903;
if ((l9_896*1.0)!=0.0)
{
l9_903=l9_897;
}
else
{
float4 l9_904=float4(0.0);
float l9_905=0.0;
float4 l9_906=float4(0.0);
float4 l9_907=float4(0.0);
ssGlobals l9_908=l9_899;
float l9_909=0.0;
float l9_910=float((*sc_set0.UserUniforms).envmap_preview!=0);
l9_909=l9_910;
l9_905=l9_909;
float4 l9_911;
if ((l9_905*1.0)!=0.0)
{
float2 l9_912=float2(0.0);
l9_912=l9_908.Surface_UVCoord0;
float2 l9_913=float2(0.0);
l9_913=l9_912*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_914=float4(0.0);
int l9_915;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_916=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_916=0;
}
else
{
l9_916=in.varStereoViewID;
}
int l9_917=l9_916;
l9_915=1-l9_917;
}
else
{
int l9_918=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_918=0;
}
else
{
l9_918=in.varStereoViewID;
}
int l9_919=l9_918;
l9_915=l9_919;
}
int l9_920=l9_915;
int l9_921=baseTexLayout_tmp;
int l9_922=l9_920;
float2 l9_923=l9_913;
bool l9_924=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_925=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_926=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_927=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_928=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_929=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_930=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_931=0.0;
bool l9_932=l9_929&&(!l9_927);
float l9_933=1.0;
float l9_934=l9_923.x;
int l9_935=l9_926.x;
if (l9_935==1)
{
l9_934=fract(l9_934);
}
else
{
if (l9_935==2)
{
float l9_936=fract(l9_934);
float l9_937=l9_934-l9_936;
float l9_938=step(0.25,fract(l9_937*0.5));
l9_934=mix(l9_936,1.0-l9_936,fast::clamp(l9_938,0.0,1.0));
}
}
l9_923.x=l9_934;
float l9_939=l9_923.y;
int l9_940=l9_926.y;
if (l9_940==1)
{
l9_939=fract(l9_939);
}
else
{
if (l9_940==2)
{
float l9_941=fract(l9_939);
float l9_942=l9_939-l9_941;
float l9_943=step(0.25,fract(l9_942*0.5));
l9_939=mix(l9_941,1.0-l9_941,fast::clamp(l9_943,0.0,1.0));
}
}
l9_923.y=l9_939;
if (l9_927)
{
bool l9_944=l9_929;
bool l9_945;
if (l9_944)
{
l9_945=l9_926.x==3;
}
else
{
l9_945=l9_944;
}
float l9_946=l9_923.x;
float l9_947=l9_928.x;
float l9_948=l9_928.z;
bool l9_949=l9_945;
float l9_950=l9_933;
float l9_951=fast::clamp(l9_946,l9_947,l9_948);
float l9_952=step(abs(l9_946-l9_951),9.9999997e-06);
l9_950*=(l9_952+((1.0-float(l9_949))*(1.0-l9_952)));
l9_946=l9_951;
l9_923.x=l9_946;
l9_933=l9_950;
bool l9_953=l9_929;
bool l9_954;
if (l9_953)
{
l9_954=l9_926.y==3;
}
else
{
l9_954=l9_953;
}
float l9_955=l9_923.y;
float l9_956=l9_928.y;
float l9_957=l9_928.w;
bool l9_958=l9_954;
float l9_959=l9_933;
float l9_960=fast::clamp(l9_955,l9_956,l9_957);
float l9_961=step(abs(l9_955-l9_960),9.9999997e-06);
l9_959*=(l9_961+((1.0-float(l9_958))*(1.0-l9_961)));
l9_955=l9_960;
l9_923.y=l9_955;
l9_933=l9_959;
}
float2 l9_962=l9_923;
bool l9_963=l9_924;
float3x3 l9_964=l9_925;
if (l9_963)
{
l9_962=float2((l9_964*float3(l9_962,1.0)).xy);
}
float2 l9_965=l9_962;
l9_923=l9_965;
float l9_966=l9_923.x;
int l9_967=l9_926.x;
bool l9_968=l9_932;
float l9_969=l9_933;
if ((l9_967==0)||(l9_967==3))
{
float l9_970=l9_966;
float l9_971=0.0;
float l9_972=1.0;
bool l9_973=l9_968;
float l9_974=l9_969;
float l9_975=fast::clamp(l9_970,l9_971,l9_972);
float l9_976=step(abs(l9_970-l9_975),9.9999997e-06);
l9_974*=(l9_976+((1.0-float(l9_973))*(1.0-l9_976)));
l9_970=l9_975;
l9_966=l9_970;
l9_969=l9_974;
}
l9_923.x=l9_966;
l9_933=l9_969;
float l9_977=l9_923.y;
int l9_978=l9_926.y;
bool l9_979=l9_932;
float l9_980=l9_933;
if ((l9_978==0)||(l9_978==3))
{
float l9_981=l9_977;
float l9_982=0.0;
float l9_983=1.0;
bool l9_984=l9_979;
float l9_985=l9_980;
float l9_986=fast::clamp(l9_981,l9_982,l9_983);
float l9_987=step(abs(l9_981-l9_986),9.9999997e-06);
l9_985*=(l9_987+((1.0-float(l9_984))*(1.0-l9_987)));
l9_981=l9_986;
l9_977=l9_981;
l9_980=l9_985;
}
l9_923.y=l9_977;
l9_933=l9_980;
float2 l9_988=l9_923;
int l9_989=l9_921;
int l9_990=l9_922;
float l9_991=l9_931;
float2 l9_992=l9_988;
int l9_993=l9_989;
int l9_994=l9_990;
float3 l9_995=float3(0.0);
if (l9_993==0)
{
l9_995=float3(l9_992,0.0);
}
else
{
if (l9_993==1)
{
l9_995=float3(l9_992.x,(l9_992.y*0.5)+(0.5-(float(l9_994)*0.5)),0.0);
}
else
{
l9_995=float3(l9_992,float(l9_994));
}
}
float3 l9_996=l9_995;
float3 l9_997=l9_996;
float4 l9_998=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_997.xy,bias(l9_991));
float4 l9_999=l9_998;
if (l9_929)
{
l9_999=mix(l9_930,l9_999,float4(l9_933));
}
float4 l9_1000=l9_999;
l9_914=l9_1000;
float4 l9_1001=float4(0.0);
float4 l9_1002=l9_914;
float4 l9_1003=float4(0.0);
N16_Value1=l9_1002;
float3 l9_1004=N16_Value1.xyz/float3(N16_Value1.w);
N16_Result=float4(l9_1004.x,l9_1004.y,l9_1004.z,N16_Result.w);
N16_Result.w=1.0;
l9_1003=N16_Result;
l9_1001=l9_1003;
float4 l9_1005=float4(0.0);
float3 l9_1006=l9_1001.xyz;
float l9_1007=1.8;
float l9_1008=1.4;
float l9_1009=0.5;
float l9_1010=1.5;
float3 l9_1011=(l9_1006*((l9_1006*l9_1007)+float3(l9_1008)))/((l9_1006*((l9_1006*l9_1007)+float3(l9_1009)))+float3(l9_1010));
l9_1005=float4(l9_1011,l9_1001.w);
float4 l9_1012=float4(0.0);
float4 l9_1013=l9_1005;
float4 l9_1014;
if (SC_DEVICE_CLASS_tmp>=2)
{
l9_1014=float4(pow(l9_1013.x,0.45454544),pow(l9_1013.y,0.45454544),pow(l9_1013.z,0.45454544),pow(l9_1013.w,0.45454544));
}
else
{
l9_1014=sqrt(l9_1013);
}
float4 l9_1015=l9_1014;
l9_1012=l9_1015;
l9_906=l9_1012;
l9_911=l9_906;
}
else
{
float2 l9_1016=float2(0.0);
l9_1016=l9_908.Surface_UVCoord0;
float2 l9_1017=float2(0.0);
l9_1017=l9_1016*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_1018=float4(0.0);
int l9_1019;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_1020=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1020=0;
}
else
{
l9_1020=in.varStereoViewID;
}
int l9_1021=l9_1020;
l9_1019=1-l9_1021;
}
else
{
int l9_1022=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1022=0;
}
else
{
l9_1022=in.varStereoViewID;
}
int l9_1023=l9_1022;
l9_1019=l9_1023;
}
int l9_1024=l9_1019;
int l9_1025=baseTexLayout_tmp;
int l9_1026=l9_1024;
float2 l9_1027=l9_1017;
bool l9_1028=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_1029=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_1030=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_1031=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_1032=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_1033=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_1034=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_1035=0.0;
bool l9_1036=l9_1033&&(!l9_1031);
float l9_1037=1.0;
float l9_1038=l9_1027.x;
int l9_1039=l9_1030.x;
if (l9_1039==1)
{
l9_1038=fract(l9_1038);
}
else
{
if (l9_1039==2)
{
float l9_1040=fract(l9_1038);
float l9_1041=l9_1038-l9_1040;
float l9_1042=step(0.25,fract(l9_1041*0.5));
l9_1038=mix(l9_1040,1.0-l9_1040,fast::clamp(l9_1042,0.0,1.0));
}
}
l9_1027.x=l9_1038;
float l9_1043=l9_1027.y;
int l9_1044=l9_1030.y;
if (l9_1044==1)
{
l9_1043=fract(l9_1043);
}
else
{
if (l9_1044==2)
{
float l9_1045=fract(l9_1043);
float l9_1046=l9_1043-l9_1045;
float l9_1047=step(0.25,fract(l9_1046*0.5));
l9_1043=mix(l9_1045,1.0-l9_1045,fast::clamp(l9_1047,0.0,1.0));
}
}
l9_1027.y=l9_1043;
if (l9_1031)
{
bool l9_1048=l9_1033;
bool l9_1049;
if (l9_1048)
{
l9_1049=l9_1030.x==3;
}
else
{
l9_1049=l9_1048;
}
float l9_1050=l9_1027.x;
float l9_1051=l9_1032.x;
float l9_1052=l9_1032.z;
bool l9_1053=l9_1049;
float l9_1054=l9_1037;
float l9_1055=fast::clamp(l9_1050,l9_1051,l9_1052);
float l9_1056=step(abs(l9_1050-l9_1055),9.9999997e-06);
l9_1054*=(l9_1056+((1.0-float(l9_1053))*(1.0-l9_1056)));
l9_1050=l9_1055;
l9_1027.x=l9_1050;
l9_1037=l9_1054;
bool l9_1057=l9_1033;
bool l9_1058;
if (l9_1057)
{
l9_1058=l9_1030.y==3;
}
else
{
l9_1058=l9_1057;
}
float l9_1059=l9_1027.y;
float l9_1060=l9_1032.y;
float l9_1061=l9_1032.w;
bool l9_1062=l9_1058;
float l9_1063=l9_1037;
float l9_1064=fast::clamp(l9_1059,l9_1060,l9_1061);
float l9_1065=step(abs(l9_1059-l9_1064),9.9999997e-06);
l9_1063*=(l9_1065+((1.0-float(l9_1062))*(1.0-l9_1065)));
l9_1059=l9_1064;
l9_1027.y=l9_1059;
l9_1037=l9_1063;
}
float2 l9_1066=l9_1027;
bool l9_1067=l9_1028;
float3x3 l9_1068=l9_1029;
if (l9_1067)
{
l9_1066=float2((l9_1068*float3(l9_1066,1.0)).xy);
}
float2 l9_1069=l9_1066;
l9_1027=l9_1069;
float l9_1070=l9_1027.x;
int l9_1071=l9_1030.x;
bool l9_1072=l9_1036;
float l9_1073=l9_1037;
if ((l9_1071==0)||(l9_1071==3))
{
float l9_1074=l9_1070;
float l9_1075=0.0;
float l9_1076=1.0;
bool l9_1077=l9_1072;
float l9_1078=l9_1073;
float l9_1079=fast::clamp(l9_1074,l9_1075,l9_1076);
float l9_1080=step(abs(l9_1074-l9_1079),9.9999997e-06);
l9_1078*=(l9_1080+((1.0-float(l9_1077))*(1.0-l9_1080)));
l9_1074=l9_1079;
l9_1070=l9_1074;
l9_1073=l9_1078;
}
l9_1027.x=l9_1070;
l9_1037=l9_1073;
float l9_1081=l9_1027.y;
int l9_1082=l9_1030.y;
bool l9_1083=l9_1036;
float l9_1084=l9_1037;
if ((l9_1082==0)||(l9_1082==3))
{
float l9_1085=l9_1081;
float l9_1086=0.0;
float l9_1087=1.0;
bool l9_1088=l9_1083;
float l9_1089=l9_1084;
float l9_1090=fast::clamp(l9_1085,l9_1086,l9_1087);
float l9_1091=step(abs(l9_1085-l9_1090),9.9999997e-06);
l9_1089*=(l9_1091+((1.0-float(l9_1088))*(1.0-l9_1091)));
l9_1085=l9_1090;
l9_1081=l9_1085;
l9_1084=l9_1089;
}
l9_1027.y=l9_1081;
l9_1037=l9_1084;
float2 l9_1092=l9_1027;
int l9_1093=l9_1025;
int l9_1094=l9_1026;
float l9_1095=l9_1035;
float2 l9_1096=l9_1092;
int l9_1097=l9_1093;
int l9_1098=l9_1094;
float3 l9_1099=float3(0.0);
if (l9_1097==0)
{
l9_1099=float3(l9_1096,0.0);
}
else
{
if (l9_1097==1)
{
l9_1099=float3(l9_1096.x,(l9_1096.y*0.5)+(0.5-(float(l9_1098)*0.5)),0.0);
}
else
{
l9_1099=float3(l9_1096,float(l9_1098));
}
}
float3 l9_1100=l9_1099;
float3 l9_1101=l9_1100;
float4 l9_1102=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_1101.xy,bias(l9_1095));
float4 l9_1103=l9_1102;
if (l9_1033)
{
l9_1103=mix(l9_1034,l9_1103,float4(l9_1037));
}
float4 l9_1104=l9_1103;
l9_1018=l9_1104;
l9_907=l9_1018;
l9_911=l9_907;
}
l9_904=l9_911;
float l9_1105=0.0;
float4 l9_1106=l9_904;
float l9_1107=l9_1106.w;
l9_1105=l9_1107;
l9_898=l9_1105;
l9_903=l9_898;
}
l9_895=l9_903;
float4 l9_1108=float4(0.0);
l9_1108.x=l9_892;
l9_1108.y=l9_892;
l9_1108.z=l9_892;
l9_1108.w=l9_895;
l9_684=l9_1108;
l9_690=l9_684;
}
else
{
float4 l9_1109=float4(0.0);
float l9_1110=0.0;
float4 l9_1111=float4(0.0);
float4 l9_1112=float4(0.0);
ssGlobals l9_1113=l9_686;
float l9_1114=0.0;
float l9_1115=float((*sc_set0.UserUniforms).green_channel!=0);
l9_1114=l9_1115;
float l9_1116=0.0;
l9_1116=float(l9_1114==(*sc_set0.UserUniforms).Port_Input1_N052);
l9_1110=l9_1116;
float4 l9_1117;
if ((l9_1110*1.0)!=0.0)
{
float4 l9_1118=float4(0.0);
float l9_1119=0.0;
float4 l9_1120=float4(0.0);
float4 l9_1121=float4(0.0);
ssGlobals l9_1122=l9_1113;
float l9_1123=0.0;
float l9_1124=float((*sc_set0.UserUniforms).envmap_preview!=0);
l9_1123=l9_1124;
l9_1119=l9_1123;
float4 l9_1125;
if ((l9_1119*1.0)!=0.0)
{
float2 l9_1126=float2(0.0);
l9_1126=l9_1122.Surface_UVCoord0;
float2 l9_1127=float2(0.0);
l9_1127=l9_1126*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_1128=float4(0.0);
int l9_1129;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_1130=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1130=0;
}
else
{
l9_1130=in.varStereoViewID;
}
int l9_1131=l9_1130;
l9_1129=1-l9_1131;
}
else
{
int l9_1132=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1132=0;
}
else
{
l9_1132=in.varStereoViewID;
}
int l9_1133=l9_1132;
l9_1129=l9_1133;
}
int l9_1134=l9_1129;
int l9_1135=baseTexLayout_tmp;
int l9_1136=l9_1134;
float2 l9_1137=l9_1127;
bool l9_1138=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_1139=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_1140=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_1141=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_1142=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_1143=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_1144=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_1145=0.0;
bool l9_1146=l9_1143&&(!l9_1141);
float l9_1147=1.0;
float l9_1148=l9_1137.x;
int l9_1149=l9_1140.x;
if (l9_1149==1)
{
l9_1148=fract(l9_1148);
}
else
{
if (l9_1149==2)
{
float l9_1150=fract(l9_1148);
float l9_1151=l9_1148-l9_1150;
float l9_1152=step(0.25,fract(l9_1151*0.5));
l9_1148=mix(l9_1150,1.0-l9_1150,fast::clamp(l9_1152,0.0,1.0));
}
}
l9_1137.x=l9_1148;
float l9_1153=l9_1137.y;
int l9_1154=l9_1140.y;
if (l9_1154==1)
{
l9_1153=fract(l9_1153);
}
else
{
if (l9_1154==2)
{
float l9_1155=fract(l9_1153);
float l9_1156=l9_1153-l9_1155;
float l9_1157=step(0.25,fract(l9_1156*0.5));
l9_1153=mix(l9_1155,1.0-l9_1155,fast::clamp(l9_1157,0.0,1.0));
}
}
l9_1137.y=l9_1153;
if (l9_1141)
{
bool l9_1158=l9_1143;
bool l9_1159;
if (l9_1158)
{
l9_1159=l9_1140.x==3;
}
else
{
l9_1159=l9_1158;
}
float l9_1160=l9_1137.x;
float l9_1161=l9_1142.x;
float l9_1162=l9_1142.z;
bool l9_1163=l9_1159;
float l9_1164=l9_1147;
float l9_1165=fast::clamp(l9_1160,l9_1161,l9_1162);
float l9_1166=step(abs(l9_1160-l9_1165),9.9999997e-06);
l9_1164*=(l9_1166+((1.0-float(l9_1163))*(1.0-l9_1166)));
l9_1160=l9_1165;
l9_1137.x=l9_1160;
l9_1147=l9_1164;
bool l9_1167=l9_1143;
bool l9_1168;
if (l9_1167)
{
l9_1168=l9_1140.y==3;
}
else
{
l9_1168=l9_1167;
}
float l9_1169=l9_1137.y;
float l9_1170=l9_1142.y;
float l9_1171=l9_1142.w;
bool l9_1172=l9_1168;
float l9_1173=l9_1147;
float l9_1174=fast::clamp(l9_1169,l9_1170,l9_1171);
float l9_1175=step(abs(l9_1169-l9_1174),9.9999997e-06);
l9_1173*=(l9_1175+((1.0-float(l9_1172))*(1.0-l9_1175)));
l9_1169=l9_1174;
l9_1137.y=l9_1169;
l9_1147=l9_1173;
}
float2 l9_1176=l9_1137;
bool l9_1177=l9_1138;
float3x3 l9_1178=l9_1139;
if (l9_1177)
{
l9_1176=float2((l9_1178*float3(l9_1176,1.0)).xy);
}
float2 l9_1179=l9_1176;
l9_1137=l9_1179;
float l9_1180=l9_1137.x;
int l9_1181=l9_1140.x;
bool l9_1182=l9_1146;
float l9_1183=l9_1147;
if ((l9_1181==0)||(l9_1181==3))
{
float l9_1184=l9_1180;
float l9_1185=0.0;
float l9_1186=1.0;
bool l9_1187=l9_1182;
float l9_1188=l9_1183;
float l9_1189=fast::clamp(l9_1184,l9_1185,l9_1186);
float l9_1190=step(abs(l9_1184-l9_1189),9.9999997e-06);
l9_1188*=(l9_1190+((1.0-float(l9_1187))*(1.0-l9_1190)));
l9_1184=l9_1189;
l9_1180=l9_1184;
l9_1183=l9_1188;
}
l9_1137.x=l9_1180;
l9_1147=l9_1183;
float l9_1191=l9_1137.y;
int l9_1192=l9_1140.y;
bool l9_1193=l9_1146;
float l9_1194=l9_1147;
if ((l9_1192==0)||(l9_1192==3))
{
float l9_1195=l9_1191;
float l9_1196=0.0;
float l9_1197=1.0;
bool l9_1198=l9_1193;
float l9_1199=l9_1194;
float l9_1200=fast::clamp(l9_1195,l9_1196,l9_1197);
float l9_1201=step(abs(l9_1195-l9_1200),9.9999997e-06);
l9_1199*=(l9_1201+((1.0-float(l9_1198))*(1.0-l9_1201)));
l9_1195=l9_1200;
l9_1191=l9_1195;
l9_1194=l9_1199;
}
l9_1137.y=l9_1191;
l9_1147=l9_1194;
float2 l9_1202=l9_1137;
int l9_1203=l9_1135;
int l9_1204=l9_1136;
float l9_1205=l9_1145;
float2 l9_1206=l9_1202;
int l9_1207=l9_1203;
int l9_1208=l9_1204;
float3 l9_1209=float3(0.0);
if (l9_1207==0)
{
l9_1209=float3(l9_1206,0.0);
}
else
{
if (l9_1207==1)
{
l9_1209=float3(l9_1206.x,(l9_1206.y*0.5)+(0.5-(float(l9_1208)*0.5)),0.0);
}
else
{
l9_1209=float3(l9_1206,float(l9_1208));
}
}
float3 l9_1210=l9_1209;
float3 l9_1211=l9_1210;
float4 l9_1212=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_1211.xy,bias(l9_1205));
float4 l9_1213=l9_1212;
if (l9_1143)
{
l9_1213=mix(l9_1144,l9_1213,float4(l9_1147));
}
float4 l9_1214=l9_1213;
l9_1128=l9_1214;
float4 l9_1215=float4(0.0);
float4 l9_1216=l9_1128;
float4 l9_1217=float4(0.0);
N16_Value1=l9_1216;
float3 l9_1218=N16_Value1.xyz/float3(N16_Value1.w);
N16_Result=float4(l9_1218.x,l9_1218.y,l9_1218.z,N16_Result.w);
N16_Result.w=1.0;
l9_1217=N16_Result;
l9_1215=l9_1217;
float4 l9_1219=float4(0.0);
float3 l9_1220=l9_1215.xyz;
float l9_1221=1.8;
float l9_1222=1.4;
float l9_1223=0.5;
float l9_1224=1.5;
float3 l9_1225=(l9_1220*((l9_1220*l9_1221)+float3(l9_1222)))/((l9_1220*((l9_1220*l9_1221)+float3(l9_1223)))+float3(l9_1224));
l9_1219=float4(l9_1225,l9_1215.w);
float4 l9_1226=float4(0.0);
float4 l9_1227=l9_1219;
float4 l9_1228;
if (SC_DEVICE_CLASS_tmp>=2)
{
l9_1228=float4(pow(l9_1227.x,0.45454544),pow(l9_1227.y,0.45454544),pow(l9_1227.z,0.45454544),pow(l9_1227.w,0.45454544));
}
else
{
l9_1228=sqrt(l9_1227);
}
float4 l9_1229=l9_1228;
l9_1226=l9_1229;
l9_1120=l9_1226;
l9_1125=l9_1120;
}
else
{
float2 l9_1230=float2(0.0);
l9_1230=l9_1122.Surface_UVCoord0;
float2 l9_1231=float2(0.0);
l9_1231=l9_1230*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_1232=float4(0.0);
int l9_1233;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_1234=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1234=0;
}
else
{
l9_1234=in.varStereoViewID;
}
int l9_1235=l9_1234;
l9_1233=1-l9_1235;
}
else
{
int l9_1236=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1236=0;
}
else
{
l9_1236=in.varStereoViewID;
}
int l9_1237=l9_1236;
l9_1233=l9_1237;
}
int l9_1238=l9_1233;
int l9_1239=baseTexLayout_tmp;
int l9_1240=l9_1238;
float2 l9_1241=l9_1231;
bool l9_1242=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_1243=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_1244=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_1245=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_1246=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_1247=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_1248=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_1249=0.0;
bool l9_1250=l9_1247&&(!l9_1245);
float l9_1251=1.0;
float l9_1252=l9_1241.x;
int l9_1253=l9_1244.x;
if (l9_1253==1)
{
l9_1252=fract(l9_1252);
}
else
{
if (l9_1253==2)
{
float l9_1254=fract(l9_1252);
float l9_1255=l9_1252-l9_1254;
float l9_1256=step(0.25,fract(l9_1255*0.5));
l9_1252=mix(l9_1254,1.0-l9_1254,fast::clamp(l9_1256,0.0,1.0));
}
}
l9_1241.x=l9_1252;
float l9_1257=l9_1241.y;
int l9_1258=l9_1244.y;
if (l9_1258==1)
{
l9_1257=fract(l9_1257);
}
else
{
if (l9_1258==2)
{
float l9_1259=fract(l9_1257);
float l9_1260=l9_1257-l9_1259;
float l9_1261=step(0.25,fract(l9_1260*0.5));
l9_1257=mix(l9_1259,1.0-l9_1259,fast::clamp(l9_1261,0.0,1.0));
}
}
l9_1241.y=l9_1257;
if (l9_1245)
{
bool l9_1262=l9_1247;
bool l9_1263;
if (l9_1262)
{
l9_1263=l9_1244.x==3;
}
else
{
l9_1263=l9_1262;
}
float l9_1264=l9_1241.x;
float l9_1265=l9_1246.x;
float l9_1266=l9_1246.z;
bool l9_1267=l9_1263;
float l9_1268=l9_1251;
float l9_1269=fast::clamp(l9_1264,l9_1265,l9_1266);
float l9_1270=step(abs(l9_1264-l9_1269),9.9999997e-06);
l9_1268*=(l9_1270+((1.0-float(l9_1267))*(1.0-l9_1270)));
l9_1264=l9_1269;
l9_1241.x=l9_1264;
l9_1251=l9_1268;
bool l9_1271=l9_1247;
bool l9_1272;
if (l9_1271)
{
l9_1272=l9_1244.y==3;
}
else
{
l9_1272=l9_1271;
}
float l9_1273=l9_1241.y;
float l9_1274=l9_1246.y;
float l9_1275=l9_1246.w;
bool l9_1276=l9_1272;
float l9_1277=l9_1251;
float l9_1278=fast::clamp(l9_1273,l9_1274,l9_1275);
float l9_1279=step(abs(l9_1273-l9_1278),9.9999997e-06);
l9_1277*=(l9_1279+((1.0-float(l9_1276))*(1.0-l9_1279)));
l9_1273=l9_1278;
l9_1241.y=l9_1273;
l9_1251=l9_1277;
}
float2 l9_1280=l9_1241;
bool l9_1281=l9_1242;
float3x3 l9_1282=l9_1243;
if (l9_1281)
{
l9_1280=float2((l9_1282*float3(l9_1280,1.0)).xy);
}
float2 l9_1283=l9_1280;
l9_1241=l9_1283;
float l9_1284=l9_1241.x;
int l9_1285=l9_1244.x;
bool l9_1286=l9_1250;
float l9_1287=l9_1251;
if ((l9_1285==0)||(l9_1285==3))
{
float l9_1288=l9_1284;
float l9_1289=0.0;
float l9_1290=1.0;
bool l9_1291=l9_1286;
float l9_1292=l9_1287;
float l9_1293=fast::clamp(l9_1288,l9_1289,l9_1290);
float l9_1294=step(abs(l9_1288-l9_1293),9.9999997e-06);
l9_1292*=(l9_1294+((1.0-float(l9_1291))*(1.0-l9_1294)));
l9_1288=l9_1293;
l9_1284=l9_1288;
l9_1287=l9_1292;
}
l9_1241.x=l9_1284;
l9_1251=l9_1287;
float l9_1295=l9_1241.y;
int l9_1296=l9_1244.y;
bool l9_1297=l9_1250;
float l9_1298=l9_1251;
if ((l9_1296==0)||(l9_1296==3))
{
float l9_1299=l9_1295;
float l9_1300=0.0;
float l9_1301=1.0;
bool l9_1302=l9_1297;
float l9_1303=l9_1298;
float l9_1304=fast::clamp(l9_1299,l9_1300,l9_1301);
float l9_1305=step(abs(l9_1299-l9_1304),9.9999997e-06);
l9_1303*=(l9_1305+((1.0-float(l9_1302))*(1.0-l9_1305)));
l9_1299=l9_1304;
l9_1295=l9_1299;
l9_1298=l9_1303;
}
l9_1241.y=l9_1295;
l9_1251=l9_1298;
float2 l9_1306=l9_1241;
int l9_1307=l9_1239;
int l9_1308=l9_1240;
float l9_1309=l9_1249;
float2 l9_1310=l9_1306;
int l9_1311=l9_1307;
int l9_1312=l9_1308;
float3 l9_1313=float3(0.0);
if (l9_1311==0)
{
l9_1313=float3(l9_1310,0.0);
}
else
{
if (l9_1311==1)
{
l9_1313=float3(l9_1310.x,(l9_1310.y*0.5)+(0.5-(float(l9_1312)*0.5)),0.0);
}
else
{
l9_1313=float3(l9_1310,float(l9_1312));
}
}
float3 l9_1314=l9_1313;
float3 l9_1315=l9_1314;
float4 l9_1316=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_1315.xy,bias(l9_1309));
float4 l9_1317=l9_1316;
if (l9_1247)
{
l9_1317=mix(l9_1248,l9_1317,float4(l9_1251));
}
float4 l9_1318=l9_1317;
l9_1232=l9_1318;
l9_1121=l9_1232;
l9_1125=l9_1121;
}
l9_1118=l9_1125;
float l9_1319=0.0;
float4 l9_1320=l9_1118;
float l9_1321=l9_1320.y;
l9_1319=l9_1321;
float l9_1322=0.0;
float l9_1323=0.0;
float l9_1324=(*sc_set0.UserUniforms).Port_Value1_N043;
float l9_1325=0.0;
ssGlobals l9_1326=l9_1113;
float l9_1327=0.0;
float l9_1328=float((*sc_set0.UserUniforms).alpha_channel!=0);
l9_1327=l9_1328;
float l9_1329=0.0;
l9_1329=float(l9_1327==(*sc_set0.UserUniforms).Port_Input1_N034);
l9_1323=l9_1329;
float l9_1330;
if ((l9_1323*1.0)!=0.0)
{
l9_1330=l9_1324;
}
else
{
float4 l9_1331=float4(0.0);
float l9_1332=0.0;
float4 l9_1333=float4(0.0);
float4 l9_1334=float4(0.0);
ssGlobals l9_1335=l9_1326;
float l9_1336=0.0;
float l9_1337=float((*sc_set0.UserUniforms).envmap_preview!=0);
l9_1336=l9_1337;
l9_1332=l9_1336;
float4 l9_1338;
if ((l9_1332*1.0)!=0.0)
{
float2 l9_1339=float2(0.0);
l9_1339=l9_1335.Surface_UVCoord0;
float2 l9_1340=float2(0.0);
l9_1340=l9_1339*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_1341=float4(0.0);
int l9_1342;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_1343=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1343=0;
}
else
{
l9_1343=in.varStereoViewID;
}
int l9_1344=l9_1343;
l9_1342=1-l9_1344;
}
else
{
int l9_1345=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1345=0;
}
else
{
l9_1345=in.varStereoViewID;
}
int l9_1346=l9_1345;
l9_1342=l9_1346;
}
int l9_1347=l9_1342;
int l9_1348=baseTexLayout_tmp;
int l9_1349=l9_1347;
float2 l9_1350=l9_1340;
bool l9_1351=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_1352=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_1353=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_1354=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_1355=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_1356=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_1357=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_1358=0.0;
bool l9_1359=l9_1356&&(!l9_1354);
float l9_1360=1.0;
float l9_1361=l9_1350.x;
int l9_1362=l9_1353.x;
if (l9_1362==1)
{
l9_1361=fract(l9_1361);
}
else
{
if (l9_1362==2)
{
float l9_1363=fract(l9_1361);
float l9_1364=l9_1361-l9_1363;
float l9_1365=step(0.25,fract(l9_1364*0.5));
l9_1361=mix(l9_1363,1.0-l9_1363,fast::clamp(l9_1365,0.0,1.0));
}
}
l9_1350.x=l9_1361;
float l9_1366=l9_1350.y;
int l9_1367=l9_1353.y;
if (l9_1367==1)
{
l9_1366=fract(l9_1366);
}
else
{
if (l9_1367==2)
{
float l9_1368=fract(l9_1366);
float l9_1369=l9_1366-l9_1368;
float l9_1370=step(0.25,fract(l9_1369*0.5));
l9_1366=mix(l9_1368,1.0-l9_1368,fast::clamp(l9_1370,0.0,1.0));
}
}
l9_1350.y=l9_1366;
if (l9_1354)
{
bool l9_1371=l9_1356;
bool l9_1372;
if (l9_1371)
{
l9_1372=l9_1353.x==3;
}
else
{
l9_1372=l9_1371;
}
float l9_1373=l9_1350.x;
float l9_1374=l9_1355.x;
float l9_1375=l9_1355.z;
bool l9_1376=l9_1372;
float l9_1377=l9_1360;
float l9_1378=fast::clamp(l9_1373,l9_1374,l9_1375);
float l9_1379=step(abs(l9_1373-l9_1378),9.9999997e-06);
l9_1377*=(l9_1379+((1.0-float(l9_1376))*(1.0-l9_1379)));
l9_1373=l9_1378;
l9_1350.x=l9_1373;
l9_1360=l9_1377;
bool l9_1380=l9_1356;
bool l9_1381;
if (l9_1380)
{
l9_1381=l9_1353.y==3;
}
else
{
l9_1381=l9_1380;
}
float l9_1382=l9_1350.y;
float l9_1383=l9_1355.y;
float l9_1384=l9_1355.w;
bool l9_1385=l9_1381;
float l9_1386=l9_1360;
float l9_1387=fast::clamp(l9_1382,l9_1383,l9_1384);
float l9_1388=step(abs(l9_1382-l9_1387),9.9999997e-06);
l9_1386*=(l9_1388+((1.0-float(l9_1385))*(1.0-l9_1388)));
l9_1382=l9_1387;
l9_1350.y=l9_1382;
l9_1360=l9_1386;
}
float2 l9_1389=l9_1350;
bool l9_1390=l9_1351;
float3x3 l9_1391=l9_1352;
if (l9_1390)
{
l9_1389=float2((l9_1391*float3(l9_1389,1.0)).xy);
}
float2 l9_1392=l9_1389;
l9_1350=l9_1392;
float l9_1393=l9_1350.x;
int l9_1394=l9_1353.x;
bool l9_1395=l9_1359;
float l9_1396=l9_1360;
if ((l9_1394==0)||(l9_1394==3))
{
float l9_1397=l9_1393;
float l9_1398=0.0;
float l9_1399=1.0;
bool l9_1400=l9_1395;
float l9_1401=l9_1396;
float l9_1402=fast::clamp(l9_1397,l9_1398,l9_1399);
float l9_1403=step(abs(l9_1397-l9_1402),9.9999997e-06);
l9_1401*=(l9_1403+((1.0-float(l9_1400))*(1.0-l9_1403)));
l9_1397=l9_1402;
l9_1393=l9_1397;
l9_1396=l9_1401;
}
l9_1350.x=l9_1393;
l9_1360=l9_1396;
float l9_1404=l9_1350.y;
int l9_1405=l9_1353.y;
bool l9_1406=l9_1359;
float l9_1407=l9_1360;
if ((l9_1405==0)||(l9_1405==3))
{
float l9_1408=l9_1404;
float l9_1409=0.0;
float l9_1410=1.0;
bool l9_1411=l9_1406;
float l9_1412=l9_1407;
float l9_1413=fast::clamp(l9_1408,l9_1409,l9_1410);
float l9_1414=step(abs(l9_1408-l9_1413),9.9999997e-06);
l9_1412*=(l9_1414+((1.0-float(l9_1411))*(1.0-l9_1414)));
l9_1408=l9_1413;
l9_1404=l9_1408;
l9_1407=l9_1412;
}
l9_1350.y=l9_1404;
l9_1360=l9_1407;
float2 l9_1415=l9_1350;
int l9_1416=l9_1348;
int l9_1417=l9_1349;
float l9_1418=l9_1358;
float2 l9_1419=l9_1415;
int l9_1420=l9_1416;
int l9_1421=l9_1417;
float3 l9_1422=float3(0.0);
if (l9_1420==0)
{
l9_1422=float3(l9_1419,0.0);
}
else
{
if (l9_1420==1)
{
l9_1422=float3(l9_1419.x,(l9_1419.y*0.5)+(0.5-(float(l9_1421)*0.5)),0.0);
}
else
{
l9_1422=float3(l9_1419,float(l9_1421));
}
}
float3 l9_1423=l9_1422;
float3 l9_1424=l9_1423;
float4 l9_1425=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_1424.xy,bias(l9_1418));
float4 l9_1426=l9_1425;
if (l9_1356)
{
l9_1426=mix(l9_1357,l9_1426,float4(l9_1360));
}
float4 l9_1427=l9_1426;
l9_1341=l9_1427;
float4 l9_1428=float4(0.0);
float4 l9_1429=l9_1341;
float4 l9_1430=float4(0.0);
N16_Value1=l9_1429;
float3 l9_1431=N16_Value1.xyz/float3(N16_Value1.w);
N16_Result=float4(l9_1431.x,l9_1431.y,l9_1431.z,N16_Result.w);
N16_Result.w=1.0;
l9_1430=N16_Result;
l9_1428=l9_1430;
float4 l9_1432=float4(0.0);
float3 l9_1433=l9_1428.xyz;
float l9_1434=1.8;
float l9_1435=1.4;
float l9_1436=0.5;
float l9_1437=1.5;
float3 l9_1438=(l9_1433*((l9_1433*l9_1434)+float3(l9_1435)))/((l9_1433*((l9_1433*l9_1434)+float3(l9_1436)))+float3(l9_1437));
l9_1432=float4(l9_1438,l9_1428.w);
float4 l9_1439=float4(0.0);
float4 l9_1440=l9_1432;
float4 l9_1441;
if (SC_DEVICE_CLASS_tmp>=2)
{
l9_1441=float4(pow(l9_1440.x,0.45454544),pow(l9_1440.y,0.45454544),pow(l9_1440.z,0.45454544),pow(l9_1440.w,0.45454544));
}
else
{
l9_1441=sqrt(l9_1440);
}
float4 l9_1442=l9_1441;
l9_1439=l9_1442;
l9_1333=l9_1439;
l9_1338=l9_1333;
}
else
{
float2 l9_1443=float2(0.0);
l9_1443=l9_1335.Surface_UVCoord0;
float2 l9_1444=float2(0.0);
l9_1444=l9_1443*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_1445=float4(0.0);
int l9_1446;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_1447=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1447=0;
}
else
{
l9_1447=in.varStereoViewID;
}
int l9_1448=l9_1447;
l9_1446=1-l9_1448;
}
else
{
int l9_1449=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1449=0;
}
else
{
l9_1449=in.varStereoViewID;
}
int l9_1450=l9_1449;
l9_1446=l9_1450;
}
int l9_1451=l9_1446;
int l9_1452=baseTexLayout_tmp;
int l9_1453=l9_1451;
float2 l9_1454=l9_1444;
bool l9_1455=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_1456=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_1457=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_1458=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_1459=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_1460=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_1461=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_1462=0.0;
bool l9_1463=l9_1460&&(!l9_1458);
float l9_1464=1.0;
float l9_1465=l9_1454.x;
int l9_1466=l9_1457.x;
if (l9_1466==1)
{
l9_1465=fract(l9_1465);
}
else
{
if (l9_1466==2)
{
float l9_1467=fract(l9_1465);
float l9_1468=l9_1465-l9_1467;
float l9_1469=step(0.25,fract(l9_1468*0.5));
l9_1465=mix(l9_1467,1.0-l9_1467,fast::clamp(l9_1469,0.0,1.0));
}
}
l9_1454.x=l9_1465;
float l9_1470=l9_1454.y;
int l9_1471=l9_1457.y;
if (l9_1471==1)
{
l9_1470=fract(l9_1470);
}
else
{
if (l9_1471==2)
{
float l9_1472=fract(l9_1470);
float l9_1473=l9_1470-l9_1472;
float l9_1474=step(0.25,fract(l9_1473*0.5));
l9_1470=mix(l9_1472,1.0-l9_1472,fast::clamp(l9_1474,0.0,1.0));
}
}
l9_1454.y=l9_1470;
if (l9_1458)
{
bool l9_1475=l9_1460;
bool l9_1476;
if (l9_1475)
{
l9_1476=l9_1457.x==3;
}
else
{
l9_1476=l9_1475;
}
float l9_1477=l9_1454.x;
float l9_1478=l9_1459.x;
float l9_1479=l9_1459.z;
bool l9_1480=l9_1476;
float l9_1481=l9_1464;
float l9_1482=fast::clamp(l9_1477,l9_1478,l9_1479);
float l9_1483=step(abs(l9_1477-l9_1482),9.9999997e-06);
l9_1481*=(l9_1483+((1.0-float(l9_1480))*(1.0-l9_1483)));
l9_1477=l9_1482;
l9_1454.x=l9_1477;
l9_1464=l9_1481;
bool l9_1484=l9_1460;
bool l9_1485;
if (l9_1484)
{
l9_1485=l9_1457.y==3;
}
else
{
l9_1485=l9_1484;
}
float l9_1486=l9_1454.y;
float l9_1487=l9_1459.y;
float l9_1488=l9_1459.w;
bool l9_1489=l9_1485;
float l9_1490=l9_1464;
float l9_1491=fast::clamp(l9_1486,l9_1487,l9_1488);
float l9_1492=step(abs(l9_1486-l9_1491),9.9999997e-06);
l9_1490*=(l9_1492+((1.0-float(l9_1489))*(1.0-l9_1492)));
l9_1486=l9_1491;
l9_1454.y=l9_1486;
l9_1464=l9_1490;
}
float2 l9_1493=l9_1454;
bool l9_1494=l9_1455;
float3x3 l9_1495=l9_1456;
if (l9_1494)
{
l9_1493=float2((l9_1495*float3(l9_1493,1.0)).xy);
}
float2 l9_1496=l9_1493;
l9_1454=l9_1496;
float l9_1497=l9_1454.x;
int l9_1498=l9_1457.x;
bool l9_1499=l9_1463;
float l9_1500=l9_1464;
if ((l9_1498==0)||(l9_1498==3))
{
float l9_1501=l9_1497;
float l9_1502=0.0;
float l9_1503=1.0;
bool l9_1504=l9_1499;
float l9_1505=l9_1500;
float l9_1506=fast::clamp(l9_1501,l9_1502,l9_1503);
float l9_1507=step(abs(l9_1501-l9_1506),9.9999997e-06);
l9_1505*=(l9_1507+((1.0-float(l9_1504))*(1.0-l9_1507)));
l9_1501=l9_1506;
l9_1497=l9_1501;
l9_1500=l9_1505;
}
l9_1454.x=l9_1497;
l9_1464=l9_1500;
float l9_1508=l9_1454.y;
int l9_1509=l9_1457.y;
bool l9_1510=l9_1463;
float l9_1511=l9_1464;
if ((l9_1509==0)||(l9_1509==3))
{
float l9_1512=l9_1508;
float l9_1513=0.0;
float l9_1514=1.0;
bool l9_1515=l9_1510;
float l9_1516=l9_1511;
float l9_1517=fast::clamp(l9_1512,l9_1513,l9_1514);
float l9_1518=step(abs(l9_1512-l9_1517),9.9999997e-06);
l9_1516*=(l9_1518+((1.0-float(l9_1515))*(1.0-l9_1518)));
l9_1512=l9_1517;
l9_1508=l9_1512;
l9_1511=l9_1516;
}
l9_1454.y=l9_1508;
l9_1464=l9_1511;
float2 l9_1519=l9_1454;
int l9_1520=l9_1452;
int l9_1521=l9_1453;
float l9_1522=l9_1462;
float2 l9_1523=l9_1519;
int l9_1524=l9_1520;
int l9_1525=l9_1521;
float3 l9_1526=float3(0.0);
if (l9_1524==0)
{
l9_1526=float3(l9_1523,0.0);
}
else
{
if (l9_1524==1)
{
l9_1526=float3(l9_1523.x,(l9_1523.y*0.5)+(0.5-(float(l9_1525)*0.5)),0.0);
}
else
{
l9_1526=float3(l9_1523,float(l9_1525));
}
}
float3 l9_1527=l9_1526;
float3 l9_1528=l9_1527;
float4 l9_1529=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_1528.xy,bias(l9_1522));
float4 l9_1530=l9_1529;
if (l9_1460)
{
l9_1530=mix(l9_1461,l9_1530,float4(l9_1464));
}
float4 l9_1531=l9_1530;
l9_1445=l9_1531;
l9_1334=l9_1445;
l9_1338=l9_1334;
}
l9_1331=l9_1338;
float l9_1532=0.0;
float4 l9_1533=l9_1331;
float l9_1534=l9_1533.w;
l9_1532=l9_1534;
l9_1325=l9_1532;
l9_1330=l9_1325;
}
l9_1322=l9_1330;
float4 l9_1535=float4(0.0);
l9_1535.x=l9_1319;
l9_1535.y=l9_1319;
l9_1535.z=l9_1319;
l9_1535.w=l9_1322;
l9_1111=l9_1535;
l9_1117=l9_1111;
}
else
{
float4 l9_1536=float4(0.0);
float l9_1537=0.0;
float4 l9_1538=float4(0.0);
float4 l9_1539=(*sc_set0.UserUniforms).Port_Default_N055;
ssGlobals l9_1540=l9_1113;
float l9_1541=0.0;
float l9_1542=float((*sc_set0.UserUniforms).blue_channel!=0);
l9_1541=l9_1542;
float l9_1543=0.0;
l9_1543=float(l9_1541==(*sc_set0.UserUniforms).Port_Input1_N053);
l9_1537=l9_1543;
float4 l9_1544;
if ((l9_1537*1.0)!=0.0)
{
float4 l9_1545=float4(0.0);
float l9_1546=0.0;
float4 l9_1547=float4(0.0);
float4 l9_1548=float4(0.0);
ssGlobals l9_1549=l9_1540;
float l9_1550=0.0;
float l9_1551=float((*sc_set0.UserUniforms).envmap_preview!=0);
l9_1550=l9_1551;
l9_1546=l9_1550;
float4 l9_1552;
if ((l9_1546*1.0)!=0.0)
{
float2 l9_1553=float2(0.0);
l9_1553=l9_1549.Surface_UVCoord0;
float2 l9_1554=float2(0.0);
l9_1554=l9_1553*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_1555=float4(0.0);
int l9_1556;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_1557=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1557=0;
}
else
{
l9_1557=in.varStereoViewID;
}
int l9_1558=l9_1557;
l9_1556=1-l9_1558;
}
else
{
int l9_1559=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1559=0;
}
else
{
l9_1559=in.varStereoViewID;
}
int l9_1560=l9_1559;
l9_1556=l9_1560;
}
int l9_1561=l9_1556;
int l9_1562=baseTexLayout_tmp;
int l9_1563=l9_1561;
float2 l9_1564=l9_1554;
bool l9_1565=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_1566=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_1567=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_1568=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_1569=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_1570=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_1571=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_1572=0.0;
bool l9_1573=l9_1570&&(!l9_1568);
float l9_1574=1.0;
float l9_1575=l9_1564.x;
int l9_1576=l9_1567.x;
if (l9_1576==1)
{
l9_1575=fract(l9_1575);
}
else
{
if (l9_1576==2)
{
float l9_1577=fract(l9_1575);
float l9_1578=l9_1575-l9_1577;
float l9_1579=step(0.25,fract(l9_1578*0.5));
l9_1575=mix(l9_1577,1.0-l9_1577,fast::clamp(l9_1579,0.0,1.0));
}
}
l9_1564.x=l9_1575;
float l9_1580=l9_1564.y;
int l9_1581=l9_1567.y;
if (l9_1581==1)
{
l9_1580=fract(l9_1580);
}
else
{
if (l9_1581==2)
{
float l9_1582=fract(l9_1580);
float l9_1583=l9_1580-l9_1582;
float l9_1584=step(0.25,fract(l9_1583*0.5));
l9_1580=mix(l9_1582,1.0-l9_1582,fast::clamp(l9_1584,0.0,1.0));
}
}
l9_1564.y=l9_1580;
if (l9_1568)
{
bool l9_1585=l9_1570;
bool l9_1586;
if (l9_1585)
{
l9_1586=l9_1567.x==3;
}
else
{
l9_1586=l9_1585;
}
float l9_1587=l9_1564.x;
float l9_1588=l9_1569.x;
float l9_1589=l9_1569.z;
bool l9_1590=l9_1586;
float l9_1591=l9_1574;
float l9_1592=fast::clamp(l9_1587,l9_1588,l9_1589);
float l9_1593=step(abs(l9_1587-l9_1592),9.9999997e-06);
l9_1591*=(l9_1593+((1.0-float(l9_1590))*(1.0-l9_1593)));
l9_1587=l9_1592;
l9_1564.x=l9_1587;
l9_1574=l9_1591;
bool l9_1594=l9_1570;
bool l9_1595;
if (l9_1594)
{
l9_1595=l9_1567.y==3;
}
else
{
l9_1595=l9_1594;
}
float l9_1596=l9_1564.y;
float l9_1597=l9_1569.y;
float l9_1598=l9_1569.w;
bool l9_1599=l9_1595;
float l9_1600=l9_1574;
float l9_1601=fast::clamp(l9_1596,l9_1597,l9_1598);
float l9_1602=step(abs(l9_1596-l9_1601),9.9999997e-06);
l9_1600*=(l9_1602+((1.0-float(l9_1599))*(1.0-l9_1602)));
l9_1596=l9_1601;
l9_1564.y=l9_1596;
l9_1574=l9_1600;
}
float2 l9_1603=l9_1564;
bool l9_1604=l9_1565;
float3x3 l9_1605=l9_1566;
if (l9_1604)
{
l9_1603=float2((l9_1605*float3(l9_1603,1.0)).xy);
}
float2 l9_1606=l9_1603;
l9_1564=l9_1606;
float l9_1607=l9_1564.x;
int l9_1608=l9_1567.x;
bool l9_1609=l9_1573;
float l9_1610=l9_1574;
if ((l9_1608==0)||(l9_1608==3))
{
float l9_1611=l9_1607;
float l9_1612=0.0;
float l9_1613=1.0;
bool l9_1614=l9_1609;
float l9_1615=l9_1610;
float l9_1616=fast::clamp(l9_1611,l9_1612,l9_1613);
float l9_1617=step(abs(l9_1611-l9_1616),9.9999997e-06);
l9_1615*=(l9_1617+((1.0-float(l9_1614))*(1.0-l9_1617)));
l9_1611=l9_1616;
l9_1607=l9_1611;
l9_1610=l9_1615;
}
l9_1564.x=l9_1607;
l9_1574=l9_1610;
float l9_1618=l9_1564.y;
int l9_1619=l9_1567.y;
bool l9_1620=l9_1573;
float l9_1621=l9_1574;
if ((l9_1619==0)||(l9_1619==3))
{
float l9_1622=l9_1618;
float l9_1623=0.0;
float l9_1624=1.0;
bool l9_1625=l9_1620;
float l9_1626=l9_1621;
float l9_1627=fast::clamp(l9_1622,l9_1623,l9_1624);
float l9_1628=step(abs(l9_1622-l9_1627),9.9999997e-06);
l9_1626*=(l9_1628+((1.0-float(l9_1625))*(1.0-l9_1628)));
l9_1622=l9_1627;
l9_1618=l9_1622;
l9_1621=l9_1626;
}
l9_1564.y=l9_1618;
l9_1574=l9_1621;
float2 l9_1629=l9_1564;
int l9_1630=l9_1562;
int l9_1631=l9_1563;
float l9_1632=l9_1572;
float2 l9_1633=l9_1629;
int l9_1634=l9_1630;
int l9_1635=l9_1631;
float3 l9_1636=float3(0.0);
if (l9_1634==0)
{
l9_1636=float3(l9_1633,0.0);
}
else
{
if (l9_1634==1)
{
l9_1636=float3(l9_1633.x,(l9_1633.y*0.5)+(0.5-(float(l9_1635)*0.5)),0.0);
}
else
{
l9_1636=float3(l9_1633,float(l9_1635));
}
}
float3 l9_1637=l9_1636;
float3 l9_1638=l9_1637;
float4 l9_1639=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_1638.xy,bias(l9_1632));
float4 l9_1640=l9_1639;
if (l9_1570)
{
l9_1640=mix(l9_1571,l9_1640,float4(l9_1574));
}
float4 l9_1641=l9_1640;
l9_1555=l9_1641;
float4 l9_1642=float4(0.0);
float4 l9_1643=l9_1555;
float4 l9_1644=float4(0.0);
N16_Value1=l9_1643;
float3 l9_1645=N16_Value1.xyz/float3(N16_Value1.w);
N16_Result=float4(l9_1645.x,l9_1645.y,l9_1645.z,N16_Result.w);
N16_Result.w=1.0;
l9_1644=N16_Result;
l9_1642=l9_1644;
float4 l9_1646=float4(0.0);
float3 l9_1647=l9_1642.xyz;
float l9_1648=1.8;
float l9_1649=1.4;
float l9_1650=0.5;
float l9_1651=1.5;
float3 l9_1652=(l9_1647*((l9_1647*l9_1648)+float3(l9_1649)))/((l9_1647*((l9_1647*l9_1648)+float3(l9_1650)))+float3(l9_1651));
l9_1646=float4(l9_1652,l9_1642.w);
float4 l9_1653=float4(0.0);
float4 l9_1654=l9_1646;
float4 l9_1655;
if (SC_DEVICE_CLASS_tmp>=2)
{
l9_1655=float4(pow(l9_1654.x,0.45454544),pow(l9_1654.y,0.45454544),pow(l9_1654.z,0.45454544),pow(l9_1654.w,0.45454544));
}
else
{
l9_1655=sqrt(l9_1654);
}
float4 l9_1656=l9_1655;
l9_1653=l9_1656;
l9_1547=l9_1653;
l9_1552=l9_1547;
}
else
{
float2 l9_1657=float2(0.0);
l9_1657=l9_1549.Surface_UVCoord0;
float2 l9_1658=float2(0.0);
l9_1658=l9_1657*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_1659=float4(0.0);
int l9_1660;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_1661=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1661=0;
}
else
{
l9_1661=in.varStereoViewID;
}
int l9_1662=l9_1661;
l9_1660=1-l9_1662;
}
else
{
int l9_1663=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1663=0;
}
else
{
l9_1663=in.varStereoViewID;
}
int l9_1664=l9_1663;
l9_1660=l9_1664;
}
int l9_1665=l9_1660;
int l9_1666=baseTexLayout_tmp;
int l9_1667=l9_1665;
float2 l9_1668=l9_1658;
bool l9_1669=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_1670=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_1671=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_1672=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_1673=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_1674=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_1675=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_1676=0.0;
bool l9_1677=l9_1674&&(!l9_1672);
float l9_1678=1.0;
float l9_1679=l9_1668.x;
int l9_1680=l9_1671.x;
if (l9_1680==1)
{
l9_1679=fract(l9_1679);
}
else
{
if (l9_1680==2)
{
float l9_1681=fract(l9_1679);
float l9_1682=l9_1679-l9_1681;
float l9_1683=step(0.25,fract(l9_1682*0.5));
l9_1679=mix(l9_1681,1.0-l9_1681,fast::clamp(l9_1683,0.0,1.0));
}
}
l9_1668.x=l9_1679;
float l9_1684=l9_1668.y;
int l9_1685=l9_1671.y;
if (l9_1685==1)
{
l9_1684=fract(l9_1684);
}
else
{
if (l9_1685==2)
{
float l9_1686=fract(l9_1684);
float l9_1687=l9_1684-l9_1686;
float l9_1688=step(0.25,fract(l9_1687*0.5));
l9_1684=mix(l9_1686,1.0-l9_1686,fast::clamp(l9_1688,0.0,1.0));
}
}
l9_1668.y=l9_1684;
if (l9_1672)
{
bool l9_1689=l9_1674;
bool l9_1690;
if (l9_1689)
{
l9_1690=l9_1671.x==3;
}
else
{
l9_1690=l9_1689;
}
float l9_1691=l9_1668.x;
float l9_1692=l9_1673.x;
float l9_1693=l9_1673.z;
bool l9_1694=l9_1690;
float l9_1695=l9_1678;
float l9_1696=fast::clamp(l9_1691,l9_1692,l9_1693);
float l9_1697=step(abs(l9_1691-l9_1696),9.9999997e-06);
l9_1695*=(l9_1697+((1.0-float(l9_1694))*(1.0-l9_1697)));
l9_1691=l9_1696;
l9_1668.x=l9_1691;
l9_1678=l9_1695;
bool l9_1698=l9_1674;
bool l9_1699;
if (l9_1698)
{
l9_1699=l9_1671.y==3;
}
else
{
l9_1699=l9_1698;
}
float l9_1700=l9_1668.y;
float l9_1701=l9_1673.y;
float l9_1702=l9_1673.w;
bool l9_1703=l9_1699;
float l9_1704=l9_1678;
float l9_1705=fast::clamp(l9_1700,l9_1701,l9_1702);
float l9_1706=step(abs(l9_1700-l9_1705),9.9999997e-06);
l9_1704*=(l9_1706+((1.0-float(l9_1703))*(1.0-l9_1706)));
l9_1700=l9_1705;
l9_1668.y=l9_1700;
l9_1678=l9_1704;
}
float2 l9_1707=l9_1668;
bool l9_1708=l9_1669;
float3x3 l9_1709=l9_1670;
if (l9_1708)
{
l9_1707=float2((l9_1709*float3(l9_1707,1.0)).xy);
}
float2 l9_1710=l9_1707;
l9_1668=l9_1710;
float l9_1711=l9_1668.x;
int l9_1712=l9_1671.x;
bool l9_1713=l9_1677;
float l9_1714=l9_1678;
if ((l9_1712==0)||(l9_1712==3))
{
float l9_1715=l9_1711;
float l9_1716=0.0;
float l9_1717=1.0;
bool l9_1718=l9_1713;
float l9_1719=l9_1714;
float l9_1720=fast::clamp(l9_1715,l9_1716,l9_1717);
float l9_1721=step(abs(l9_1715-l9_1720),9.9999997e-06);
l9_1719*=(l9_1721+((1.0-float(l9_1718))*(1.0-l9_1721)));
l9_1715=l9_1720;
l9_1711=l9_1715;
l9_1714=l9_1719;
}
l9_1668.x=l9_1711;
l9_1678=l9_1714;
float l9_1722=l9_1668.y;
int l9_1723=l9_1671.y;
bool l9_1724=l9_1677;
float l9_1725=l9_1678;
if ((l9_1723==0)||(l9_1723==3))
{
float l9_1726=l9_1722;
float l9_1727=0.0;
float l9_1728=1.0;
bool l9_1729=l9_1724;
float l9_1730=l9_1725;
float l9_1731=fast::clamp(l9_1726,l9_1727,l9_1728);
float l9_1732=step(abs(l9_1726-l9_1731),9.9999997e-06);
l9_1730*=(l9_1732+((1.0-float(l9_1729))*(1.0-l9_1732)));
l9_1726=l9_1731;
l9_1722=l9_1726;
l9_1725=l9_1730;
}
l9_1668.y=l9_1722;
l9_1678=l9_1725;
float2 l9_1733=l9_1668;
int l9_1734=l9_1666;
int l9_1735=l9_1667;
float l9_1736=l9_1676;
float2 l9_1737=l9_1733;
int l9_1738=l9_1734;
int l9_1739=l9_1735;
float3 l9_1740=float3(0.0);
if (l9_1738==0)
{
l9_1740=float3(l9_1737,0.0);
}
else
{
if (l9_1738==1)
{
l9_1740=float3(l9_1737.x,(l9_1737.y*0.5)+(0.5-(float(l9_1739)*0.5)),0.0);
}
else
{
l9_1740=float3(l9_1737,float(l9_1739));
}
}
float3 l9_1741=l9_1740;
float3 l9_1742=l9_1741;
float4 l9_1743=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_1742.xy,bias(l9_1736));
float4 l9_1744=l9_1743;
if (l9_1674)
{
l9_1744=mix(l9_1675,l9_1744,float4(l9_1678));
}
float4 l9_1745=l9_1744;
l9_1659=l9_1745;
l9_1548=l9_1659;
l9_1552=l9_1548;
}
l9_1545=l9_1552;
float l9_1746=0.0;
float4 l9_1747=l9_1545;
float l9_1748=l9_1747.z;
l9_1746=l9_1748;
float l9_1749=0.0;
float l9_1750=0.0;
float l9_1751=(*sc_set0.UserUniforms).Port_Value1_N043;
float l9_1752=0.0;
ssGlobals l9_1753=l9_1540;
float l9_1754=0.0;
float l9_1755=float((*sc_set0.UserUniforms).alpha_channel!=0);
l9_1754=l9_1755;
float l9_1756=0.0;
l9_1756=float(l9_1754==(*sc_set0.UserUniforms).Port_Input1_N034);
l9_1750=l9_1756;
float l9_1757;
if ((l9_1750*1.0)!=0.0)
{
l9_1757=l9_1751;
}
else
{
float4 l9_1758=float4(0.0);
float l9_1759=0.0;
float4 l9_1760=float4(0.0);
float4 l9_1761=float4(0.0);
ssGlobals l9_1762=l9_1753;
float l9_1763=0.0;
float l9_1764=float((*sc_set0.UserUniforms).envmap_preview!=0);
l9_1763=l9_1764;
l9_1759=l9_1763;
float4 l9_1765;
if ((l9_1759*1.0)!=0.0)
{
float2 l9_1766=float2(0.0);
l9_1766=l9_1762.Surface_UVCoord0;
float2 l9_1767=float2(0.0);
l9_1767=l9_1766*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_1768=float4(0.0);
int l9_1769;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_1770=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1770=0;
}
else
{
l9_1770=in.varStereoViewID;
}
int l9_1771=l9_1770;
l9_1769=1-l9_1771;
}
else
{
int l9_1772=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1772=0;
}
else
{
l9_1772=in.varStereoViewID;
}
int l9_1773=l9_1772;
l9_1769=l9_1773;
}
int l9_1774=l9_1769;
int l9_1775=baseTexLayout_tmp;
int l9_1776=l9_1774;
float2 l9_1777=l9_1767;
bool l9_1778=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_1779=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_1780=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_1781=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_1782=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_1783=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_1784=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_1785=0.0;
bool l9_1786=l9_1783&&(!l9_1781);
float l9_1787=1.0;
float l9_1788=l9_1777.x;
int l9_1789=l9_1780.x;
if (l9_1789==1)
{
l9_1788=fract(l9_1788);
}
else
{
if (l9_1789==2)
{
float l9_1790=fract(l9_1788);
float l9_1791=l9_1788-l9_1790;
float l9_1792=step(0.25,fract(l9_1791*0.5));
l9_1788=mix(l9_1790,1.0-l9_1790,fast::clamp(l9_1792,0.0,1.0));
}
}
l9_1777.x=l9_1788;
float l9_1793=l9_1777.y;
int l9_1794=l9_1780.y;
if (l9_1794==1)
{
l9_1793=fract(l9_1793);
}
else
{
if (l9_1794==2)
{
float l9_1795=fract(l9_1793);
float l9_1796=l9_1793-l9_1795;
float l9_1797=step(0.25,fract(l9_1796*0.5));
l9_1793=mix(l9_1795,1.0-l9_1795,fast::clamp(l9_1797,0.0,1.0));
}
}
l9_1777.y=l9_1793;
if (l9_1781)
{
bool l9_1798=l9_1783;
bool l9_1799;
if (l9_1798)
{
l9_1799=l9_1780.x==3;
}
else
{
l9_1799=l9_1798;
}
float l9_1800=l9_1777.x;
float l9_1801=l9_1782.x;
float l9_1802=l9_1782.z;
bool l9_1803=l9_1799;
float l9_1804=l9_1787;
float l9_1805=fast::clamp(l9_1800,l9_1801,l9_1802);
float l9_1806=step(abs(l9_1800-l9_1805),9.9999997e-06);
l9_1804*=(l9_1806+((1.0-float(l9_1803))*(1.0-l9_1806)));
l9_1800=l9_1805;
l9_1777.x=l9_1800;
l9_1787=l9_1804;
bool l9_1807=l9_1783;
bool l9_1808;
if (l9_1807)
{
l9_1808=l9_1780.y==3;
}
else
{
l9_1808=l9_1807;
}
float l9_1809=l9_1777.y;
float l9_1810=l9_1782.y;
float l9_1811=l9_1782.w;
bool l9_1812=l9_1808;
float l9_1813=l9_1787;
float l9_1814=fast::clamp(l9_1809,l9_1810,l9_1811);
float l9_1815=step(abs(l9_1809-l9_1814),9.9999997e-06);
l9_1813*=(l9_1815+((1.0-float(l9_1812))*(1.0-l9_1815)));
l9_1809=l9_1814;
l9_1777.y=l9_1809;
l9_1787=l9_1813;
}
float2 l9_1816=l9_1777;
bool l9_1817=l9_1778;
float3x3 l9_1818=l9_1779;
if (l9_1817)
{
l9_1816=float2((l9_1818*float3(l9_1816,1.0)).xy);
}
float2 l9_1819=l9_1816;
l9_1777=l9_1819;
float l9_1820=l9_1777.x;
int l9_1821=l9_1780.x;
bool l9_1822=l9_1786;
float l9_1823=l9_1787;
if ((l9_1821==0)||(l9_1821==3))
{
float l9_1824=l9_1820;
float l9_1825=0.0;
float l9_1826=1.0;
bool l9_1827=l9_1822;
float l9_1828=l9_1823;
float l9_1829=fast::clamp(l9_1824,l9_1825,l9_1826);
float l9_1830=step(abs(l9_1824-l9_1829),9.9999997e-06);
l9_1828*=(l9_1830+((1.0-float(l9_1827))*(1.0-l9_1830)));
l9_1824=l9_1829;
l9_1820=l9_1824;
l9_1823=l9_1828;
}
l9_1777.x=l9_1820;
l9_1787=l9_1823;
float l9_1831=l9_1777.y;
int l9_1832=l9_1780.y;
bool l9_1833=l9_1786;
float l9_1834=l9_1787;
if ((l9_1832==0)||(l9_1832==3))
{
float l9_1835=l9_1831;
float l9_1836=0.0;
float l9_1837=1.0;
bool l9_1838=l9_1833;
float l9_1839=l9_1834;
float l9_1840=fast::clamp(l9_1835,l9_1836,l9_1837);
float l9_1841=step(abs(l9_1835-l9_1840),9.9999997e-06);
l9_1839*=(l9_1841+((1.0-float(l9_1838))*(1.0-l9_1841)));
l9_1835=l9_1840;
l9_1831=l9_1835;
l9_1834=l9_1839;
}
l9_1777.y=l9_1831;
l9_1787=l9_1834;
float2 l9_1842=l9_1777;
int l9_1843=l9_1775;
int l9_1844=l9_1776;
float l9_1845=l9_1785;
float2 l9_1846=l9_1842;
int l9_1847=l9_1843;
int l9_1848=l9_1844;
float3 l9_1849=float3(0.0);
if (l9_1847==0)
{
l9_1849=float3(l9_1846,0.0);
}
else
{
if (l9_1847==1)
{
l9_1849=float3(l9_1846.x,(l9_1846.y*0.5)+(0.5-(float(l9_1848)*0.5)),0.0);
}
else
{
l9_1849=float3(l9_1846,float(l9_1848));
}
}
float3 l9_1850=l9_1849;
float3 l9_1851=l9_1850;
float4 l9_1852=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_1851.xy,bias(l9_1845));
float4 l9_1853=l9_1852;
if (l9_1783)
{
l9_1853=mix(l9_1784,l9_1853,float4(l9_1787));
}
float4 l9_1854=l9_1853;
l9_1768=l9_1854;
float4 l9_1855=float4(0.0);
float4 l9_1856=l9_1768;
float4 l9_1857=float4(0.0);
N16_Value1=l9_1856;
float3 l9_1858=N16_Value1.xyz/float3(N16_Value1.w);
N16_Result=float4(l9_1858.x,l9_1858.y,l9_1858.z,N16_Result.w);
N16_Result.w=1.0;
l9_1857=N16_Result;
l9_1855=l9_1857;
float4 l9_1859=float4(0.0);
float3 l9_1860=l9_1855.xyz;
float l9_1861=1.8;
float l9_1862=1.4;
float l9_1863=0.5;
float l9_1864=1.5;
float3 l9_1865=(l9_1860*((l9_1860*l9_1861)+float3(l9_1862)))/((l9_1860*((l9_1860*l9_1861)+float3(l9_1863)))+float3(l9_1864));
l9_1859=float4(l9_1865,l9_1855.w);
float4 l9_1866=float4(0.0);
float4 l9_1867=l9_1859;
float4 l9_1868;
if (SC_DEVICE_CLASS_tmp>=2)
{
l9_1868=float4(pow(l9_1867.x,0.45454544),pow(l9_1867.y,0.45454544),pow(l9_1867.z,0.45454544),pow(l9_1867.w,0.45454544));
}
else
{
l9_1868=sqrt(l9_1867);
}
float4 l9_1869=l9_1868;
l9_1866=l9_1869;
l9_1760=l9_1866;
l9_1765=l9_1760;
}
else
{
float2 l9_1870=float2(0.0);
l9_1870=l9_1762.Surface_UVCoord0;
float2 l9_1871=float2(0.0);
l9_1871=l9_1870*(*sc_set0.UserUniforms).Port_Input1_N057;
float4 l9_1872=float4(0.0);
int l9_1873;
if ((int(baseTexHasSwappedViews_tmp)!=0))
{
int l9_1874=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1874=0;
}
else
{
l9_1874=in.varStereoViewID;
}
int l9_1875=l9_1874;
l9_1873=1-l9_1875;
}
else
{
int l9_1876=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1876=0;
}
else
{
l9_1876=in.varStereoViewID;
}
int l9_1877=l9_1876;
l9_1873=l9_1877;
}
int l9_1878=l9_1873;
int l9_1879=baseTexLayout_tmp;
int l9_1880=l9_1878;
float2 l9_1881=l9_1871;
bool l9_1882=(int(SC_USE_UV_TRANSFORM_baseTex_tmp)!=0);
float3x3 l9_1883=(*sc_set0.UserUniforms).baseTexTransform;
int2 l9_1884=int2(SC_SOFTWARE_WRAP_MODE_U_baseTex_tmp,SC_SOFTWARE_WRAP_MODE_V_baseTex_tmp);
bool l9_1885=(int(SC_USE_UV_MIN_MAX_baseTex_tmp)!=0);
float4 l9_1886=(*sc_set0.UserUniforms).baseTexUvMinMax;
bool l9_1887=(int(SC_USE_CLAMP_TO_BORDER_baseTex_tmp)!=0);
float4 l9_1888=(*sc_set0.UserUniforms).baseTexBorderColor;
float l9_1889=0.0;
bool l9_1890=l9_1887&&(!l9_1885);
float l9_1891=1.0;
float l9_1892=l9_1881.x;
int l9_1893=l9_1884.x;
if (l9_1893==1)
{
l9_1892=fract(l9_1892);
}
else
{
if (l9_1893==2)
{
float l9_1894=fract(l9_1892);
float l9_1895=l9_1892-l9_1894;
float l9_1896=step(0.25,fract(l9_1895*0.5));
l9_1892=mix(l9_1894,1.0-l9_1894,fast::clamp(l9_1896,0.0,1.0));
}
}
l9_1881.x=l9_1892;
float l9_1897=l9_1881.y;
int l9_1898=l9_1884.y;
if (l9_1898==1)
{
l9_1897=fract(l9_1897);
}
else
{
if (l9_1898==2)
{
float l9_1899=fract(l9_1897);
float l9_1900=l9_1897-l9_1899;
float l9_1901=step(0.25,fract(l9_1900*0.5));
l9_1897=mix(l9_1899,1.0-l9_1899,fast::clamp(l9_1901,0.0,1.0));
}
}
l9_1881.y=l9_1897;
if (l9_1885)
{
bool l9_1902=l9_1887;
bool l9_1903;
if (l9_1902)
{
l9_1903=l9_1884.x==3;
}
else
{
l9_1903=l9_1902;
}
float l9_1904=l9_1881.x;
float l9_1905=l9_1886.x;
float l9_1906=l9_1886.z;
bool l9_1907=l9_1903;
float l9_1908=l9_1891;
float l9_1909=fast::clamp(l9_1904,l9_1905,l9_1906);
float l9_1910=step(abs(l9_1904-l9_1909),9.9999997e-06);
l9_1908*=(l9_1910+((1.0-float(l9_1907))*(1.0-l9_1910)));
l9_1904=l9_1909;
l9_1881.x=l9_1904;
l9_1891=l9_1908;
bool l9_1911=l9_1887;
bool l9_1912;
if (l9_1911)
{
l9_1912=l9_1884.y==3;
}
else
{
l9_1912=l9_1911;
}
float l9_1913=l9_1881.y;
float l9_1914=l9_1886.y;
float l9_1915=l9_1886.w;
bool l9_1916=l9_1912;
float l9_1917=l9_1891;
float l9_1918=fast::clamp(l9_1913,l9_1914,l9_1915);
float l9_1919=step(abs(l9_1913-l9_1918),9.9999997e-06);
l9_1917*=(l9_1919+((1.0-float(l9_1916))*(1.0-l9_1919)));
l9_1913=l9_1918;
l9_1881.y=l9_1913;
l9_1891=l9_1917;
}
float2 l9_1920=l9_1881;
bool l9_1921=l9_1882;
float3x3 l9_1922=l9_1883;
if (l9_1921)
{
l9_1920=float2((l9_1922*float3(l9_1920,1.0)).xy);
}
float2 l9_1923=l9_1920;
l9_1881=l9_1923;
float l9_1924=l9_1881.x;
int l9_1925=l9_1884.x;
bool l9_1926=l9_1890;
float l9_1927=l9_1891;
if ((l9_1925==0)||(l9_1925==3))
{
float l9_1928=l9_1924;
float l9_1929=0.0;
float l9_1930=1.0;
bool l9_1931=l9_1926;
float l9_1932=l9_1927;
float l9_1933=fast::clamp(l9_1928,l9_1929,l9_1930);
float l9_1934=step(abs(l9_1928-l9_1933),9.9999997e-06);
l9_1932*=(l9_1934+((1.0-float(l9_1931))*(1.0-l9_1934)));
l9_1928=l9_1933;
l9_1924=l9_1928;
l9_1927=l9_1932;
}
l9_1881.x=l9_1924;
l9_1891=l9_1927;
float l9_1935=l9_1881.y;
int l9_1936=l9_1884.y;
bool l9_1937=l9_1890;
float l9_1938=l9_1891;
if ((l9_1936==0)||(l9_1936==3))
{
float l9_1939=l9_1935;
float l9_1940=0.0;
float l9_1941=1.0;
bool l9_1942=l9_1937;
float l9_1943=l9_1938;
float l9_1944=fast::clamp(l9_1939,l9_1940,l9_1941);
float l9_1945=step(abs(l9_1939-l9_1944),9.9999997e-06);
l9_1943*=(l9_1945+((1.0-float(l9_1942))*(1.0-l9_1945)));
l9_1939=l9_1944;
l9_1935=l9_1939;
l9_1938=l9_1943;
}
l9_1881.y=l9_1935;
l9_1891=l9_1938;
float2 l9_1946=l9_1881;
int l9_1947=l9_1879;
int l9_1948=l9_1880;
float l9_1949=l9_1889;
float2 l9_1950=l9_1946;
int l9_1951=l9_1947;
int l9_1952=l9_1948;
float3 l9_1953=float3(0.0);
if (l9_1951==0)
{
l9_1953=float3(l9_1950,0.0);
}
else
{
if (l9_1951==1)
{
l9_1953=float3(l9_1950.x,(l9_1950.y*0.5)+(0.5-(float(l9_1952)*0.5)),0.0);
}
else
{
l9_1953=float3(l9_1950,float(l9_1952));
}
}
float3 l9_1954=l9_1953;
float3 l9_1955=l9_1954;
float4 l9_1956=sc_set0.baseTex.sample(sc_set0.baseTexSmpSC,l9_1955.xy,bias(l9_1949));
float4 l9_1957=l9_1956;
if (l9_1887)
{
l9_1957=mix(l9_1888,l9_1957,float4(l9_1891));
}
float4 l9_1958=l9_1957;
l9_1872=l9_1958;
l9_1761=l9_1872;
l9_1765=l9_1761;
}
l9_1758=l9_1765;
float l9_1959=0.0;
float4 l9_1960=l9_1758;
float l9_1961=l9_1960.w;
l9_1959=l9_1961;
l9_1752=l9_1959;
l9_1757=l9_1752;
}
l9_1749=l9_1757;
float4 l9_1962=float4(0.0);
l9_1962.x=l9_1746;
l9_1962.y=l9_1746;
l9_1962.z=l9_1746;
l9_1962.w=l9_1749;
l9_1538=l9_1962;
l9_1544=l9_1538;
}
else
{
l9_1544=l9_1539;
}
l9_1536=l9_1544;
l9_1112=l9_1536;
l9_1117=l9_1112;
}
l9_1109=l9_1117;
l9_685=l9_1109;
l9_690=l9_685;
}
l9_682=l9_690;
l9_670=l9_682;
l9_681=l9_670;
}
else
{
l9_681=l9_671;
}
l9_668=l9_681;
l9_226=l9_668;
l9_236=l9_226;
}
l9_223=l9_236;
param_2=l9_223;
param_3=param_2;
}
Result_N11=param_3;
FinalColor=Result_N11;
float param_5=FinalColor.w;
if ((int(sc_BlendMode_AlphaTest_tmp)!=0))
{
if (param_5<(*sc_set0.UserUniforms).alphaTestThreshold)
{
discard_fragment();
}
}
if ((int(ENABLE_STIPPLE_PATTERN_TEST_tmp)!=0))
{
float4 l9_1963=gl_FragCoord;
float2 l9_1964=floor(mod(l9_1963.xy,float2(4.0)));
float l9_1965=(mod(dot(l9_1964,float2(4.0,1.0))*9.0,16.0)+1.0)/17.0;
if (param_5<l9_1965)
{
discard_fragment();
}
}
bool l9_1966=(*sc_set0.UserUniforms).isProxyMode!=0;
if (l9_1966)
{
float4 param_6=FinalColor;
if ((int(sc_ProxyAlphaOne_tmp)!=0))
{
param_6.w=1.0;
}
float4 l9_1967=fast::max(param_6,float4(0.0));
float4 param_7=l9_1967;
if (sc_ShaderCacheConstant_tmp!=0)
{
param_7.x+=((*sc_set0.UserUniforms).sc_UniformConstants.x*float(sc_ShaderCacheConstant_tmp));
}
out.FragColor0=param_7;
return out;
}
float4 param_8=FinalColor;
if ((int(sc_ProjectiveShadowsCaster_tmp)!=0))
{
float4 l9_1968=param_8;
float4 l9_1969=l9_1968;
float l9_1970=1.0;
if ((((int(sc_BlendMode_Normal_tmp)!=0)||(int(sc_BlendMode_AlphaToCoverage_tmp)!=0))||(int(sc_BlendMode_PremultipliedAlphaHardware_tmp)!=0))||(int(sc_BlendMode_PremultipliedAlphaAuto_tmp)!=0))
{
l9_1970=l9_1969.w;
}
else
{
if ((int(sc_BlendMode_PremultipliedAlpha_tmp)!=0))
{
l9_1970=fast::clamp(l9_1969.w*2.0,0.0,1.0);
}
else
{
if ((int(sc_BlendMode_AddWithAlphaFactor_tmp)!=0))
{
l9_1970=fast::clamp(dot(l9_1969.xyz,float3(l9_1969.w)),0.0,1.0);
}
else
{
if ((int(sc_BlendMode_AlphaTest_tmp)!=0))
{
l9_1970=1.0;
}
else
{
if ((int(sc_BlendMode_Multiply_tmp)!=0))
{
l9_1970=(1.0-dot(l9_1969.xyz,float3(0.33333001)))*l9_1969.w;
}
else
{
if ((int(sc_BlendMode_MultiplyOriginal_tmp)!=0))
{
l9_1970=(1.0-fast::clamp(dot(l9_1969.xyz,float3(1.0)),0.0,1.0))*l9_1969.w;
}
else
{
if ((int(sc_BlendMode_ColoredGlass_tmp)!=0))
{
l9_1970=fast::clamp(dot(l9_1969.xyz,float3(1.0)),0.0,1.0)*l9_1969.w;
}
else
{
if ((int(sc_BlendMode_Add_tmp)!=0))
{
l9_1970=fast::clamp(dot(l9_1969.xyz,float3(1.0)),0.0,1.0);
}
else
{
if ((int(sc_BlendMode_AddWithAlphaFactor_tmp)!=0))
{
l9_1970=fast::clamp(dot(l9_1969.xyz,float3(1.0)),0.0,1.0)*l9_1969.w;
}
else
{
if ((int(sc_BlendMode_Screen_tmp)!=0))
{
l9_1970=dot(l9_1969.xyz,float3(0.33333001))*l9_1969.w;
}
else
{
if ((int(sc_BlendMode_Min_tmp)!=0))
{
l9_1970=1.0-fast::clamp(dot(l9_1969.xyz,float3(1.0)),0.0,1.0);
}
else
{
if ((int(sc_BlendMode_Max_tmp)!=0))
{
l9_1970=fast::clamp(dot(l9_1969.xyz,float3(1.0)),0.0,1.0);
}
}
}
}
}
}
}
}
}
}
}
}
float l9_1971=l9_1970;
float l9_1972=l9_1971;
float l9_1973=(*sc_set0.UserUniforms).sc_ShadowDensity*l9_1972;
float3 l9_1974=mix((*sc_set0.UserUniforms).sc_ShadowColor.xyz,(*sc_set0.UserUniforms).sc_ShadowColor.xyz*l9_1968.xyz,float3((*sc_set0.UserUniforms).sc_ShadowColor.w));
float4 l9_1975=float4(l9_1974.x,l9_1974.y,l9_1974.z,l9_1973);
param_8=l9_1975;
}
else
{
if ((int(sc_RenderAlphaToColor_tmp)!=0))
{
param_8=float4(param_8.w);
}
else
{
if ((int(sc_BlendMode_Custom_tmp)!=0))
{
float4 l9_1976=param_8;
float4 l9_1977=float4(0.0);
float4 l9_1978=float4(0.0);
if ((int(sc_FramebufferFetch_tmp)!=0))
{
float4 l9_1979=out.FragColor0;
float4 l9_1980=l9_1979;
l9_1978=l9_1980;
}
else
{
float4 l9_1981=gl_FragCoord;
float2 l9_1982=l9_1981.xy*(*sc_set0.UserUniforms).sc_CurrentRenderTargetDims.zw;
float2 l9_1983=l9_1982;
float2 l9_1984=float2(0.0);
if (sc_StereoRenderingMode_tmp==1)
{
int l9_1985=1;
int l9_1986=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1986=0;
}
else
{
l9_1986=in.varStereoViewID;
}
int l9_1987=l9_1986;
int l9_1988=l9_1987;
float3 l9_1989=float3(l9_1983,0.0);
int l9_1990=l9_1985;
int l9_1991=l9_1988;
if (l9_1990==1)
{
l9_1989.y=((2.0*l9_1989.y)+float(l9_1991))-1.0;
}
float2 l9_1992=l9_1989.xy;
l9_1984=l9_1992;
}
else
{
l9_1984=l9_1983;
}
float2 l9_1993=l9_1984;
float2 l9_1994=l9_1993;
float2 l9_1995=l9_1994;
float2 l9_1996=l9_1995;
float l9_1997=0.0;
int l9_1998;
if ((int(sc_ScreenTextureHasSwappedViews_tmp)!=0))
{
int l9_1999=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_1999=0;
}
else
{
l9_1999=in.varStereoViewID;
}
int l9_2000=l9_1999;
l9_1998=1-l9_2000;
}
else
{
int l9_2001=0;
if (sc_StereoRenderingMode_tmp==0)
{
l9_2001=0;
}
else
{
l9_2001=in.varStereoViewID;
}
int l9_2002=l9_2001;
l9_1998=l9_2002;
}
int l9_2003=l9_1998;
float2 l9_2004=l9_1996;
int l9_2005=sc_ScreenTextureLayout_tmp;
int l9_2006=l9_2003;
float l9_2007=l9_1997;
float2 l9_2008=l9_2004;
int l9_2009=l9_2005;
int l9_2010=l9_2006;
float3 l9_2011=float3(0.0);
if (l9_2009==0)
{
l9_2011=float3(l9_2008,0.0);
}
else
{
if (l9_2009==1)
{
l9_2011=float3(l9_2008.x,(l9_2008.y*0.5)+(0.5-(float(l9_2010)*0.5)),0.0);
}
else
{
l9_2011=float3(l9_2008,float(l9_2010));
}
}
float3 l9_2012=l9_2011;
float3 l9_2013=l9_2012;
float4 l9_2014=sc_set0.sc_ScreenTexture.sample(sc_set0.sc_ScreenTextureSmpSC,l9_2013.xy,bias(l9_2007));
float4 l9_2015=l9_2014;
float4 l9_2016=l9_2015;
l9_1978=l9_2016;
}
float4 l9_2017=l9_1978;
float3 l9_2018=l9_2017.xyz;
float3 l9_2019=l9_2018;
float3 l9_2020=l9_1976.xyz;
float3 l9_2021=definedBlend(l9_2019,l9_2020,in.varStereoViewID,(*sc_set0.UserUniforms),sc_set0.intensityTexture,sc_set0.intensityTextureSmpSC);
l9_1977=float4(l9_2021.x,l9_2021.y,l9_2021.z,l9_1977.w);
float3 l9_2022=mix(l9_2018,l9_1977.xyz,float3(l9_1976.w));
l9_1977=float4(l9_2022.x,l9_2022.y,l9_2022.z,l9_1977.w);
l9_1977.w=1.0;
float4 l9_2023=l9_1977;
param_8=l9_2023;
}
else
{
float4 l9_2024=param_8;
float4 l9_2025=float4(0.0);
if ((int(sc_BlendMode_MultiplyOriginal_tmp)!=0))
{
l9_2025=float4(mix(float3(1.0),l9_2024.xyz,float3(l9_2024.w)),l9_2024.w);
}
else
{
if ((int(sc_BlendMode_Screen_tmp)!=0)||(int(sc_BlendMode_PremultipliedAlphaAuto_tmp)!=0))
{
float l9_2026=l9_2024.w;
if ((int(sc_BlendMode_PremultipliedAlphaAuto_tmp)!=0))
{
l9_2026=fast::clamp(l9_2026,0.0,1.0);
}
l9_2025=float4(l9_2024.xyz*l9_2026,l9_2026);
}
else
{
l9_2025=l9_2024;
}
}
float4 l9_2027=l9_2025;
param_8=l9_2027;
}
}
}
float4 l9_2028=param_8;
FinalColor=l9_2028;
if ((*sc_set0.UserUniforms).PreviewEnabled==1)
{
if (PreviewInfo.Saved)
{
FinalColor=float4(PreviewInfo.Color);
}
else
{
FinalColor=float4(0.0);
}
}
float4 l9_2029=float4(0.0);
l9_2029=float4(0.0);
float4 l9_2030=l9_2029;
float4 Cost=l9_2030;
if (Cost.w>0.0)
{
FinalColor=Cost;
}
FinalColor=fast::max(FinalColor,float4(0.0));
float3 param_9=in.varPos;
float4 param_10=FinalColor;
FinalColor=sc_OutputMotionVectorsIfNeeded(param_9,param_10,in.varStereoViewID,(*sc_set0.UserUniforms));
float4 param_11=FinalColor;
float4 l9_2031=param_11;
if (sc_ShaderCacheConstant_tmp!=0)
{
l9_2031.x+=((*sc_set0.UserUniforms).sc_UniformConstants.x*float(sc_ShaderCacheConstant_tmp));
}
out.FragColor0=l9_2031;
return out;
}
} // FRAGMENT SHADER
